# バッチ設計書 27-LooseForeignKeys::CiPipelinesBuildsCleanupCronWorker

## 概要

本ドキュメントは、CIパイプライン・ビルドに関する疎外部キークリーンアップ処理を行うバッチ処理「LooseForeignKeys::CiPipelinesBuildsCleanupCronWorker」の設計仕様を記載する。

### 本バッチの処理概要

本バッチは、CI関連テーブル（ci_pipelines、ci_builds等）に特化した疎外部キークリーンアップ処理を行う。CI専用データベース接続（Ci::ApplicationRecord）を使用し、CIシステムに関連する削除済みレコードの参照をクリーンアップする。

**業務上の目的・背景**：GitLabのCIシステムは大量のパイプラインとビルドデータを生成する。これらのデータは時間経過とともに削除されるが、従来の外部キー制約による即時削除はパフォーマンスに悪影響を与える。本バッチは、CI関連テーブルに対して専用のクリーンアップ処理を行い、CIデータベースの整合性を非同期で維持する。Turboモードにも対応し、高負荷時でも効率的に処理できる。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。Turboモード（Feature Flag: loose_foreign_keys_turbo_mode_ci）により処理速度を調整可能。

**主要な処理内容**：
1. Turboモード有効/無効に応じてModificationTrackerを選択
2. 排他ロックを取得してProcessDeletedRecordsServiceを実行
3. Ci::ApplicationRecord接続を使用してCI関連テーブルの削除済みレコードを処理
4. 処理統計とTurboモード状態をログに記録

**前後の処理との関連**：通常のCleanupWorkerとは独立して動作し、CI専用のデータベース接続を使用。CI関連のloose_foreign_keys定義に基づいて処理を行う。

**影響範囲**：ci_pipelines、ci_builds等のCI関連テーブルと、それらを参照する関連テーブルに影響。

## バッチ種別

データクレンジング / 参照整合性維持

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cron） |
| 実行時刻 | システム設定による |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 排他ロック取得 | 同一ワーカーが同時実行されていないこと |
| CI DB接続 | Ci::ApplicationRecordへの接続が可能であること |

### 実行可否判定

排他ロック（ExclusiveLease）が取得できない場合はスキップ。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| loose_foreign_keys_deleted_records | DB (CI) | 削除済みレコードの追跡テーブル |
| loose_foreign_keys定義 | 設定 | CI関連テーブルの疎外部キー定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| CI関連テーブル | DB (CI) | 削除またはNULL設定 |
| Sidekiqログ | ログ | 処理統計（stats）、turbo_mode |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. Turboモード判定
   └─ Feature.enabled?(:loose_foreign_keys_turbo_mode_ci, :instance, type: :ops)
2. ModificationTracker初期化
   └─ Turbo: TurboModificationTracker
   └─ 通常: ModificationTracker
3. 排他ロック取得
   └─ in_lock(self.class.name.underscore, ttl: lock_ttl)
   └─ ロック取得失敗時はスキップ（retries: 0）
4. ProcessDeletedRecordsService実行
   └─ connection: Ci::ApplicationRecord.connection
   └─ worker_class: self.class
5. 統計情報ログ出力
   └─ stats, turbo_mode をメタデータとして記録
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{Turboモード有効?}
    B -->|はい| C[TurboModificationTracker初期化]
    B -->|いいえ| D[ModificationTracker初期化]
    C --> E{排他ロック取得}
    D --> E
    E -->|失敗| Z[バッチ終了]
    E -->|成功| F[ProcessDeletedRecordsService実行]
    F --> G[CI DBで削除済みレコード処理]
    G --> H[統計ログ出力]
    H --> Z
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 削除レコード取得 | loose_foreign_keys_deleted_records | SELECT | CI関連の削除対象レコード取得 |
| 参照クリーンアップ | ci_pipelines, ci_builds等 | DELETE/UPDATE | 参照削除またはNULL設定 |
| 削除レコード更新 | loose_foreign_keys_deleted_records | DELETE | 処理済みレコード削除 |

### テーブル別操作詳細

#### loose_foreign_keys_deleted_records (CI DB)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, fully_qualified_table_name, primary_key_value | CI関連テーブルのみ | BATCH_SIZE単位 |
| DELETE | id | 処理完了後 | 処理済みレコード削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ロック取得失敗 | 他インスタンスが実行中 | スキップして次回実行を待機 |
| - | CI DB接続エラー | CIデータベース接続失敗 | 例外発生、ログ記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（retry: false） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

バッチ失敗時は次回のCron実行まで待機。未処理のレコードはloose_foreign_keys_deleted_recordsに残り、次回実行時に処理される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位 |
| コミットタイミング | バッチ処理完了時 |
| ロールバック条件 | 例外発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | BATCH_SIZE（500件）× 処理サイクル |
| 目標処理時間 | max_runtime（ModificationTrackerで制御） |
| メモリ使用量上限 | バッチ処理のため低メモリ使用 |

## 排他制御

- ExclusiveLeaseHelperによる排他ロック
- ロック名: loose_foreign_keys/ci_pipelines_builds_cleanup_cron_worker
- TTL: max_runtime + 10秒
- リトライ: 0回（取得失敗時はスキップ）
- idempotent!が設定されており、重複実行は安全

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 統計ログ | バッチ終了時 | stats（処理件数、削除件数等）、turbo_mode |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理遅延 | modification_tracker.over_limit? | Sidekiqモニタリング |
| エラー発生 | 例外発生時 | システム管理者 |

## 備考

- feature_category: database
- data_consistency: sticky
- idempotent: true
- retry: false
- Turboモード: loose_foreign_keys_turbo_mode_ci Feature Flagで制御
- CI専用データベース接続（Ci::ApplicationRecord）を使用
