# バッチ設計書 31-SshKeys::ExpiredNotificationWorker

## 概要

本ドキュメントは、期限切れSSHキーの通知を行うバッチ処理「SshKeys::ExpiredNotificationWorker」の設計書です。

### 本バッチの処理概要

**業務上の目的・背景**：SSHキーはGitLabにおけるリポジトリへのセキュアなアクセスに使用されます。期限切れのSSHキーを使用し続けることはセキュリティリスクとなるため、ユーザーに対して期限切れの通知を行い、新しいキーの登録を促すことで、システム全体のセキュリティを維持することを目的としています。

**バッチの実行タイミング**：日次で2回（午前2時および午後2時）に実行されます。cronスケジュールは`0 2,14 * * *`で設定されています。

**主要な処理内容**：
1. 当日期限切れかつ未通知のSSHキーをデータベースから抽出
2. Keyset Paginationを使用して500件ずつバッチ処理
3. 対象キーの所有ユーザーを取得
4. ユーザーごとにKeys::ExpiryNotificationServiceを呼び出し、通知メールを送信およびTodo作成
5. 通知済みフラグを更新して重複通知を防止

**前後の処理との関連**：SshKeys::ExpiringSoonNotificationWorkerが事前に「期限切れ間近」の通知を行い、本バッチはその後続処理として「実際に期限切れ」となったキーの通知を行います。

**影響範囲**：期限切れSSHキーを持つユーザーのメール通知、Todoリスト、およびkeysテーブルのexpiry_notification_delivered_atカラム

## バッチ種別

通知配信

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次（2回） |
| 実行時刻 | 02:00, 14:00 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Sidekiq稼働 | Sidekiqワーカーが正常に稼働していること |
| データベース接続 | メインデータベースへの接続が確立されていること |
| メール設定 | SMTPサーバーが設定され、メール送信が可能であること |

### 実行可否判定

- 特別な実行可否判定ロジックは実装されていません
- Sidekiqのジョブスケジューラによって自動的に実行されます

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| keys | DB | SSHキー情報テーブル（期限切れかつ未通知のレコードを抽出） |
| users | DB | ユーザー情報テーブル（キー所有者の取得） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| keys | DB | expiry_notification_delivered_atカラムを更新 |
| todos | DB | 期限切れ通知のTodoレコードを作成 |
| メール | SMTP | 期限切れ通知メールを送信 |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. バッチ開始
   └─ CronjobQueueによって定期実行
2. Keyset Order定義の構築
   └─ expires_at（UTC日付）昇順、id昇順でソート順を定義
3. 期限切れ未通知キーの取得
   └─ Key.expired_today_and_not_notifiedスコープを使用
4. バッチ処理ループ（500件ずつ）
   └─ Keyset Iteratorでページネーション
5. ユーザー単位の処理
   └─ 各ユーザーに対してKeys::ExpiryNotificationServiceを実行
6. 通知処理
   └─ メール送信、Todo作成、通知済みフラグ更新
7. バッチ終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Keyset Order定義構築]
    B --> C[期限切れ未通知キー取得]
    C --> D{キーが存在?}
    D -->|なし| E[バッチ終了]
    D -->|あり| F[500件バッチ取得]
    F --> G[対象ユーザー取得]
    G --> H[ユーザーループ]
    H --> I[ExpiryNotificationService実行]
    I --> J[メール送信・Todo作成]
    J --> K[通知済みフラグ更新]
    K --> L{次のバッチあり?}
    L -->|あり| F
    L -->|なし| E
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| キー取得 | keys | SELECT | 期限切れかつ未通知のSSHキーを取得 |
| ユーザー取得 | users | SELECT | キー所有者のユーザー情報を取得 |
| Todo作成 | todos | INSERT | 期限切れ通知のTodoを作成 |
| 通知フラグ更新 | keys | UPDATE | expiry_notification_delivered_atを更新 |

### テーブル別操作詳細

#### keys

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | expires_at, id, user_id | expires_at = 本日（UTC）かつ expiry_notification_delivered_at IS NULL | Keyset Pagination使用 |
| UPDATE | expiry_notification_delivered_at | Time.current.utc | ユーザー単位で一括更新 |

#### todos

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | target_type, target_id, author_id, user_id, action | SSHキー期限切れ通知用の値 | TodoServiceを経由 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DB接続エラー | データベースへの接続失敗 | Sidekiqの標準リトライで再実行 |
| - | メール送信エラー | SMTP接続失敗 | Sidekiqの標準リトライで再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | すべての例外 |

### 障害時対応

- idempotent!が設定されているため、再実行しても問題なし
- 通知済みフラグにより重複通知は防止される

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ユーザー単位 |
| コミットタイミング | ExpiryNotificationService完了時 |
| ロールバック条件 | サービス内でエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百〜数千件/日 |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | 制限なし（Keyset Paginationにより制御） |

## 排他制御

- CronjobQueueにより同時実行は自動的に防止される
- idempotent!により冪等性が保証される

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 進捗ログ | 処理中 | なし |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ失敗 | 1件以上 | Sidekiqダッシュボード |
| 処理時間 | 設定なし | - |

## 備考

- feature_category: compliance_management
- data_consistency: always
- BATCH_SIZE: 500件
