# バッチ設計書 32-SshKeys::ExpiringSoonNotificationWorker

## 概要

本ドキュメントは、期限切れ間近のSSHキーに対する事前通知を行うバッチ処理「SshKeys::ExpiringSoonNotificationWorker」の設計書です。

### 本バッチの処理概要

**業務上の目的・背景**：SSHキーが期限切れになると、ユーザーはGitLabリポジトリにSSH経由でアクセスできなくなります。事前に期限切れが近いことを通知することで、ユーザーが新しいキーを準備する時間を確保し、業務の中断を防止することを目的としています。セキュリティとユーザビリティのバランスを取るための重要な機能です。

**バッチの実行タイミング**：日次で午前1時に実行されます。cronスケジュールは`0 1 * * *`で設定されています。

**主要な処理内容**：
1. 期限切れが近いSSHキーを持つユーザーをデータベースから抽出
2. 10,000件ずつのバッチでユーザーを処理
3. 各ユーザーの期限切れ間近かつ未通知のキーを取得
4. Keys::ExpiryNotificationServiceを呼び出し、通知メールを送信およびTodo作成
5. before_expiry_notification_delivered_atカラムを更新して重複通知を防止

**前後の処理との関連**：本バッチで「期限切れ間近」の通知を行い、その後SshKeys::ExpiredNotificationWorkerが「実際に期限切れ」となったキーの通知を行います。

**影響範囲**：期限切れ間近のSSHキーを持つユーザーのメール通知、Todoリスト、およびkeysテーブルのbefore_expiry_notification_delivered_atカラム

## バッチ種別

通知配信

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 01:00 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Sidekiq稼働 | Sidekiqワーカーが正常に稼働していること |
| データベース接続 | メインデータベースへの接続が確立されていること |
| メール設定 | SMTPサーバーが設定され、メール送信が可能であること |

### 実行可否判定

- 特別な実行可否判定ロジックは実装されていません
- Sidekiqのジョブスケジューラによって自動的に実行されます

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| users | DB | ユーザー情報テーブル（期限切れ間近キーを持つユーザーを抽出） |
| keys | DB | SSHキー情報テーブル（期限切れ間近かつ未通知のキーを取得） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| keys | DB | before_expiry_notification_delivered_atカラムを更新 |
| todos | DB | 期限切れ間近通知のTodoレコードを作成 |
| メール | SMTP | 期限切れ間近通知メールを送信 |
| ログ | Stdout | 処理対象ユーザーのログ出力 |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. バッチ開始
   └─ CronjobQueueによって定期実行
2. 期限切れ間近キーを持つユーザーの取得
   └─ User.with_ssh_key_expiring_soonスコープを使用
3. バッチ処理ループ（10,000件ずつ）
   └─ find_eachでユーザーを順次処理
4. ログ出力
   └─ 処理対象ユーザーのIDをログ記録
5. 期限切れ間近キーの取得
   └─ user.expiring_soon_and_unnotified_keysを使用
6. 通知処理
   └─ Keys::ExpiryNotificationService実行（expiring_soon: true）
7. バッチ終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[期限切れ間近キーを持つユーザー取得]
    B --> C{ユーザーが存在?}
    C -->|なし| D[バッチ終了]
    C -->|あり| E[10,000件バッチ取得]
    E --> F[ユーザーループ]
    F --> G[ログ出力]
    G --> H[未通知の期限切れ間近キー取得]
    H --> I[ExpiryNotificationService実行]
    I --> J[メール送信・Todo作成]
    J --> K[通知済みフラグ更新]
    K --> L{次のユーザーあり?}
    L -->|あり| F
    L -->|なし| M{次のバッチあり?}
    M -->|あり| E
    M -->|なし| D
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ユーザー取得 | users | SELECT | 期限切れ間近キーを持つユーザーを取得 |
| キー取得 | keys | SELECT | ユーザーの期限切れ間近かつ未通知キーを取得 |
| Todo作成 | todos | INSERT | 期限切れ間近通知のTodoを作成 |
| 通知フラグ更新 | keys | UPDATE | before_expiry_notification_delivered_atを更新 |

### テーブル別操作詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, email等 | with_ssh_key_expiring_soonスコープ条件 | find_each使用 |

#### keys

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | expires_at, before_expiry_notification_delivered_at | 期限切れ間近かつ未通知 | ユーザー単位で取得 |
| UPDATE | before_expiry_notification_delivered_at | Time.current.utc | 通知後に更新 |

#### todos

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | target_type, target_id, action等 | SSHキー期限切れ間近通知用の値 | TodoServiceを経由 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DB接続エラー | データベースへの接続失敗 | Sidekiqの標準リトライで再実行 |
| - | メール送信エラー | SMTP接続失敗 | Sidekiqの標準リトライで再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | すべての例外 |

### 障害時対応

- idempotent!が設定されているため、再実行しても問題なし
- before_expiry_notification_delivered_atフラグにより重複通知は防止される

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ユーザー単位 |
| コミットタイミング | ExpiryNotificationService完了時 |
| ロールバック条件 | サービス内でエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百〜数千件/日 |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | 制限なし（find_eachにより制御） |

## 排他制御

- CronjobQueueにより同時実行は自動的に防止される
- idempotent!により冪等性が保証される

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 進捗ログ | 各ユーザー処理時 | "Notifying User {user_id} about expiring soon ssh key(s)" |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ失敗 | 1件以上 | Sidekiqダッシュボード |
| 処理時間 | 設定なし | - |

## 備考

- feature_category: compliance_management
- data_consistency: always
- バッチサイズ: 10,000件（find_each）
- ExpiredNotificationWorkerの前段処理として機能
