# バッチ設計書 33-ResourceAccessTokens::InactiveTokensDeletionCronWorker

## 概要

本ドキュメントは、非アクティブなリソースアクセストークンを削除するバッチ処理「ResourceAccessTokens::InactiveTokensDeletionCronWorker」の設計書です。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabでは、プロジェクトボット（リソースアクセストークン）がプロジェクトへのアクセスに使用されます。これらのトークンが一定期間非アクティブな状態が続くと、セキュリティリスクとなる可能性があります。本バッチは、設定された期間（inactive_resource_access_tokens_delete_after_days）以上非アクティブなトークンを持つプロジェクトボットユーザーを自動的に削除することで、セキュリティを維持しストレージを最適化します。

**バッチの実行タイミング**：日次で午前0時に実行されます。cronスケジュールは`0 0 * * *`で設定されています。

**主要な処理内容**：
1. アプリケーション設定からinactive_resource_access_tokens_delete_after_daysを取得
2. プロジェクトボットユーザーをバッチ（1,000件ずつ）で処理
3. すべてのトークンがカットオフ日以前に非アクティブ化されたユーザーを特定
4. 対象ユーザーに対してDeleteUserWorkerを非同期で実行
5. 実行時間が3分を超えた場合は次のバッチとして自己スケジュール

**前後の処理との関連**：PersonalAccessTokens関連のクリーンアップバッチと連携し、トークンのライフサイクル管理の一部として機能します。

**影響範囲**：プロジェクトボットユーザー（project_bot）、personal_access_tokensテーブル、関連するプロジェクトリソース

## バッチ種別

データクレンジング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 00:00 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Sidekiq稼働 | Sidekiqワーカーが正常に稼働していること |
| データベース接続 | メインデータベースへの接続が確立されていること |
| 設定値存在 | inactive_resource_access_tokens_delete_after_daysが設定されていること |

### 実行可否判定

- inactive_resource_access_tokens_delete_after_daysが設定されていない場合は処理をスキップ
- 設定値がnilの場合は早期リターン

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| cursor | Integer | No | nil | 前回処理の続きを示すユーザーID |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| users | DB | プロジェクトボットユーザー（project_bot）を抽出 |
| personal_access_tokens | DB | ユーザーのトークン状態を確認 |
| gitlab_current_settings | DB | inactive_resource_access_tokens_delete_after_days設定を取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| users | DB | 対象ユーザーを削除（DeleteUserWorker経由） |
| Sidekiqキュー | ジョブ | DeleteUserWorkerジョブをエンキュー |
| Sidekiqキュー | ジョブ | 継続処理が必要な場合は自己スケジュール |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. バッチ開始
   └─ cursorパラメータを受け取り（初回はnil）
2. 設定値チェック
   └─ inactive_resource_access_tokens_delete_after_daysを取得
3. カットオフ日算出
   └─ 現在日時から設定日数前を算出
4. ランタイムリミッター初期化
   └─ 最大実行時間3分を設定
5. プロジェクトボットユーザーのバッチ処理（1,000件ずつ）
   └─ cursor以降のユーザーをeach_batchで処理
6. 削除対象ユーザーの特定
   └─ アクティブなトークンがない、またはカットオフ日以前に非アクティブ化されたユーザー
7. DeleteUserWorkerをバルク実行
   └─ bulk_perform_async_with_contextsで非同期削除
8. 実行時間チェック
   └─ 3分超過時は2分後に自己スケジュール
9. バッチ終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{設定値が存在?}
    B -->|なし| C[処理スキップ]
    B -->|あり| D[カットオフ日算出]
    D --> E[ランタイムリミッター初期化]
    E --> F[プロジェクトボットを1,000件取得]
    F --> G{ユーザーが存在?}
    G -->|なし| H[バッチ終了]
    G -->|あり| I[非アクティブユーザーを抽出]
    I --> J[DeleteUserWorkerをバルク実行]
    J --> K{実行時間3分超過?}
    K -->|はい| L[2分後に自己スケジュール]
    L --> H
    K -->|いいえ| M{次のバッチあり?}
    M -->|あり| F
    M -->|なし| H
    C --> H
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ユーザー取得 | users | SELECT | プロジェクトボットユーザーを取得 |
| トークン確認 | personal_access_tokens | SELECT | トークンのアクティブ状態を確認（サブクエリ） |
| 設定取得 | application_settings | SELECT | 非アクティブ日数設定を取得 |
| ユーザー削除 | users | DELETE | DeleteUserWorker経由で削除 |

### テーブル別操作詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, username, organization_id | user_type = 'project_bot' かつ id > cursor | バッチ処理用 |
| DELETE | - | DeleteUserWorker経由 | 非同期削除 |

#### personal_access_tokens

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_id | NOT EXISTS条件でアクティブなトークンがないことを確認 | サブクエリ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DB接続エラー | データベースへの接続失敗 | Sidekiqの標準リトライで再実行 |
| - | 設定未定義 | inactive_resource_access_tokens_delete_after_daysが未設定 | 処理をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | すべての例外 |

### 障害時対応

- idempotent!が設定されているため、再実行しても問題なし
- cursorによる継続処理により、中断時も途中から再開可能

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位 |
| コミットタイミング | 各バッチ処理完了時 |
| ロールバック条件 | バッチ内でエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百〜数千件/日 |
| 目標処理時間 | 3分/バッチ（MAX_RUNTIME制限） |
| メモリ使用量上限 | 制限なし（バッチ処理により制御） |

## 排他制御

- CronjobQueueにより同時実行は自動的に防止される
- idempotent!により冪等性が保証される
- cursorによる継続処理で競合を回避

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 進捗ログ | 処理中 | なし |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ失敗 | 1件以上 | Sidekiqダッシュボード |
| 処理時間 | 3分 | 自動で次バッチにスケジュール |

## 備考

- feature_category: system_access
- data_consistency: sticky
- BATCH_SIZE: 1,000件
- MAX_RUNTIME: 3分
- 自己スケジュール間隔: 2分
- DeleteUserWorkerにskip_authorization: trueを渡す
- 削除理由: "No active token assigned"
