# バッチ設計書 38-RemoveExpiredMembersWorker

## 概要

本ドキュメントは、期限切れメンバーを削除するバッチ処理「RemoveExpiredMembersWorker」の設計書です。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabではプロジェクトやグループのメンバーシップに有効期限を設定できます。この機能は一時的なアクセス権付与やセキュリティポリシーの遵守に使用されます。本バッチは、有効期限が切れたメンバーを自動的に削除することで、アクセス制御を適切に維持し、セキュリティリスクを最小化します。また、プロジェクトボットユーザーが期限切れになった場合は、ボットユーザー自体も削除されます。

**バッチの実行タイミング**：日次で午前0時10分に実行されます。cronスケジュールは`10 0 * * *`で設定されています。

**主要な処理内容**：
1. 期限切れのメンバーをKeyset Paginationで1,000件ずつ取得
2. 各メンバーについてMembers::DestroyServiceで削除
3. メンバーがプロジェクトボットの場合は、Users::DestroyServiceでユーザーも削除
4. 処理対象が残っている場合は10秒後に自己スケジュール
5. 削除結果をメタデータとしてログ記録

**前後の処理との関連**：Members::ExpiringWorkerが期限切れ間近のメンバーに通知を行い、本バッチがその後の実際の削除処理を担当します。

**影響範囲**：membersテーブル、usersテーブル（プロジェクトボットの場合）、関連プロジェクト/グループのアクセス権

## バッチ種別

データクレンジング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 00:10 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Sidekiq稼働 | Sidekiqワーカーが正常に稼働していること |
| データベース接続 | メインデータベースへの接続が確立されていること |

### 実行可否判定

- 特別な実行可否判定ロジックは実装されていません
- 期限切れメンバーが存在しない場合は早期終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| cursor | Hash | No | nil | Keyset Paginationのカーソル（継続処理用） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| members | DB | 期限切れのメンバーレコード |
| users | DB | メンバーに紐づくユーザー情報 |
| projects / namespaces | DB | メンバーのソース（プロジェクトまたはグループ） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| members | DB | 期限切れメンバーを削除 |
| users | DB | プロジェクトボットユーザーを削除（該当する場合） |
| Sidekiqキュー | ジョブ | 継続処理が必要な場合は10秒後に自己スケジュール |
| ログ | メタデータ | status、updated_rowsを記録 |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. バッチ開始
   └─ cursorパラメータを受け取り（初回はnil）
2. ページネーション設定
   └─ Keyset Paginationでexpires_at降順、id降順
3. メンバーバッチ取得
   └─ 期限切れメンバーを1,000件取得
4. メンバーループ
   └─ 各メンバーについてprocess_memberを実行
5. メンバー削除
   └─ Members::DestroyService.executeで削除
6. プロジェクトボット判定
   └─ ユーザーがproject_bot?の場合はユーザーも削除
7. エラーハンドリング
   └─ 例外発生時はログ出力して次のメンバーへ
8. 継続判定
   └─ 次ページがある場合は10秒後に自己スケジュール
9. メタデータ記録
   └─ status、updated_rowsを記録
10. バッチ終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Keyset Paginationでページング設定]
    B --> C[期限切れメンバーを1,000件取得]
    C --> D{メンバーが存在?}
    D -->|なし| E[completed状態でメタデータ記録]
    D -->|あり| F[メンバーループ]
    F --> G[ApplicationContext設定]
    G --> H[Members::DestroyService実行]
    H --> I{ユーザーがproject_bot?}
    I -->|はい| J[Users::DestroyService実行]
    I -->|いいえ| K[updated_countインクリメント]
    J --> K
    K --> L{次のメンバーあり?}
    L -->|あり| F
    L -->|いいえ| M{次のページあり?}
    M -->|はい| N[10秒後に自己スケジュール]
    N --> O[limit_reached状態でメタデータ記録]
    M -->|いいえ| E
    O --> P[バッチ終了]
    E --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| メンバー取得 | members | SELECT | 期限切れメンバーをKeyset Paginationで取得 |
| ユーザー取得 | users | SELECT | メンバーに紐づくユーザーを取得（includes） |
| ソース取得 | projects / namespaces | SELECT | メンバーのソースを取得（includes） |
| メンバー削除 | members | DELETE | Members::DestroyServiceを通じて削除 |
| ユーザー削除 | users | DELETE | Users::DestroyServiceを通じて削除 |

### テーブル別操作詳細

#### members

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, expires_at, user_id, source_id, source_type | expires_at < 現在日時 | Keyset Pagination使用 |
| DELETE | - | Members::DestroyService経由 | skip_authorization: true, skip_subresources: true |

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, user_type | membersからincludesで取得 | - |
| DELETE | - | Users::DestroyService経由 | project_bot?の場合のみ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | StandardError | メンバー削除中のエラー | ログ出力して次のメンバーへスキップ |
| - | DB接続エラー | データベースへの接続失敗 | Sidekiqの標準リトライで再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | すべての例外（個別メンバーエラーは内部でハンドリング） |

### 障害時対応

- 個別のメンバー削除エラーは他のメンバーに影響を与えない
- Gitlab::ErrorTracking.track_and_raise_for_dev_exceptionで開発環境でのみ例外を再raise
- cursorによる継続処理により、中断時も途中から再開可能

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | メンバー単位 |
| コミットタイミング | DestroyService完了時 |
| ロールバック条件 | DestroyService内でエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百〜数千件/日 |
| 目標処理時間 | 特に制限なし（BATCH_DELAYで自己制御） |
| メモリ使用量上限 | 制限なし（バッチ処理により制御） |

## 排他制御

- CronjobQueueにより同時実行は自動的に防止される
- worker_resource_boundary: cpuによりリソース制限

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| エラーログ | メンバー削除失敗時 | "Expired Member ID={id} cannot be removed - {error}" |
| 終了ログ | バッチ終了時 | status（completed/limit_reached）、updated_rows |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ失敗 | 1件以上 | Sidekiqダッシュボード |
| 処理時間 | 設定なし | - |

## 備考

- feature_category: system_access
- data_consistency: always
- worker_resource_boundary: cpu
- BATCH_SIZE: 1,000件
- BATCH_DELAY: 10秒
- idempotent!は設定されていない（ステータス変更を伴うため）
- プロジェクトボット削除時の理由: "Membership expired"
- skip_authorization: trueでサービスを呼び出し
- skip_subresources: trueでサブリソースの削除はスキップ
