# バッチ設計書 39-RemoveExpiredGroupLinksWorker

## 概要

本ドキュメントは、期限切れグループリンクを削除するバッチ処理「RemoveExpiredGroupLinksWorker」の設計書です。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabではプロジェクトとグループ間のリンク（ProjectGroupLink）、およびグループ間のリンク（GroupGroupLink）に有効期限を設定できます。これらのリンクは、一時的な共有アクセスや協業プロジェクトに使用されます。本バッチは、有効期限が切れたグループリンクを自動的に削除することで、アクセス制御を適切に維持し、不要な共有関係を解消してセキュリティを確保します。

**バッチの実行タイミング**：日次で午前0時10分に実行されます。cronスケジュールは`10 0 * * *`で設定されています。

**主要な処理内容**：
1. 期限切れのProjectGroupLink（プロジェクト-グループ間リンク）をfind_eachで順次処理
2. Projects::GroupLinks::DestroyServiceで各リンクを削除
3. 期限切れのGroupGroupLink（グループ-グループ間リンク）をfind_in_batchesで取得
4. Groups::GroupLinks::DestroyServiceでバッチ単位で削除

**前後の処理との関連**：RemoveExpiredMembersWorkerと同じタイミングで実行され、アクセス権の自動クリーンアップ処理の一環として機能します。

**影響範囲**：project_group_linksテーブル、group_group_linksテーブル、関連するプロジェクト/グループのアクセス権

## バッチ種別

データクレンジング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 00:10 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Sidekiq稼働 | Sidekiqワーカーが正常に稼働していること |
| データベース接続 | メインデータベースへの接続が確立されていること |

### 実行可否判定

- 特別な実行可否判定ロジックは実装されていません
- 期限切れリンクが存在しない場合は早期終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| project_group_links | DB | プロジェクト-グループ間の期限切れリンク |
| group_group_links | DB | グループ-グループ間の期限切れリンク |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| project_group_links | DB | 期限切れリンクを削除 |
| group_group_links | DB | 期限切れリンクを削除 |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. バッチ開始
   └─ CronjobQueueによって定期実行
2. ProjectGroupLink削除処理
   └─ ProjectGroupLink.expired.find_eachでループ
3. 個別削除
   └─ Projects::GroupLinks::DestroyService.executeで削除
4. GroupGroupLink削除処理
   └─ GroupGroupLink.expired.find_in_batchesでバッチ取得
5. バッチ削除
   └─ Groups::GroupLinks::DestroyService.executeでバッチ削除
6. バッチ終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[期限切れProjectGroupLink取得]
    B --> C{リンクが存在?}
    C -->|なし| D[GroupGroupLink処理へ]
    C -->|あり| E[find_eachでループ]
    E --> F[DestroyService実行]
    F --> G{次のリンクあり?}
    G -->|あり| E
    G -->|なし| D
    D --> H[期限切れGroupGroupLink取得]
    H --> I{リンクが存在?}
    I -->|なし| J[バッチ終了]
    I -->|あり| K[find_in_batchesでバッチ取得]
    K --> L[DestroyService.executeでバッチ削除]
    L --> M{次のバッチあり?}
    M -->|あり| K
    M -->|なし| J
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リンク取得 | project_group_links | SELECT | 期限切れリンクを取得 |
| リンク削除 | project_group_links | DELETE | DestroyServiceを通じて削除 |
| リンク取得 | group_group_links | SELECT | 期限切れリンクをバッチ取得 |
| リンク削除 | group_group_links | DELETE | DestroyServiceを通じてバッチ削除 |

### テーブル別操作詳細

#### project_group_links

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, project_id, group_id, expires_at | expires_at < 現在日時 | expiredスコープ使用 |
| DELETE | - | Projects::GroupLinks::DestroyService経由 | skip_authorization: true |

#### group_group_links

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, shared_group_id, shared_with_group_id, expires_at | expires_at < 現在日時 | expiredスコープ使用 |
| DELETE | - | Groups::GroupLinks::DestroyService経由 | skip_authorization: true |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DB接続エラー | データベースへの接続失敗 | Sidekiqの標準リトライで再実行 |
| - | サービスエラー | DestroyService内でのエラー | Sidekiqの標準リトライで再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | すべての例外 |

### 障害時対応

- 再実行で削除漏れを解消
- idempotent!は設定されていないため、処理途中での失敗時は一部削除済みの可能性あり

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | リンク単位（ProjectGroupLink）/ バッチ単位（GroupGroupLink） |
| コミットタイミング | DestroyService完了時 |
| ロールバック条件 | DestroyService内でエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百件/日 |
| 目標処理時間 | 特に制限なし |
| メモリ使用量上限 | 制限なし（find_each/find_in_batchesにより制御） |

## 排他制御

- CronjobQueueにより同時実行は自動的に防止される

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 進捗ログ | 処理中 | なし |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ失敗 | 1件以上 | Sidekiqダッシュボード |
| 処理時間 | 設定なし | - |

## 備考

- feature_category: user_management
- data_consistency: always
- idempotent!は設定されていない
- ProjectGroupLink: find_eachで個別削除
- GroupGroupLink: find_in_batchesでバッチ削除
- 両方ともskip_authorization: trueでサービスを呼び出し
- Projects::GroupLinks::DestroyServiceには第1引数にlink.projectを渡す
- Groups::GroupLinks::DestroyServiceには第1引数にnilを渡す（オーナー不要）
