# バッチ設計書 4-Ci_StuckBuilds_DropRunningWorker

## 概要

本ドキュメントは、実行中のまま停滞したビルドを削除するバッチ処理「Ci::StuckBuilds::DropRunningWorker」の設計仕様を記載する。

### 本バッチの処理概要

Ci::StuckBuilds::DropRunningWorkerは、実行中（running）状態のまま1時間以上更新がないCIビルドを検出し、失敗（failed）状態に変更するバッチ処理である。ランナーの障害やネットワーク断により、実行中のまま放置されたジョブをクリーンアップする。

**業務上の目的・背景**：CI/CDパイプラインにおいて、ジョブがランナーで実行中になった後、ランナーの障害やネットワーク問題により、ジョブの状態が更新されなくなることがある。これらの「ゾンビジョブ」は、パイプラインの完了を妨げ、並列実行数を圧迫し、ユーザーに誤った実行中状態を表示し続ける。本バッチは、1時間以上更新のない実行中ジョブを検出し、強制的に失敗させることでシステムの健全性を維持する。ただし、明示的にタイムアウトが設定されているジョブは別のワーカー（DropTimedOutWorker）で処理されるため、本ワーカーでは除外される。

**バッチの実行タイミング**：StuckCiJobsWorkerから呼び出され、15分後に実行される。親ワーカーは毎時0分に実行されるため、本ワーカーは毎時15分頃に実行される。

**主要な処理内容**：
1. 排他ロック（ExclusiveLeaseGuard）を取得し、同時実行を防止
2. 各CIパーティションについて、1時間以上更新のない実行中ビルドを検索
3. タイムアウト設定のあるビルドは除外（not_timed_out_builds）
4. 検出されたビルドを100件ずつバッチ処理で失敗状態に更新
5. failure_reasonとして`stuck_or_timeout_failure`を設定

**前後の処理との関連**：本ワーカーはStuckCiJobsWorkerから呼び出される。StuckCiJobsWorkerは親ワーカーとして、本ワーカー、DropScheduledWorker、DropCancelingWorkerを時間をずらして実行する。タイムアウト設定のあるビルドは、Ci::TimedOutBuilds::DropRunningWorkerが別途処理する。

**影響範囲**：全プロジェクトの実行中CIジョブに影響。ジョブが失敗状態に変更されることで、パイプラインの状態が更新され、関連する通知やステータス表示に影響する。

## バッチ種別

データクレンジング / システムメンテナンス

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 60分間隔（親ワーカー経由） |
| 実行時刻 | 毎時15分頃（StuckCiJobsWorkerから15分後） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | StuckCiJobsWorkerからのperform_in |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 排他ロック取得 | ExclusiveLeaseGuardによるロック取得が可能であること |
| 停滞ビルド存在 | 1時間以上更新のない実行中ビルドが存在すること |

### 実行可否判定

排他ロック（ExclusiveLeaseGuard）を取得できた場合のみ処理を実行する。ロックのTTLは30分。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 親ワーカーから引数なしで呼び出し |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ci_builds | DB | CIビルドテーブル |
| ci_partitions | DB | CIパーティション管理テーブル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ci_builds | DB | ステータス更新（failed）、failure_reason設定 |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. 排他ロック取得
   └─ ExclusiveLeaseGuard.try_obtain_leaseでロック取得（TTL: 30分）
2. ログ出力
   └─ "Cleaning running, timed-out builds"をAppLoggerに出力
3. パーティションループ
   └─ Ci::Partition.find_eachで各パーティションを処理
4. 停滞ビルド取得
   └─ not_timed_out_builds.updated_at_before(1.hour.ago).in_partition(partition.id)
5. バッチドロップ処理
   └─ drop(builds, failure_reason: :stuck_or_timeout_failure)
6. ロック解放
   └─ 処理完了後自動解放
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{排他ロック取得}
    B -->|成功| C[パーティション取得]
    B -->|失敗| I[バッチ終了]
    C --> D{パーティション存在?}
    D -->|なし| I
    D -->|あり| E[停滞ビルド検索]
    E --> F{ビルド存在?}
    F -->|なし| G{次のパーティション?}
    F -->|あり| H[ビルドをdrop処理]
    H --> G
    G -->|あり| D
    G -->|なし| I
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パーティション取得 | ci_partitions | SELECT | 全パーティションを取得 |
| 停滞ビルド取得 | ci_builds | SELECT | 1時間以上更新のない実行中ビルドを取得 |
| ビルドステータス更新 | ci_builds | UPDATE | statusをfailedに更新 |

### テーブル別操作詳細

#### ci_builds

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | not_timed_out_builds, updated_at < 1.hour.ago | パーティション別、バッチサイズ100件 |
| UPDATE | status, failure_reason | failed, stuck_or_timeout_failure | drop!メソッドで更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ExclusiveLease取得失敗 | 別プロセスがロック保持中 | スキップ |
| - | StandardError | ビルドdrop処理中のエラー | doom!で代替処理、エラートラッキング |
| - | OptimisticLockingエラー | 同時更新の競合 | 3回リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 3回（OptimisticLocking） |
| リトライ間隔 | 即時 |
| リトライ対象エラー | OptimisticLockingエラー |

### 障害時対応

1. ロック取得失敗の場合：次回実行時に自動復旧
2. ビルドdrop失敗の場合：doom!メソッドで強制終了状態にマーク
3. エラー発生の場合：Gitlab::ErrorTrackingでSentryに報告

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | レコード単位 |
| コミットタイミング | 各ビルドのdrop!完了時 |
| ロールバック条件 | drop!処理中のエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | バッチサイズ100件ずつ処理 |
| 目標処理時間 | 30分以内（ロックTTL） |
| メモリ使用量上限 | バッチサイズ100件による制御 |

## 排他制御

- ExclusiveLeaseGuard（TTL: 30分）による排他制御
- 同時に1プロセスのみ実行可能
- 親ワーカー（StuckCiJobsWorker）とは別のロックを使用

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | サービス開始時 | "Cleaning running, timed-out builds" |
| 進捗ログ | ビルドdrop時 | "Dropping outdated build", build_id, runner_id, status, failure_reason |
| エラーログ | エラー発生時 | 例外情報、build詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 30分超過 | 運用チーム |
| エラー件数 | 多発時 | 運用チーム |
| 削除ジョブ数 | 異常増加時 | 運用チーム |

## 備考

- `idempotent!`が設定されており、冪等性が保証されている
- `data_consistency :always`が設定されており、プライマリDBを使用
- インスタンス全体のクリーンアップクエリのため、CronWorkerContextは無効化
- BUILD_RUNNING_OUTDATED_TIMEOUT = 1.hour で停滞判定
- タイムアウト設定のあるビルドは`not_timed_out_builds`スコープで除外
