# バッチ設計書 41-MemberInvitationReminderEmailsWorker

## 概要

本ドキュメントは、GitLabにおけるメンバー招待リマインダーメール送信バッチ（MemberInvitationReminderEmailsWorker）の設計仕様を定義したものである。

### 本バッチの処理概要

グループやプロジェクトに招待されたが、まだ承諾していないユーザーに対してリマインダーメールを送信するバッチ処理である。

**業務上の目的・背景**：GitLabでは、プロジェクトやグループへの参加を促すために招待機能が提供されている。しかし、招待を受けたユーザーが招待メールを見落としたり、対応を忘れたりするケースがある。このバッチは、未承諾の招待に対して適切なタイミングでリマインダーメールを送信することで、招待の承諾率を向上させ、チームコラボレーションの促進を図ることを目的としている。

**バッチの実行タイミング**：日次実行（毎日0時0分 UTC）

**主要な処理内容**：
1. 未承諾かつ有効期限内の招待を過去10日間分（当日を除く）取得
2. 各招待に対してMembers::InvitationReminderEmailServiceを実行
3. 招待の経過日数に応じたリマインダーメールを送信（2日目、5日目、10日目相当）

**前後の処理との関連**：本バッチは独立して動作し、他のバッチとの直接的な依存関係はない。ただし、RemoveExpiredMembersWorkerによる期限切れ招待の削除処理と連携して動作する。

**影響範囲**：Memberテーブル（招待レコード）、メール送信システム

## バッチ種別

通知配信

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 00:00 (UTC) |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | membersテーブルへの読み取りアクセスが可能であること |
| メールサービス | メール送信システムが正常に稼働していること |

### 実行可否判定

特別な実行可否判定ロジックはなく、cronスケジュールに基づいて常に実行される。対象となる招待が存在しない場合は、処理をスキップして正常終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| members | DB | 未承諾かつ有効期限内の招待レコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| メール送信キュー | Sidekiq Job | リマインダーメールの送信ジョブ |

### 出力ファイル仕様

ファイル出力はなし

## 処理フロー

### 処理シーケンス

```
1. バッチ開始
   └─ CronjobQueueからperformメソッドが呼び出される
2. 対象招待の取得
   └─ Member.not_accepted_invitations.not_expired.last_ten_days_excluding_todayで対象を取得
3. バッチ処理ループ
   └─ find_in_batchesで招待を分割して処理
4. 個別招待処理
   └─ 各招待に対してMembers::InvitationReminderEmailServiceを実行
5. リマインダー判定
   └─ 招待作成日からの経過日数に応じてリマインダー送信可否を判定
6. メール送信
   └─ 該当日（2日目、5日目、10日目相当）の場合にリマインダーメールを送信
7. バッチ終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[対象招待を取得]
    B --> C{招待存在?}
    C -->|なし| G[バッチ終了]
    C -->|あり| D[バッチごとに処理]
    D --> E[InvitationReminderEmailService実行]
    E --> F{リマインダー送信日?}
    F -->|はい| H[リマインダーメール送信]
    F -->|いいえ| I[スキップ]
    H --> J{次の招待?}
    I --> J
    J -->|あり| E
    J -->|なし| G
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 招待取得 | members | SELECT | 未承諾・有効期限内・過去10日間の招待を取得 |

### テーブル別操作詳細

#### members

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | invite_token | NOT NULL | 招待トークンが存在する |
| SELECT | invite_accepted_at | NULL | 招待が未承諾 |
| SELECT | expires_at | > current_date OR NULL | 有効期限内または無期限 |
| SELECT | created_at | 1..10日前（当日除く） | 過去10日間に作成 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | StandardError | メール送信失敗 | Sidekiqのリトライ機構に委ねる |
| - | ActiveRecord::RecordNotFound | 招待レコードが処理中に削除 | 次のレコードの処理を継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | メール送信エラー |

### 障害時対応

バッチ失敗時は次回のcron実行時に再度処理が実行される。対象招待の抽出条件に当日を含まないため、重複送信のリスクは低い。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | レコード単位（find_in_batchesによるバッチ処理） |
| コミットタイミング | 各招待処理完了時 |
| ロールバック条件 | 個別招待処理でのエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 招待数に依存（通常数百〜数千件） |
| 目標処理時間 | 招待数 x 0.1秒程度 |
| メモリ使用量上限 | find_in_batchesによる制御 |

## 排他制御

本バッチはidempotentではなく（rubocop:disable Scalability/IdempotentWorker）、同時実行の厳密な排他制御は行っていない。ただし、cronスケジュールに基づく1日1回の実行であり、実質的な競合リスクは低い。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | ワーカー名、実行開始時刻 |
| 進捗ログ | 各バッチ処理時 | 処理件数 |
| 終了ログ | バッチ終了時 | 実行完了、処理件数 |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 3600秒 | システム管理者 |
| エラー件数 | 10件 | システム管理者 |

## 備考

- REMINDER_RATIOは[2, 5, 10]で定義されており、MAX_INVITATION_LIFESPAN（14日）に対する比率でリマインダー送信日が決定される
- 招待の有効期限が14日未満の場合、リマインダー送信日は比例して早まる
- feature_categoryは「groups_and_projects」に分類される
