# バッチ設計書 43-Members::SchedulePruneDeletionsWorker

## 概要

本ドキュメントは、GitLabにおけるメンバー削除スケジュールのプルーニングバッチ（Members::SchedulePruneDeletionsWorker）の設計仕様を定義したものである。

### 本バッチの処理概要

スケジュールされたメンバー削除処理を実行するための親ワーカーであり、実際の削除処理を行う子ワーカー（Members::PruneDeletionsWorker）を制限付きキャパシティで起動するバッチ処理である。

**業務上の目的・背景**：GitLabではシートコスト管理のために、名前空間からユーザーを削除するスケジュール機能が提供されている。大規模な組織では、一度に多数のメンバーを削除する必要があり、システムへの負荷を制御しながら安全に削除処理を実行する必要がある。本バッチは、LimitedCapacity::Workerパターンを使用して、削除処理の同時実行数を制限しながら効率的にメンバー削除を実行することを目的としている。

**バッチの実行タイミング**：5分間隔で実行

**主要な処理内容**：
1. Members::PruneDeletionsWorker.perform_with_capacityを呼び出す
2. 子ワーカーが制限付きキャパシティで削除スケジュールを処理
3. 各削除スケジュールに対してメンバー削除を実行

**前後の処理との関連**：本バッチは単独で動作し、他のバッチとの直接的な依存関係はない。メンバー削除スケジュールはUI/APIから登録され、本バッチにより処理される。

**影響範囲**：Members::DeletionScheduleテーブル、Memberテーブル

## バッチ種別

データクレンジング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 5分間隔 |
| 実行時刻 | */5（5分ごと） |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | members_deletion_schedulesテーブルへのアクセスが可能であること |
| Sidekiq | 子ワーカーが稼働可能であること |

### 実行可否判定

特別な実行可否判定ロジックはなく、cronスケジュールに基づいて常に実行される。子ワーカーが削除スケジュールの存在を確認し、存在しない場合は処理をスキップする。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| members_deletion_schedules | DB | メンバー削除スケジュールレコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| members | DB | メンバーレコードの削除 |
| members_deletion_schedules | DB | 処理完了したスケジュールの削除 |

### 出力ファイル仕様

ファイル出力はなし

## 処理フロー

### 処理シーケンス

```
1. 親ワーカー開始（SchedulePruneDeletionsWorker）
   └─ CronjobQueueからperformメソッドが呼び出される
2. 子ワーカー起動
   └─ PruneDeletionsWorker.perform_with_capacityを呼び出す
3. 削除スケジュール取得（子ワーカー）
   └─ SCHEDULE_BATCH_SIZE(10)件の削除スケジュールを取得
4. メンバー削除処理（子ワーカー）
   └─ 各スケジュールに対してMEMBER_BATCH_SIZE(100)件ずつメンバーを削除
5. 実行時間制御（子ワーカー）
   └─ ExecutionTrackerで60秒を超えたら処理を中断
6. スケジュールクリーンアップ（子ワーカー）
   └─ 全メンバー削除完了後、削除スケジュールを削除
7. バッチ終了
```

### フローチャート

```mermaid
flowchart TD
    A[SchedulePruneDeletionsWorker開始] --> B[PruneDeletionsWorker.perform_with_capacity]
    B --> C[削除スケジュール取得 SCHEDULE_BATCH_SIZE:10]
    C --> D{スケジュール存在?}
    D -->|なし| J[バッチ終了]
    D -->|あり| E[各スケジュール処理]
    E --> F[メンバー取得 MEMBER_BATCH_SIZE:100]
    F --> G[DestroyService実行]
    G --> H{ExecutionTracker超過?}
    H -->|はい| J
    H -->|いいえ| I{全メンバー削除完了?}
    I -->|はい| K[スケジュール削除]
    I -->|いいえ| F
    K --> L{次のスケジュール?}
    L -->|あり| E
    L -->|なし| J
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| スケジュール取得 | members_deletion_schedules | SELECT | 処理対象のスケジュールを取得 |
| メンバー取得 | members | SELECT | 削除対象のメンバーを取得 |
| メンバー削除 | members | DELETE | DestroyServiceによるメンバー削除 |
| スケジュール削除 | members_deletion_schedules | DELETE | 処理完了したスケジュールを削除 |

### テーブル別操作詳細

#### members_deletion_schedules

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, namespace_id, user_id, scheduled_by_id | 先頭10件を取得 | SCHEDULE_BATCH_SIZE |
| DELETE | - | 全メンバー削除完了時 | cleanup_schedule |

#### members

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | in_hierarchy(namespace).with_user(user) | 階層内のメンバー |
| DELETE | - | DestroyServiceによる削除 | skip_subresources: true |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Gitlab::Access::AccessDeniedError | 削除権限なし | スケジュールをクリーンアップ |
| - | StandardError | その他のエラー | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー |

### 障害時対応

AccessDeniedErrorの場合は削除スケジュールをクリーンアップして処理を継続。その他のエラーは次回実行時に再処理される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 個別メンバー削除単位 |
| コミットタイミング | 各メンバー削除完了時 |
| ロールバック条件 | DestroyServiceでのエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | スケジュール10件 x メンバー100件/スケジュール |
| 目標処理時間 | 60秒以内（ExecutionTracker制限） |
| メモリ使用量上限 | バッチサイズによる制御 |

## 排他制御

- 本バッチはidempotent!で宣言されており、冪等性が保証されている
- MAX_RUNNING_JOBS = 1により、子ワーカーの同時実行数は1に制限
- LimitedCapacity::Workerパターンにより、安全な並行処理を実現

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | ワーカー名、実行開始時刻 |
| 処理ログ | メンバー削除時 | user_id, namespace_id, destroyed_count, destroy_duration_s |
| 終了ログ | バッチ終了時 | 実行完了 |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 300秒 | システム管理者 |
| エラー件数 | 3件 | システム管理者 |
| 残存スケジュール数 | 100件超過 | システム管理者 |

## 備考

- feature_categoryは「seat_cost_management」に分類される
- data_consistencyは「sticky」で、レプリカDBを使用可能
- ExecutionTracker::MAX_RUNTIME（60秒）で処理時間を制限
- skip_subresources: trueにより、サブリソースの削除はスキップされる
- 削除処理は階層（in_hierarchy）内の全メンバーを対象とする
