# バッチ設計書 44-Users::DeactivateDormantUsersWorker

## 概要

本ドキュメントは、GitLabにおける休眠ユーザー非アクティブ化バッチ（Users::DeactivateDormantUsersWorker）の設計仕様を定義したものである。

### 本バッチの処理概要

長期間アクティビティがない休眠ユーザーを自動的に非アクティブ状態に変更するバッチ処理である。

**業務上の目的・背景**：GitLabのセルフホスト環境では、ライセンスコストがアクティブユーザー数に基づいて計算される場合がある。長期間使用していないユーザーアカウントをアクティブのまま維持すると、不要なコストが発生する。本バッチは、設定された非アクティブ期間を超えたユーザーを自動的に非アクティブ化することで、シートコストを最適化し、セキュリティリスクを低減することを目的としている。GitLab.comでは実行されず、セルフホスト環境専用である。

**バッチの実行タイミング**：深夜帯に複数回実行（0:21、0:42、1:21、1:42、2:21、2:42、3:21、3:42、4:21、4:42 UTC）

**主要な処理内容**：
1. 実行可否判定（GitLab.com以外、設定が有効）
2. 休眠ユーザー（最終アクティビティが設定期間を超過）を取得
3. アクティビティがないユーザー（created_atから90日以上経過、last_activity_onがnull）を取得
4. 各ユーザーに対してUsers::DeactivateServiceを実行

**前後の処理との関連**：本バッチは独立して動作する。非アクティブ化されたユーザーは、ログイン時に自動的に再アクティブ化される。

**影響範囲**：usersテーブル（state カラム更新）

## バッチ種別

データクレンジング / シートコスト管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 深夜帯に複数回 |
| 実行時刻 | 21,42 0-4 (0:21、0:42〜4:42) |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| インスタンス種別 | GitLab.comではないこと |
| 設定有効 | deactivate_dormant_usersが有効であること |
| データベース接続 | usersテーブルへのアクセスが可能であること |

### 実行可否判定

```ruby
return if Gitlab.com?
return unless ::Gitlab::CurrentSettings.current_application_settings.deactivate_dormant_users
```

上記条件を満たさない場合、処理を即座に終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| users | DB | 休眠ユーザーおよびアクティビティなしユーザー |
| application_settings | DB | deactivate_dormant_users設定、deactivate_dormant_users_period設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| users | DB | stateカラムを'deactivated'に更新 |

### 出力ファイル仕様

ファイル出力はなし

## 処理フロー

### 処理シーケンス

```
1. バッチ開始
   └─ CronjobQueueからperformメソッドが呼び出される
2. 実行可否判定
   └─ GitLab.com判定、設定確認
3. 休眠ユーザー処理
   └─ User.dormantスコープで対象を取得し、各ユーザーを非アクティブ化
4. アクティビティなしユーザー処理
   └─ User.with_no_activityスコープで対象を取得し、各ユーザーを非アクティブ化
5. 個別ユーザー処理
   └─ admin_botを使用してDeactivateServiceを実行
6. バッチ終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{GitLab.com?}
    B -->|はい| K[バッチ終了]
    B -->|いいえ| C{deactivate_dormant_users有効?}
    C -->|いいえ| K
    C -->|はい| D[休眠ユーザー取得 User.dormant]
    D --> E[各ユーザーを非アクティブ化]
    E --> F[アクティビティなしユーザー取得 User.with_no_activity]
    F --> G[各ユーザーを非アクティブ化]
    G --> H[admin_bot取得]
    H --> I[DeactivateService実行]
    I --> J{次のユーザー?}
    J -->|あり| I
    J -->|なし| K
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定取得 | application_settings | SELECT | 非アクティブ化設定を取得 |
| 休眠ユーザー取得 | users | SELECT | 最終アクティビティが期間超過のユーザーを取得 |
| アクティビティなしユーザー取得 | users | SELECT | last_activity_onがnullで作成から90日以上のユーザーを取得 |
| ユーザー更新 | users | UPDATE | stateを'deactivated'に更新 |

### テーブル別操作詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT (dormant) | state, last_activity_on, user_type | state='active', human_or_service_user, last_activity_on <= deactivate_dormant_users_period.days.ago | 休眠ユーザー |
| SELECT (with_no_activity) | state, last_activity_on, created_at, user_type | state='active', human_or_service_user, last_activity_on IS NULL, created_at <= MINIMUM_DAYS_CREATED.days.ago | アクティビティなし |
| UPDATE | state | 'deactivated' | DeactivateServiceによる |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| forbidden | ServiceResponse::Error | ブロック済みユーザー | スキップして次のユーザーを処理 |
| forbidden | ServiceResponse::Error | 内部ユーザー | スキップして次のユーザーを処理 |
| forbidden | ServiceResponse::Error | アクティブ期間内のユーザー | スキップして次のユーザーを処理 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | DB接続エラー等の一時的エラー |

### 障害時対応

個別ユーザーの処理エラーは次のユーザー処理に影響しない。バッチ全体の障害時は次回実行時に再処理される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ユーザー単位 |
| コミットタイミング | 各ユーザー処理完了時 |
| ロールバック条件 | DeactivateServiceでのエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | インスタンスのユーザー数に依存 |
| 目標処理時間 | each_batchによる制御 |
| メモリ使用量上限 | each_batchによるバッチ処理 |

## 排他制御

本バッチはidempotentではなく（rubocop:disable Scalability/IdempotentWorker）、同時実行の厳密な排他制御は行っていない。ただし、既に非アクティブなユーザーに対してはServiceResponse.success(message: 'User has already been deactivated')が返されるため、冪等性は実質的に確保されている。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | ワーカー名、実行開始時刻 |
| 処理ログ | ユーザー非アクティブ化時 | username, user_id, email, deactivated_by, ip_address |
| 終了ログ | バッチ終了時 | 実行完了 |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 3600秒 | システム管理者 |
| 非アクティブ化件数 | 通常値の10倍超過 | システム管理者 |

## 備考

- feature_categoryは「seat_cost_management」に分類される
- data_consistencyは「always」で、プライマリDBを使用
- GitLab.comでは実行されない（return if Gitlab.com?）
- deactivate_dormant_users_period設定で非アクティブ期間を調整可能
- MINIMUM_DAYS_CREATED（90日）を超えてもアクティビティがないユーザーも対象
- admin_botを使用して処理を実行（Gitlab::Auth::CurrentUserMode.bypass_session!）
- organization_idごとにadmin_botをキャッシュ
