# バッチ設計書 47-Users::UnconfirmedSecondaryEmailsDeletionCronWorker

## 概要

本ドキュメントは、GitLabにおける未確認セカンダリメール削除バッチ（Users::UnconfirmedSecondaryEmailsDeletionCronWorker）の設計仕様を定義したものである。

### 本バッチの処理概要

ユーザーが追加したが確認（verify）されていないセカンダリメールアドレスを、一定期間経過後に自動削除するバッチ処理である。

**業務上の目的・背景**：GitLabでは、ユーザーが複数のメールアドレスをアカウントに関連付けることができる。しかし、追加されたメールアドレスが確認されないまま放置されると、不要なデータが蓄積され、またセキュリティ上のリスクとなる可能性がある。本バッチは、一定期間（設定値で定義）確認されていないセカンダリメールを自動的に削除することで、データベースのクリーンアップとセキュリティの向上を図ることを目的としている。

**バッチの実行タイミング**：1時間間隔で実行（毎時10分）

**主要な処理内容**：
1. 指定期間以上前に作成され、未確認のセカンダリメールを取得
2. バッチサイズ（1000件）ずつ削除
3. 削除対象がなくなるまで繰り返し

**前後の処理との関連**：本バッチは独立して動作し、他のバッチとの直接的な依存関係はない。

**影響範囲**：emailsテーブル（未確認セカンダリメールの削除）

## バッチ種別

データクレンジング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 1時間間隔 |
| 実行時刻 | 10分（毎時） |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | emailsテーブルへのアクセスが可能であること |
| 設定値 | USERS_UNCONFIRMED_SECONDARY_EMAILS_DELETE_AFTER_DAYSが定義されていること |

### 実行可否判定

特別な実行可否判定ロジックはなく、cronスケジュールに基づいて常に実行される。削除対象がない場合は即座に終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| emails | DB | 未確認のセカンダリメールレコード |
| application_settings | 定数 | USERS_UNCONFIRMED_SECONDARY_EMAILS_DELETE_AFTER_DAYS |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| emails | DB | 対象レコードの削除 |

### 出力ファイル仕様

ファイル出力はなし

## 処理フロー

### 処理シーケンス

```
1. バッチ開始
   └─ CronjobQueueからperformメソッドが呼び出される
2. カットオフ日時計算
   └─ USERS_UNCONFIRMED_SECONDARY_EMAILS_DELETE_AFTER_DAYS.days.agoを計算
3. 削除ループ開始
   └─ 無限ループで削除処理を実行
4. 対象レコード取得・削除
   └─ unconfirmed_and_created_beforeスコープで取得し、delete_allで削除
5. 終了判定
   └─ 削除件数が0の場合はループを抜ける
6. バッチ終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[カットオフ日時を計算]
    B --> C[削除ループ開始]
    C --> D[未確認メールを取得 LIMIT:1000]
    D --> E[delete_allで削除]
    E --> F{削除件数 > 0?}
    F -->|はい| C
    F -->|いいえ| G[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| メール取得・削除 | emails | SELECT + DELETE | 未確認かつ古いメールを削除 |

### テーブル別操作詳細

#### emails

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | confirmed_at, created_at | confirmed_at IS NULL AND created_at < カットオフ日時 | 未確認かつ古い |
| DELETE | - | 上記条件に合致するレコード | BATCH_SIZE制限 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ActiveRecord::StatementInvalid | DB接続エラー | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | DB接続エラー等の一時的エラー |

### 障害時対応

バッチ失敗時は次回cron実行時に再処理される。delete_allは各バッチで即時コミットされるため、途中失敗時も処理済み分は保持される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位（BATCH_SIZE件ごと） |
| コミットタイミング | 各delete_all完了時（即時コミット） |
| ロールバック条件 | 個別バッチでのエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 削除対象数に依存 |
| 目標処理時間 | バッチサイズ1000件 x 削除回数 |
| メモリ使用量上限 | BATCH_SIZE: 1000による制御 |

## 排他制御

- idempotent!で宣言されており、冪等性が保証されている
- deduplicate :until_executedにより、実行完了まで重複ジョブを防止
- 同時実行されても、delete_allが原子的に実行されるため、データ不整合は発生しない

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | ワーカー名、実行開始時刻 |
| 終了ログ | バッチ終了時 | 実行完了、総削除件数 |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 600秒 | システム管理者 |
| 削除件数 | 通常値の10倍超過 | システム管理者 |

## 備考

- feature_categoryは「user_management」に分類される
- data_consistencyは「always」で、プライマリDBを使用
- BATCH_SIZE = 1000で定義
- USERS_UNCONFIRMED_SECONDARY_EMAILS_DELETE_AFTER_DAYSはApplicationSettingで定義される定数
- 削除対象はセカンダリメール（プライマリメールは対象外）
- confirmed_atがNULLのレコードが削除対象
- ループ処理により、大量の削除対象があっても安全に処理可能
