# バッチ設計書 48-UserStatusCleanup::BatchWorker

## 概要

本ドキュメントは、GitLabにおけるユーザーステータスクリーンアップバッチ（UserStatusCleanup::BatchWorker）の設計仕様を定義したものである。

### 本バッチの処理概要

期限切れとなったユーザーステータス（カスタムステータスメッセージや絵文字）を自動的に削除するバッチ処理である。

**業務上の目的・背景**：GitLabでは、ユーザーが「休暇中」「ミーティング中」などのカスタムステータスを設定できる。これらのステータスには有効期限を設定することができ、期限が過ぎたステータスは自動的にクリアされる必要がある。本バッチは、期限切れのステータスを定期的にクリーンアップすることで、ユーザーの現在の状況を正確に反映し、古いステータス情報が残留することを防止することを目的としている。

**バッチの実行タイミング**：1分間隔で実行

**主要な処理内容**：
1. クリーンアップ対象のステータスが存在するか確認
2. BatchStatusCleanerServiceを呼び出し、バッチサイズ（100件）ずつ削除
3. MAX_RUNTIME（30秒）を超えるか、削除対象がなくなるまで繰り返し

**前後の処理との関連**：本バッチは独立して動作し、他のバッチとの直接的な依存関係はない。ユーザーがステータスを設定する際にclear_status_atが設定され、本バッチがそれを処理する。

**影響範囲**：user_statusesテーブル（期限切れステータスの削除）

## バッチ種別

データクレンジング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 1分間隔 |
| 実行時刻 | *（毎分） |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | user_statusesテーブルへのアクセスが可能であること |

### 実行可否判定

```ruby
return unless UserStatus.scheduled_for_cleanup.exists?
```

クリーンアップ対象のステータスが存在しない場合は即座に終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| user_statuses | DB | クリーンアップ対象のステータスレコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| user_statuses | DB | 対象レコードの削除 |

### 出力ファイル仕様

ファイル出力はなし

## 処理フロー

### 処理シーケンス

```
1. バッチ開始
   └─ CronjobQueueからperformメソッドが呼び出される
2. 対象存在確認
   └─ UserStatus.scheduled_for_cleanup.exists?で確認
3. 時間計測開始
   └─ Process.clock_gettimeで開始時刻を記録
4. 削除ループ開始
   └─ 無限ループで削除処理を実行
5. サービス呼び出し
   └─ BatchStatusCleanerService.executeで100件ずつ削除
6. 終了判定
   └─ 削除件数がBATCH_SIZE未満、またはMAX_RUNTIME超過でループ終了
7. バッチ終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{クリーンアップ対象存在?}
    B -->|なし| H[バッチ終了]
    B -->|あり| C[開始時刻を記録]
    C --> D[BatchStatusCleanerService実行]
    D --> E{削除件数 < BATCH_SIZE?}
    E -->|はい| H
    E -->|いいえ| F{経過時間 > MAX_RUNTIME?}
    F -->|はい| H
    F -->|いいえ| D
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 存在確認 | user_statuses | SELECT EXISTS | クリーンアップ対象の存在確認 |
| ステータス取得 | user_statuses | SELECT FOR UPDATE SKIP LOCKED | 削除対象を排他的に取得 |
| ステータス削除 | user_statuses | DELETE | 対象レコードの削除 |

### テーブル別操作詳細

#### user_statuses

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT EXISTS | clear_status_at | scheduled_for_cleanupスコープ | 対象存在確認 |
| SELECT FOR UPDATE | user_id | scheduled_for_cleanup, SKIP LOCKED | 排他ロック取得 |
| DELETE | - | user_idサブクエリに基づく | バッチ削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ActiveRecord::StatementInvalid | DB接続エラー | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | DB接続エラー等の一時的エラー |

### 障害時対応

バッチ失敗時は次回cron実行時（1分後）に再処理される。SKIP LOCKEDにより、他のプロセスがロックしているレコードはスキップされる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位（BATCH_SIZE件ごと） |
| コミットタイミング | 各delete_all完了時 |
| ロールバック条件 | 個別バッチでのエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | バッチサイズ100件 x 繰り返し回数 |
| 目標処理時間 | 最大30秒（MAX_RUNTIME） |
| メモリ使用量上限 | BATCH_SIZE: 100による制御 |

## 排他制御

- idempotent!で宣言されており、冪等性が保証されている
- SELECT FOR UPDATE SKIP LOCKEDにより、行レベルの排他制御を実現
- ロックが取得できないレコードはスキップされ、デッドロックを防止

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | ワーカー名、実行開始時刻 |
| 終了ログ | バッチ終了時 | 実行完了、総削除件数 |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 60秒 | システム管理者 |
| 残存クリーンアップ対象数 | 10000件超過 | システム管理者 |

## 備考

- feature_categoryは「user_profile」に分類される
- data_consistencyは「sticky」で、レプリカDBを使用可能
- MAX_RUNTIME = 30.secondsで処理時間を制限
- BATCH_SIZE = 100（BatchStatusCleanerService内で定義）
- Process.clock_gettime(Process::CLOCK_MONOTONIC)で高精度な時間計測
- scheduled_for_cleanupスコープはclear_status_atが過去のレコードを対象
- SKIP LOCKEDにより、並行実行時も安全に処理可能
- 毎分実行により、期限切れステータスは最大1分の遅延でクリアされる
