# バッチ設計書 49-AuthorizedProjectUpdate::PeriodicRecalculateWorker

## 概要

本ドキュメントは、GitLabにおけるプロジェクト権限の定期再計算バッチ（AuthorizedProjectUpdate::PeriodicRecalculateWorker）の設計仕様を定義したものである。

### 本バッチの処理概要

全ユーザーのプロジェクトアクセス権限を定期的に再計算し、整合性を確保するバッチ処理である。

**業務上の目的・背景**：GitLabでは、ユーザーのプロジェクトアクセス権限は複数の要因（直接メンバーシップ、グループメンバーシップ、共有グループ等）から計算される。通常はリアルタイムで更新されるが、エッジケースやシステム障害により権限の不整合が発生する可能性がある。本バッチは、全ユーザーの権限を定期的に再計算することで、権限の整合性を維持し、セキュリティと正確なアクセス制御を確保することを目的としている。

**バッチの実行タイミング**：月2回実行（1日と15日の1時45分 UTC）

**主要な処理内容**：
1. 全ユーザーIDの範囲（min_id〜max_id）を取得
2. BATCH_SIZE（450）件ずつユーザーを分割
3. 各バッチに対してUserRefreshOverUserRangeWorkerを遅延実行でキューイング

**前後の処理との関連**：本バッチは親ワーカーとして動作し、AuthorizedProjectUpdate::UserRefreshOverUserRangeWorkerを子ワーカーとして呼び出す。日常的な権限更新は別のリアルタイムワーカーが担当する。

**影響範囲**：project_authorizationsテーブル（権限の再計算・更新）

## バッチ種別

集計処理 / データ整合性確保

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 月2回 |
| 実行時刻 | 01:45 (UTC) |
| 実行曜日 | - |
| 実行日 | 1日、15日 |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | usersテーブル、project_authorizationsテーブルへのアクセスが可能であること |
| Sidekiq | 子ワーカーをキューイングするためにSidekiqが稼働していること |

### 実行可否判定

```ruby
return if min_id.nil? || max_id.nil?
```

ユーザーが存在しない場合は即座に終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| users | DB | ユーザーID範囲の取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Sidekiq Queue | Sidekiq Job | UserRefreshOverUserRangeWorkerジョブ |

### 出力ファイル仕様

ファイル出力はなし

## 処理フロー

### 処理シーケンス

```
1. バッチ開始
   └─ CronjobQueueからperformメソッドが呼び出される
2. サービス呼び出し
   └─ PeriodicRecalculateService.new.executeを実行
3. ユーザーID範囲取得
   └─ User.minimum(:id)とUser.maximum(:id)を取得
4. 存在確認
   └─ min_idまたはmax_idがnilの場合は終了
5. バッチ分割
   └─ BATCH_SIZE(450)件ずつユーザーIDを分割
6. 遅延キューイング
   └─ DELAY_INTERVAL(50秒) x インデックスの遅延でワーカーをキューイング
7. バッチ終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[PeriodicRecalculateService.execute]
    B --> C[User.minimum/maximum取得]
    C --> D{ユーザー存在?}
    D -->|なし| I[バッチ終了]
    D -->|あり| E[ID範囲をBATCH_SIZE:450で分割]
    E --> F[each_slice.with_index]
    F --> G[UserRefreshOverUserRangeWorker.perform_in]
    G --> H{次のバッチ?}
    H -->|あり| F
    H -->|なし| I
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ID範囲取得 | users | SELECT MIN/MAX | ユーザーID範囲を取得 |

### テーブル別操作詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT MIN | id | - | 最小ユーザーID |
| SELECT MAX | id | - | 最大ユーザーID |

注：実際の権限更新は子ワーカー（UserRefreshOverUserRangeWorker）が担当

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ActiveRecord::StatementInvalid | DB接続エラー | Sidekiqリトライ |
| - | Redis::ConnectionError | Sidekiqキューイング失敗 | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なDB/Redis接続エラー |

### 障害時対応

バッチ失敗時は次回実行日（15日後または翌月1日）に再処理される。子ワーカーの失敗は個別にリトライされる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（キューイングのみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 全ユーザー数 / BATCH_SIZE(450) 個のジョブ |
| 目標処理時間 | キューイングは数秒、実際の処理は子ワーカーで分散 |
| メモリ使用量上限 | ID範囲の計算のみでメモリ効率的 |

## 排他制御

- idempotent!で宣言されており、冪等性が保証されている
- 同じバッチ範囲に対するジョブは重複排除（dedupe）が可能
- with_index(1)により遅延が保証され、ジョブの分散実行を実現

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | ワーカー名、実行開始時刻 |
| 進捗ログ | キューイング時 | キューイングされたジョブ数 |
| 終了ログ | バッチ終了時 | 実行完了、総ジョブ数 |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| キューイング所要時間 | 300秒 | システム管理者 |
| 子ワーカーエラー率 | 5%超過 | システム管理者 |

## 備考

- feature_categoryは「permissions」に分類される
- data_consistencyは「sticky」で、レプリカDBを使用可能
- urgencyは「low」
- BATCH_SIZE = 450で全ユーザーを分割
- DELAY_INTERVAL = 50秒で各バッチジョブを遅延実行
- with_index(1)により、インデックス1から開始（初回から遅延あり）
- 子ワーカーはdata_consistency: delayedのため、初回遅延が必須
- 月2回の実行により、権限の不整合が長期間放置されることを防止
- 日常的な権限更新はリアルタイムワーカーが担当し、本バッチは整合性確保の補完的役割
