# バッチ設計書 50-AdjournedProjectsDeletionCronWorker

## 概要

本ドキュメントは、GitLabにおける猶予期間後プロジェクト削除バッチ（AdjournedProjectsDeletionCronWorker）の設計仕様を定義したものである。

### 本バッチの処理概要

削除マークされてから猶予期間（adjourned period）が経過したプロジェクトを完全に削除するバッチ処理である。

**業務上の目的・背景**：GitLabでは、プロジェクトが削除される際に、誤削除を防ぐための猶予期間を設けることができる。この期間中、プロジェクトは「削除予定」状態となり、管理者やオーナーは削除を取り消すことができる。本バッチは、猶予期間が満了したプロジェクトを自動的に完全削除することで、コンプライアンス管理を支援し、ストレージリソースを解放することを目的としている。この機能は主にエンタープライズ環境での利用を想定している。

**バッチの実行タイミング**：日次実行（毎日7時0分 UTC）

**主要な処理内容**：
1. 削除猶予期間を計算（deletion_adjourned_period設定に基づく）
2. 猶予期間が満了した削除マーク済みプロジェクトを取得
3. 各プロジェクトに対してAdjournedProjectDeletionWorkerを遅延実行でキューイング

**前後の処理との関連**：本バッチは親ワーカーとして動作し、AdjournedProjectDeletionWorkerを子ワーカーとして呼び出す。プロジェクト削除時にmarked_for_deletion_atが設定され、本バッチがそれを処理する。

**影響範囲**：projectsテーブル、関連する全てのプロジェクトリソース（リポジトリ、Issue、MR等）

## バッチ種別

データクレンジング / コンプライアンス管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 07:00 (UTC) |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | projectsテーブルへのアクセスが可能であること |
| 設定値 | deletion_adjourned_periodが設定されていること |
| Sidekiq | 子ワーカーをキューイングするためにSidekiqが稼働していること |

### 実行可否判定

特別な実行可否判定ロジックはなく、cronスケジュールに基づいて常に実行される。対象プロジェクトが存在しない場合は処理をスキップする。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| projects | DB | 削除マーク済みプロジェクト |
| application_settings | DB | deletion_adjourned_period設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Sidekiq Queue | Sidekiq Job | AdjournedProjectDeletionWorkerジョブ |

### 出力ファイル仕様

ファイル出力はなし

## 処理フロー

### 処理シーケンス

```
1. バッチ開始
   └─ CronjobQueueからperformメソッドが呼び出される
2. 削除カットオフ日計算
   └─ deletion_adjourned_period.days.ago.to_dateを計算
3. 対象プロジェクト取得
   └─ marked_for_deletion_before(deletion_cutoff)で対象を取得
4. バッチ処理ループ
   └─ find_each(batch_size: 100)でプロジェクトを処理
5. 遅延キューイング
   └─ INTERVAL(3秒) x インデックスの遅延でワーカーをキューイング
6. コンテキスト設定
   └─ with_context(project, user)でメタデータを設定
7. バッチ終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[削除カットオフ日を計算]
    B --> C[対象プロジェクト取得 with_route.with_deleting_user]
    C --> D{プロジェクト存在?}
    D -->|なし| I[バッチ終了]
    D -->|あり| E[find_each batch_size:100]
    E --> F[delay = index * INTERVAL:3秒]
    F --> G[AdjournedProjectDeletionWorker.perform_in]
    G --> H{次のプロジェクト?}
    H -->|あり| E
    H -->|なし| I
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定取得 | application_settings | SELECT | deletion_adjourned_period取得 |
| プロジェクト取得 | projects | SELECT | 削除対象プロジェクトを取得 |
| ルート取得 | routes | SELECT | プロジェクトのルート情報 |
| ユーザー取得 | users | SELECT | 削除実行ユーザー情報 |

### テーブル別操作詳細

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, marked_for_deletion_at, deleting_user_id | marked_for_deletion_at < deletion_cutoff | カットオフ日以前にマーク |

注：実際の削除処理は子ワーカー（AdjournedProjectDeletionWorker）が担当

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ActiveRecord::StatementInvalid | DB接続エラー | Sidekiqリトライ |
| - | Redis::ConnectionError | Sidekiqキューイング失敗 | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なDB/Redis接続エラー |

### 障害時対応

バッチ失敗時は次回実行日（翌日7時）に再処理される。子ワーカーの失敗は個別にリトライされる（retry: 3）。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（キューイングのみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 削除対象プロジェクト数に依存 |
| 目標処理時間 | プロジェクト数 x 3秒（遅延間隔） |
| メモリ使用量上限 | find_each(batch_size: 100)による制御 |

## 排他制御

本バッチはidempotentではなく（rubocop:disable Scalability/IdempotentWorker）、同時実行の厳密な排他制御は行っていない。ただし、プロジェクト削除処理は子ワーカーがIDベースで実行するため、重複実行のリスクは低い。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | ワーカー名、実行開始時刻 |
| 進捗ログ | キューイング時 | プロジェクトID、遅延時間 |
| 終了ログ | バッチ終了時 | 実行完了、総キューイング数 |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| キューイング所要時間 | 600秒 | システム管理者 |
| 子ワーカーエラー率 | 5%超過 | システム管理者 |
| 削除対象プロジェクト数 | 通常値の10倍超過 | システム管理者 |

## 備考

- feature_categoryは「compliance_management」に分類される
- data_consistencyは「sticky」で、レプリカDBを使用可能
- INTERVAL = 3秒で各プロジェクト削除ジョブを遅延実行
- deletion_adjourned_periodはGitlab::CurrentSettingsから取得
- with_routeとwith_deleting_userでプロジェクトと関連情報を効率的に取得
- with_context(project:, user:)でログやトレーシングのコンテキストを設定
- 子ワーカー（AdjournedProjectDeletionWorker）はretry: 3で設定
- 子ワーカーはProjects::AdjournedDeletionServiceを呼び出して実際の削除を実行
- この機能は元々EE（Enterprise Edition）の機能でCEに移動された
