# バッチ設計書 51-AdjournedGroupDeletionWorker

## 概要

本ドキュメントは、GitLabにおける猶予期間後のグループ削除を実行するバッチ処理「AdjournedGroupDeletionWorker」の設計を定義する。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabでは、グループの削除を即時に行わず、一定の猶予期間（Adjourned Period）を設けて削除をスケジュールする機能がある。これにより、誤ってグループを削除した場合でも猶予期間内であれば復元が可能となる。本バッチは、猶予期間が満了したグループを自動的に検出し、最終的な削除処理を実行することで、ストレージリソースの適切な管理とシステムの整合性を維持する役割を担う。

**バッチの実行タイミング**：Cronジョブとして定期実行（通常は日次）。削除対象のグループを20秒間隔でスケジュールし、システム負荷を分散する。

**主要な処理内容**：
1. 管理者設定から削除猶予期間（deletion_adjourned_period）を取得
2. 猶予期間が満了した削除予定グループをバッチ取得（100件単位）
3. 各グループに対して、削除スケジュール情報から削除実行ユーザーを特定
4. AdjournedDeletionServiceを呼び出し、ユーザーの権限に応じてグループを削除または復元

**前後の処理との関連**：本バッチはGroupDestroyWorkerを間接的に呼び出し、実際のグループ削除を実行する。削除予定のマーキングは別の操作（UI/API経由）で事前に行われる。

**影響範囲**：削除対象となるグループ配下のすべてのプロジェクト、サブグループ、メンバーシップ、関連データに影響。削除は不可逆的な操作となる。

## バッチ種別

データクレンジング / 自動削除処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | Cronジョブ設定に依存 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| deletion_adjourned_period設定 | GitLab管理者設定で削除猶予期間が設定されていること |
| 削除予定グループの存在 | marked_for_deletion_beforeで検出可能なグループが存在すること |
| deletion_scheduleレコードの存在 | グループに紐づく削除スケジュール情報が存在すること |

### 実行可否判定

削除猶予期間（deletion_adjourned_period）日前までにmarked_for_deletionされたグループを対象とする。対象グループが存在しない場合は何も処理せずに終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | Cronジョブのため引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| groups | DB | 削除予定のグループ一覧 |
| group_deletion_schedules | DB | グループ削除スケジュール情報 |
| application_settings | DB | 削除猶予期間の設定値 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GroupDestroyWorkerキュー | Sidekiq | 削除ジョブのエンキュー |
| groups | DB | グループの削除（または復元） |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. 削除猶予期間のカットオフ日を計算
   └─ Gitlab::CurrentSettings.deletion_adjourned_period.days.ago.to_date
2. 削除対象グループを検索
   └─ marked_for_deletion_before(cutoff)、with_deletion_scheduleでフィルタ
3. 100件単位でバッチ処理
   └─ find_each(batch_size: 100)でメモリ効率的に処理
4. 各グループの削除スケジュールから削除実行ユーザーを取得
   └─ deletion_schedule.deleting_user
5. 遅延時間を計算（インデックス * 20秒）
   └─ システム負荷分散のため
6. AdjournedDeletionServiceを実行
   └─ 権限確認後、削除または復元を実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[削除猶予期間カットオフ日を計算]
    B --> C[削除対象グループを検索]
    C --> D{対象グループあり?}
    D -->|なし| E[バッチ終了]
    D -->|あり| F[100件単位でバッチ取得]
    F --> G[削除スケジュールからユーザー取得]
    G --> H[遅延時間を計算 index * 20秒]
    H --> I[AdjournedDeletionService実行]
    I --> J{ユーザーに削除権限あり?}
    J -->|あり| K[GroupDestroyWorker.perform_in]
    J -->|なし| L[Groups::RestoreService実行]
    K --> M{次のグループあり?}
    L --> M
    M -->|あり| G
    M -->|なし| E
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 削除対象検索 | groups | SELECT | marked_for_deletion_onで削除予定グループを検索 |
| スケジュール取得 | group_deletion_schedules | SELECT | 削除スケジュール情報を取得 |
| グループ削除 | groups | DELETE | GroupDestroyWorker経由で削除（別ジョブ） |
| グループ復元 | groups | UPDATE | 権限不足時にmarked_for_deletionをクリア |

### テーブル別操作詳細

#### groups

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, marked_for_deletion_on | marked_for_deletion_on < カットオフ日 | with_routeで関連データも取得 |

#### group_deletion_schedules

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_id, group_id | group_idで結合 | 削除実行ユーザーを特定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | 削除ユーザーがremove_group権限を持たない | グループを復元処理に切り替え |
| - | DB接続エラー | データベース接続失敗 | Sidekiqによるリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | すべての例外 |

### 障害時対応

バッチ失敗時は次回のCronスケジュールで再実行される。個別のグループ削除失敗はGroupDestroyWorkerのリトライ機構で対応。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 個別グループ単位（遅延実行のため） |
| コミットタイミング | 各グループの処理完了時 |
| ロールバック条件 | 例外発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百件/日（通常運用時） |
| 目標処理時間 | 対象件数 * 20秒（遅延スケジュールのため） |
| メモリ使用量上限 | find_eachによるバッチ処理で制限 |

## 排他制御

グループ削除は20秒間隔でスケジュールされるため、同時実行による負荷集中を回避。GroupDestroyWorker側で個別グループのロックを管理。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 処理開始の記録 |
| 進捗ログ | 各グループ処理時 | with_contextによるnamespace/user情報 |
| 終了ログ | バッチ終了時 | 処理完了の記録 |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 設定なし（遅延実行のため） | 管理者 |
| エラー件数 | Sidekiq失敗キュー | 運用チーム |

## 備考

- EEからCEに移動されたクラス（rubocop:disable コメント参照）
- data_consistency: :sticky を使用（レプリカ読み取りに注意）
- 削除猶予期間はGitLab管理者設定（Settings）で変更可能
