# バッチ設計書 52-InactiveProjectsDeletionCronWorker

## 概要

本ドキュメントは、GitLabにおける非アクティブプロジェクトの自動削除を実行するバッチ処理「Projects::InactiveProjectsDeletionCronWorker」の設計を定義する。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabインスタンスでは、長期間使用されていない（非アクティブな）プロジェクトがストレージリソースを消費し続ける問題がある。本バッチは、管理者が設定した非アクティブ期間を超えたプロジェクトを検出し、削除警告メールの送信と、猶予期間経過後の自動削除を行う。これにより、ストレージコストの最適化とシステムリソースの効率的な利用を実現する。

**バッチの実行タイミング**：10分間隔でCronジョブとして実行。ただし、最大実行時間は4分に制限され、次回実行との重複を避けつつ処理を継続する。

**主要な処理内容**：
1. 非アクティブプロジェクト削除機能の有効化確認
2. 前回処理中断位置からの再開（Redisで管理）
3. 休眠状態のプロジェクトをバッチ取得（100件単位）
4. 各プロジェクトに対して警告メール送信または削除処理を実行
5. 処理時間が4分を超えた場合は中断し、次回実行で継続

**前後の処理との関連**：InactiveProjectsDeletionNotificationWorkerと連携して警告メールを送信。実際の削除はProjects::MarkForDeletionServiceを通じてAdjournedProjectsDeletionCronWorkerに引き継がれる。

**影響範囲**：対象プロジェクトのすべてのリポジトリ、CI/CDパイプライン、Issues、マージリクエスト等の関連データに影響。削除は猶予期間後に不可逆的となる。

## バッチ種別

データクレンジング / 自動削除処理 / 通知配信

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 10分間隔 |
| 実行時刻 | 常時 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| delete_inactive_projects設定 | Gitlab::CurrentSettings.delete_inactive_projects?がtrue |
| 非アクティブ期間設定 | inactive_projects_delete_after_months設定が存在 |
| 警告メール送信期間設定 | inactive_projects_send_warning_email_after_months設定が存在 |

### 実行可否判定

`Gitlab::CurrentSettings.delete_inactive_projects?`がfalseの場合は即時終了。設定が有効な場合のみ処理を実行する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | Cronジョブのため引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| projects | DB | プロジェクト一覧 |
| application_settings | DB | 非アクティブ期間の設定値 |
| Redis | Cache | 前回処理位置、警告送信済みプロジェクト一覧 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| InactiveProjectsDeletionNotificationWorkerキュー | Sidekiq | 警告メール送信ジョブ |
| projects | DB | marked_for_deletion_on更新 |
| Redis | Cache | 処理位置、警告送信済み情報 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. 削除機能有効化チェック
   └─ delete_inactive_projects?がfalseなら終了
2. 処理開始時刻を記録
   └─ Gitlab::Metrics::System.monotonic_time
3. 警告済みプロジェクト一覧をRedisから取得
   └─ DormantProjectsDeletionWarningTracker.notified_projects
4. 前回中断位置からプロジェクトを取得
   └─ last_processed_project_idから再開
5. 100件単位でバッチ処理
   └─ dormant.not_aimed_for_deletionでフィルタ
6. 各プロジェクトに対して処理
   ├─ 処理時間チェック（4分超過で中断）
   ├─ 警告未送信の場合：通知ワーカーをキュー
   └─ 猶予期間経過の場合：削除サービスを実行
7. 全件処理完了時はRedisの中断位置をリセット
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{delete_inactive_projects?}
    B -->|No| C[バッチ終了]
    B -->|Yes| D[開始時刻記録]
    D --> E[警告済みプロジェクト取得]
    E --> F[前回中断位置から取得]
    F --> G[100件バッチ取得]
    G --> H{非アクティブプロジェクトあり?}
    H -->|なし| I[中断位置リセット]
    H -->|あり| J{処理時間 > 4分?}
    J -->|Yes| K[中断位置保存]
    K --> L[TimeoutError発生]
    L --> C
    J -->|No| M{警告メール送信済み?}
    M -->|No| N[通知ワーカーをキュー]
    N --> O[監査イベント記録]
    M -->|Yes| P{猶予期間経過?}
    P -->|No| Q[次のプロジェクトへ]
    P -->|Yes| R[警告トラッカーリセット]
    R --> S[MarkForDeletionService実行]
    S --> Q
    O --> Q
    Q --> H
    I --> C
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| プロジェクト検索 | projects | SELECT | dormant.not_aimed_for_deletionでフィルタ |
| 削除マーク | projects | UPDATE | marked_for_deletion_onを設定 |
| 設定取得 | application_settings | SELECT | 各種期間設定を取得 |

### テーブル別操作詳細

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, organization_id | id > last_processed_project_id, dormantスコープ適用 | バッチ取得 |
| UPDATE | marked_for_deletion_on | 現在日時 | MarkForDeletionService経由 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TimeoutError | タイムアウト | 処理時間が4分を超過 | 中断位置を保存し次回継続 |
| - | DB接続エラー | データベース接続失敗 | Sidekiqによるリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | TimeoutError以外の例外 |

### 障害時対応

TimeoutErrorは正常な中断処理のため、次回実行で継続。その他のエラーはSidekiqリトライ機構で対応。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 個別プロジェクト単位 |
| コミットタイミング | 各プロジェクトの処理完了時 |
| ロールバック条件 | 例外発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 変動（非アクティブプロジェクト数による） |
| 目標処理時間 | 最大4分（MAX_RUN_TIME） |
| メモリ使用量上限 | each_batchによるバッチ処理で制限 |

## 排他制御

CronWorkerContextによる重複実行防止。中断位置のRedis管理により、複数インスタンス間での処理の重複を回避。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 処理開始 |
| 進捗ログ | 各プロジェクト処理時 | with_contextによるproject/user情報 |
| 終了ログ | バッチ終了時 | 処理完了または中断 |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 4分（設計上の上限） | 管理者 |
| エラー件数 | Sidekiq失敗キュー | 運用チーム |

## 備考

- idempotent!指定あり（冪等性保証）
- data_consistency: :always を使用
- urgency: :low 指定（低優先度キュー）
- 監査イベント記録はEE版で実装（log_audit_eventメソッド）
- 組織ごとにadmin_botユーザーを使用して処理を実行
