# バッチ設計書 53-ScheduleRefreshBuildArtifactsSizeStatisticsWorker

## 概要

本ドキュメントは、GitLabにおけるビルドアーティファクトサイズ統計の更新をスケジュールするバッチ処理「Projects::ScheduleRefreshBuildArtifactsSizeStatisticsWorker」の設計を定義する。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabでは、プロジェクトごとにビルドアーティファクト（CI/CDで生成される成果物）のサイズを追跡し、ストレージ使用量の把握やクォータ管理に利用している。プロジェクト統計情報の正確性を維持するため、定期的にアーティファクトサイズの再計算が必要となる。本バッチは、RefreshBuildArtifactsSizeStatisticsWorkerを容量制限付きで実行し、システム負荷を分散しながら統計更新を行う。

**バッチの実行タイミング**：Cronジョブとして定期実行。実際の更新処理はLimitedCapacity::Workerパターンで並列実行数を制御しながら実行される。

**主要な処理内容**：
1. RefreshBuildArtifactsSizeStatisticsWorkerのperform_with_capacityを呼び出し
2. 容量制限に基づいて実際の更新ワーカーをキューイング
3. 各ワーカーがRefreshBuildArtifactsSizeStatisticsServiceを実行

**前後の処理との関連**：本バッチはスケジューラとして機能し、実際の処理はRefreshBuildArtifactsSizeStatisticsWorkerが実行。更新対象はProjects::BuildArtifactsSizeRefreshテーブルで管理される。

**影響範囲**：project_statisticsテーブルのbuild_artifacts_sizeカラムが更新される。ストレージ使用量表示、クォータ計算に影響。

## バッチ種別

集計処理 / 統計更新スケジューラ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cron設定に依存） |
| 実行時刻 | Cron設定に依存 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Feature Flag | projects_build_artifacts_size_refresh系のフラグで容量制御 |
| 更新対象レコード | BuildArtifactsSizeRefresh.remainingに対象が存在 |

### 実行可否判定

Feature Flagの状態によりmax_running_jobsが決定。0の場合は実質的に処理がスキップされる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | Cronジョブのため引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| projects_build_artifacts_size_refresh | DB | 更新対象プロジェクト一覧 |
| feature_flags | DB | 並列実行数制御フラグ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| RefreshBuildArtifactsSizeStatisticsWorkerキュー | Sidekiq | 実際の更新ワーカージョブ |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. Cronトリガーでperform実行
   └─ ScheduleRefreshBuildArtifactsSizeStatisticsWorker.perform
2. 実際の更新ワーカーをキューイング
   └─ RefreshBuildArtifactsSizeStatisticsWorker.perform_with_capacity
3. 更新ワーカーが容量制限内で実行
   └─ LimitedCapacity::Workerパターンで並列数制御
4. 各ワーカーがサービスを実行
   └─ RefreshBuildArtifactsSizeStatisticsService.execute
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[perform_with_capacity呼び出し]
    B --> C{max_running_jobs > 0?}
    C -->|No| D[バッチ終了]
    C -->|Yes| E[remaining_work_count確認]
    E --> F{残作業あり?}
    F -->|No| D
    F -->|Yes| G[RefreshWorkerをキュー]
    G --> H[RefreshService実行]
    H --> I[統計更新]
    I --> J[メタデータログ出力]
    J --> K{更新完了?}
    K -->|No| E
    K -->|Yes| D
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 対象確認 | projects_build_artifacts_size_refresh | SELECT | remaining.any?で存在確認 |
| 統計更新 | project_statistics | UPDATE | build_artifacts_size更新 |
| 進捗更新 | projects_build_artifacts_size_refresh | UPDATE/DELETE | last_job_artifact_id更新、完了時削除 |

### テーブル別操作詳細

#### projects_build_artifacts_size_refresh

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, project_id | remainingスコープ | 対象存在確認 |
| UPDATE | last_job_artifact_id | 処理済みアーティファクトID | 進捗管理 |
| DELETE | - | 処理完了時 | refresh.destroyed? |

#### project_statistics

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | build_artifacts_size | 再計算値 | サービス経由で更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DB接続エラー | データベース接続失敗 | Sidekiqによるリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | すべての例外 |

### 障害時対応

個別の更新ワーカー失敗はSidekiqリトライで対応。スケジューラ自体の失敗は次回Cron実行で再試行。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 個別プロジェクト単位（RefreshWorker内） |
| コミットタイミング | 各プロジェクトの更新完了時 |
| ロールバック条件 | 例外発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | Feature Flagで制御される並列数に依存 |
| 目標処理時間 | 継続処理のため上限なし |
| メモリ使用量上限 | LimitedCapacity::Workerで並列数制限 |

## 排他制御

LimitedCapacity::Workerパターンにより、同時実行数を制御：
- MAX_RUNNING_LOW: 1
- MAX_RUNNING_MEDIUM: 3
- MAX_RUNNING_HIGH: 5

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| メタデータ | 各更新完了時 | refresh_id, project_id, last_job_artifact_id, last_batch, refresh_started_at |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| エラー件数 | Sidekiq失敗キュー | 運用チーム |

## 備考

- idempotent!指定あり（冪等性保証）
- data_consistency: :always を使用
- feature_category: :job_artifacts
- Feature Flagで処理速度を段階的に調整可能
  - projects_build_artifacts_size_refresh: 低速（1並列）
  - projects_build_artifacts_size_refresh_medium: 中速（3並列）
  - projects_build_artifacts_size_refresh_high: 高速（5並列）
