# バッチ設計書 54-TrendingProjectsWorker

## 概要

本ドキュメントは、GitLabにおけるトレンドプロジェクト一覧を更新するバッチ処理「TrendingProjectsWorker」の設計を定義する。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabでは、ユーザーに人気のあるプロジェクトを「トレンドプロジェクト」として表示する機能がある。トレンドの判定は、直近1ヶ月間のノート（コメント）活動量に基づいて行われる。本バッチは、この集計を定期的に実行し、トレンドプロジェクト一覧を最新の状態に更新することで、ユーザーがアクティブなプロジェクトを発見しやすくする。

**バッチの実行タイミング**：Cronジョブとして定期実行（通常は日次）。ログに「Refreshing trending projects」を出力してから処理を開始。

**主要な処理内容**：
1. 既存のトレンドプロジェクトデータを全削除
2. 直近1ヶ月間のノート（システムノート除外）をプロジェクトごとに集計
3. パブリックプロジェクトのみを対象に、ノート数の多い上位100件を抽出
4. 新しいトレンドプロジェクト一覧をINSERT

**前後の処理との関連**：独立したバッチ処理。トレンドプロジェクト一覧はExplore画面などで参照される。

**影響範囲**：trending_projectsテーブルのデータが完全に入れ替わる。Explore画面でのトレンドプロジェクト表示に影響。

## バッチ種別

集計処理 / データ更新

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次（Cron設定に依存） |
| 実行時刻 | Cron設定に依存 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| notesテーブル | 集計対象のノートデータが存在 |
| projectsテーブル | パブリックプロジェクトが存在 |

### 実行可否判定

特別な実行条件なし。常に実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | Cronジョブのため引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| notes | DB | ノート（コメント）データ |
| projects | DB | プロジェクト一覧（パブリックのみ） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| trending_projects | DB | トレンドプロジェクト一覧 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. ログ出力
   └─ Gitlab::AppLogger.info('Refreshing trending projects')
2. TrendingProject.refresh!を実行
   └─ トランザクション開始
3. 既存データの全削除
   └─ TrendingProject.delete_all
4. 集計SQLの実行
   └─ notesテーブルを集計し、trending_projectsにINSERT
5. トランザクションコミット
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ログ出力]
    B --> C[TrendingProject.refresh!]
    C --> D[トランザクション開始]
    D --> E[trending_projects全削除]
    E --> F[集計SQL実行]
    F --> G[notesテーブルをproject_idでGROUP BY]
    G --> H[パブリックプロジェクトのみフィルタ]
    H --> I[ノート数でORDER BY DESC]
    I --> J[上位100件をLIMIT]
    J --> K[trending_projectsにINSERT]
    K --> L[トランザクションコミット]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| データ削除 | trending_projects | DELETE | 全レコード削除 |
| 集計 | notes | SELECT | 1ヶ月以内のノートを集計 |
| 結合 | projects | JOIN | パブリックプロジェクトのフィルタ |
| データ挿入 | trending_projects | INSERT | 上位100件を挿入 |

### テーブル別操作詳細

#### trending_projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | 全レコード | トランザクション内 |
| INSERT | project_id | 集計結果のproject_id | 上位100件 |

#### notes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | project_id | created_at >= 1ヶ月前, system = FALSE | GROUP BYで集計 |

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| JOIN | id, visibility_level | visibility_level = PUBLIC(20) | 結合条件 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DB接続エラー | データベース接続失敗 | Sidekiqによるリトライ |
| - | トランザクションエラー | INSERT失敗 | 自動ロールバック |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | すべての例外 |

### 障害時対応

トランザクション内で処理するため、失敗時は自動的にロールバックされ、既存データが維持される。次回実行で再試行。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 全体（DELETE + INSERT） |
| コミットタイミング | INSERT完了後 |
| ロールバック条件 | 例外発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 100件（上限固定） |
| 目標処理時間 | 数秒〜数十秒（notesテーブルサイズに依存） |
| メモリ使用量上限 | SQLベースの集計のため低メモリ |

## 排他制御

トランザクションによるデータ整合性保証。DELETE〜INSERT間で一時的にデータが空になることを防ぐ。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 'Refreshing trending projects' |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 設定なし | - |
| エラー件数 | Sidekiq失敗キュー | 運用チーム |

## 備考

- data_consistency: :always を使用
- feature_category: :source_code_management
- MONTHS_TO_INCLUDE = 1（集計対象期間）
- PROJECTS_LIMIT = 100（上限件数）
- パブリックプロジェクト（visibility_level = 20）のみが対象
- システムノート（note.system = TRUE）は集計から除外
