# バッチ設計書 56-RepositoryArchiveCacheWorker

## 概要

本ドキュメントは、GitLabにおけるリポジトリアーカイブキャッシュのクリーンアップを実行するバッチ処理「RepositoryArchiveCacheWorker」の設計を定義する。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabでは、リポジトリのアーカイブ（zip、tar、tar.gz、bz2形式）をダウンロードする際、Gitalyが生成したアーカイブファイルがキャッシュとして保存される。これらのキャッシュファイルは一定時間経過すると不要になるが、自動的に削除されないとストレージを圧迫する。本バッチは、古いアーカイブキャッシュファイルと空になったディレクトリを定期的に削除し、ストレージリソースを効率的に管理する。

**バッチの実行タイミング**：Cronジョブとして定期実行。キャッシュの有効期限（デフォルト120分）を超えたファイルを削除対象とする。

**主要な処理内容**：
1. RepositoryArchiveCleanUpServiceを呼び出し
2. 指定ディレクトリ配下の古いアーカイブファイルを検索・削除（findコマンド）
3. 空になったディレクトリを検索・削除

**前後の処理との関連**：独立したクリーンアップ処理。Gitalyがアーカイブを生成し、GitLab Workhorse経由でユーザーに配信された後のキャッシュ管理を担当。

**影響範囲**：repository_downloads_pathディレクトリ配下のキャッシュファイル。削除されたファイルは次回リクエスト時に再生成される。

## バッチ種別

データクレンジング / キャッシュ管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cron設定に依存） |
| 実行時刻 | Cron設定に依存 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| repository_downloads_path | アーカイブキャッシュディレクトリが存在 |

### 実行可否判定

キャッシュディレクトリが存在しない場合は何も処理せずに終了。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | Cronジョブのため引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ファイルシステム | ディレクトリ | repository_downloads_path配下のキャッシュ |
| gitlab.yml | Config | repository_downloads_pathの設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ファイルシステム | 削除 | 古いアーカイブファイルと空ディレクトリの削除 |

### 出力ファイル仕様

ファイル出力なし（削除処理のみ）

## 処理フロー

### 処理シーケンス

```
1. RepositoryArchiveCleanUpService.executeを実行
   └─ Gitlab::Metrics.measureでパフォーマンス計測
2. キャッシュディレクトリの存在確認
   └─ File.directory?(path)
3. 古いアーカイブファイルを削除
   └─ find -mmin +120 -delete（デフォルト120分以上前）
4. 空ディレクトリを削除
   └─ 深い階層から順に空ディレクトリを削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[RepositoryArchiveCleanUpService.execute]
    B --> C{キャッシュディレクトリ存在?}
    C -->|No| D[バッチ終了]
    C -->|Yes| E[古いアーカイブファイル削除]
    E --> F[find -type f -mmin +120 -delete]
    F --> G[空ディレクトリ削除]
    G --> H[depth 3から1まで順に処理]
    H --> I[find -type d -empty -delete]
    I --> D
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | ファイルシステム操作のみ |

### テーブル別操作詳細

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | パーミッションエラー | ファイル削除権限なし | ログ出力、次回リトライ |
| - | ディスクエラー | ファイルシステム異常 | Sidekiqによるリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | すべての例外 |

### 障害時対応

ファイル削除に失敗しても次回実行で再試行される。キャッシュファイルは一時的なものなので、削除失敗の影響は限定的。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | キャッシュファイル数に依存 |
| 目標処理時間 | findコマンドの実行時間（ファイル数に比例） |
| メモリ使用量上限 | 低（外部コマンド実行） |

## 排他制御

特になし。findコマンドはファイル単位で処理するため、同時実行による問題は発生しにくい。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| パフォーマンスログ | 処理完了時 | Gitlab::Metrics.measureによる計測結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| エラー件数 | Sidekiq失敗キュー | 運用チーム |

## 備考

- data_consistency: :always を使用
- feature_category: :source_code_management
- LAST_MODIFIED_TIME_IN_MINUTES = 120（デフォルト削除閾値）
- MAX_ARCHIVE_DEPTH = 4（検索深度）
- 対象ファイル形式: *.tar, *.bz2, *.tar.gz, *.zip
- キャッシュパス形式: /path/to/repository/downloads/project-N/sha/@v2/archive.format
- レガシーパスは@v2プレフィックスを省略
- findコマンドはGitlab::Popen.popenで実行
