# バッチ設計書 57-RemoveUnreferencedLfsObjectsWorker

## 概要

本ドキュメントは、GitLabにおける未参照LFSオブジェクトの削除を実行するバッチ処理「RemoveUnreferencedLfsObjectsWorker」の設計を定義する。

### 本バッチの処理概要

**業務上の目的・背景**：Git Large File Storage (LFS) は、大きなファイル（バイナリファイル、メディアファイルなど）をGitリポジトリから分離して効率的に管理するための機能である。プロジェクトの削除やLFSファイルの履歴削除などにより、どのプロジェクトからも参照されなくなったLFSオブジェクトが発生する。本バッチは、これらの孤立したLFSオブジェクトを検出・削除し、ストレージリソースを回収することで、システムの効率的な運用を支援する。

**バッチの実行タイミング**：Cronジョブとして定期実行。未参照のLFSオブジェクトをバッチ単位で削除。

**主要な処理内容**：
1. プロジェクトから参照されていないLFSオブジェクトをバッチ取得
2. 取得した未参照オブジェクトを一括削除（destroy_all）
3. 削除件数をカウントして返却

**前後の処理との関連**：独立したクリーンアップ処理。プロジェクト削除やLFSファイル削除後に孤立したオブジェクトを処理。

**影響範囲**：lfs_objectsテーブルおよび関連するオブジェクトストレージ上のファイル。削除後は復元不可。

## バッチ種別

データクレンジング / ストレージ管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cron設定に依存） |
| 実行時刻 | Cron設定に依存 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 未参照LFSオブジェクトの存在 | lfs_objects_projectsに紐付けのないLFSオブジェクトが存在 |

### 実行可否判定

未参照オブジェクトが存在しない場合は何も削除せずに終了。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | Cronジョブのため引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| lfs_objects | DB | LFSオブジェクト一覧 |
| lfs_objects_projects | DB | LFSオブジェクトとプロジェクトの関連 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| lfs_objects | DB | 未参照オブジェクトの削除 |
| オブジェクトストレージ | ファイル削除 | 関連ファイルの削除 |

### 出力ファイル仕様

ファイル出力なし（削除処理のみ）

## 処理フロー

### 処理シーケンス

```
1. 削除件数カウンターを初期化
   └─ number_of_removed_files = 0
2. 未参照LFSオブジェクトをバッチ取得
   └─ LfsObject.unreferenced_in_batches
3. 各バッチの未参照オブジェクトを削除
   └─ lfs_objects_without_projects.destroy_all
4. 削除件数をカウントに加算
   └─ number_of_removed_files += count
5. 総削除件数を返却
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[削除件数カウンター初期化]
    B --> C[未参照LFSオブジェクトをバッチ取得]
    C --> D{未参照オブジェクトあり?}
    D -->|No| E[総削除件数を返却]
    D -->|Yes| F[destroy_allで削除]
    F --> G[削除件数を加算]
    G --> H{次のバッチあり?}
    H -->|Yes| C
    H -->|No| E
    E --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 未参照検索 | lfs_objects | SELECT | プロジェクト紐付けのないオブジェクトを検索 |
| 未参照検索 | lfs_objects_projects | LEFT JOIN | 関連テーブルとの結合 |
| オブジェクト削除 | lfs_objects | DELETE | 未参照オブジェクトを削除 |

### テーブル別操作詳細

#### lfs_objects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, oid, size | lfs_objects_projects.id IS NULL | 未参照オブジェクト抽出 |
| DELETE | - | 上記条件に該当 | destroy_allで削除 |

#### lfs_objects_projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| LEFT JOIN | lfs_object_id | 結合条件 | 未参照判定用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DB接続エラー | データベース接続失敗 | Sidekiqによるリトライ |
| - | ストレージエラー | オブジェクトストレージ削除失敗 | ログ出力、次回リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | すべての例外 |

### 障害時対応

バッチ処理のため、一部失敗しても次回実行で再試行される。冪等性があるため、重複実行による問題はない。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位 |
| コミットタイミング | 各バッチのdestroy_all完了時 |
| ロールバック条件 | バッチ内で例外発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 未参照オブジェクト数に依存 |
| 目標処理時間 | バッチ処理のため上限なし |
| メモリ使用量上限 | unreferenced_in_batchesによるバッチ処理で制限 |

## 排他制御

deduplicate :until_executed により、同一ジョブの重複実行を防止。冪等性（idempotent!）を保証。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 戻り値 | バッチ終了時 | number_of_removed_files（削除件数） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| エラー件数 | Sidekiq失敗キュー | 運用チーム |

## 備考

- idempotent!指定あり（冪等性保証）
- deduplicate :until_executed 指定あり（重複実行防止）
- data_consistency: :always を使用
- feature_category: :source_code_management
- destroy_allはActiveRecordのコールバックを実行（関連ファイルも削除）
- rubocop: disable Cop/DestroyAll コメントあり（大量削除の許容）
- LfsObject.unreferenced_in_batchesはモデル側で定義されたバッチ取得メソッド
