# バッチ設計書 58-BatchedGitRefUpdates::CleanupSchedulerWorker

## 概要

本ドキュメントは、GitLabにおけるGit参照更新のクリーンアップをスケジュールするバッチ処理「BatchedGitRefUpdates::CleanupSchedulerWorker」の設計を定義する。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabでは、ブランチやタグの削除などのGit参照更新操作が行われた際、Gitaly側での実際の参照削除を非同期で行う仕組みがある。これにより、削除対象の参照情報がbatched_git_ref_updates_deletionsテーブルに記録され、後でバッチ処理で削除される。本バッチは、保留中の削除レコードを検出し、プロジェクトごとにクリーンアップワーカーをスケジュールする役割を担う。

**バッチの実行タイミング**：Cronジョブとして定期実行。排他ロック（ExclusiveLease）を使用して重複実行を防止。

**主要な処理内容**：
1. CleanupSchedulerServiceを呼び出し
2. 排他ロックを取得（10分タイムアウト）
3. 保留中の削除レコードをプロジェクトIDでバッチ取得
4. 各プロジェクトに対してProjectCleanupWorkerをキューイング
5. 最大10,000プロジェクトまで処理

**前後の処理との関連**：Git参照の削除リクエストがDeletionテーブルに記録された後、本バッチがProjectCleanupWorkerをスケジュールし、実際のGit参照削除を実行。

**影響範囲**：batched_git_ref_updates_deletionsテーブルのレコードと、Gitalyリポジトリ上のGit参照が削除される。

## バッチ種別

データクレンジング / Git参照管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cron設定に依存） |
| 実行時刻 | Cron設定に依存 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 排他ロック取得 | ExclusiveLeaseを取得できること |
| 保留中削除レコード | status_pendingのDeletionレコードが存在 |

### 実行可否判定

排他ロックを取得できない場合は即時終了（別インスタンスが実行中）。保留中レコードがない場合は何もせずに終了。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | Cronジョブのため引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| batched_git_ref_updates_deletions | DB | 削除対象Git参照一覧 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ProjectCleanupWorkerキュー | Sidekiq | プロジェクトごとのクリーンアップジョブ |
| Sidekiqログ | メタデータ | stats（処理プロジェクト数） |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. CleanupSchedulerService.executeを実行
   └─ CleanupSchedulerWorker.perform
2. 排他ロックの取得
   └─ in_lock（10分タイムアウト、リトライなし）
3. 保留中削除レコードをバッチ取得
   └─ Deletion.status_pending.distinct_each_batch(column: :project_id)
4. 各プロジェクトIDに対してProjectCleanupWorkerをキュー
   └─ bulk_perform_async_with_contexts
5. 処理プロジェクト数をカウント
   └─ total_projects += deletions.count
6. 10,000プロジェクトでループ終了
   └─ break if total_projects >= MAX_PROJECTS
7. 統計情報を返却
   └─ { total_projects: total_projects }
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[CleanupSchedulerService.execute]
    B --> C[排他ロック取得試行]
    C --> D{ロック取得成功?}
    D -->|No| E[バッチ終了]
    D -->|Yes| F[保留中削除レコード取得]
    F --> G{レコードあり?}
    G -->|No| H[ロック解放]
    G -->|Yes| I[ProjectCleanupWorker.bulk_perform_async]
    I --> J[処理プロジェクト数加算]
    J --> K{total_projects >= 10000?}
    K -->|Yes| H
    K -->|No| L{次のバッチあり?}
    L -->|Yes| F
    L -->|No| H
    H --> M[統計情報をメタデータ出力]
    M --> E
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 削除対象検索 | batched_git_ref_updates_deletions | SELECT | status_pendingのレコードをproject_idで取得 |

### テーブル別操作詳細

#### batched_git_ref_updates_deletions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | project_id | status = pending | DISTINCTでプロジェクトID取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | リース取得失敗 | 別インスタンスが実行中 | スキップ（次回実行で再試行） |
| - | DB接続エラー | データベース接続失敗 | Sidekiqによるリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | すべての例外 |

### 障害時対応

排他ロックは10分でタイムアウトするため、障害発生時も次回実行で自動的に再開可能。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（スケジューリングのみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大10,000プロジェクト（MAX_PROJECTS） |
| 目標処理時間 | 10分以内（LOCK_TIMEOUT） |
| メモリ使用量上限 | distinct_each_batch（100件単位）で制限 |

## 排他制御

ExclusiveLeaseHelpersによる排他制御：
- リースキー: CleanupSchedulerService（クラス名）
- タイムアウト: LOCK_TIMEOUT = 10分
- リトライ: なし（retries: 0）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| メタデータ | バッチ終了時 | stats: { total_projects: N } |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| エラー件数 | Sidekiq失敗キュー | 運用チーム |

## 備考

- idempotent!指定あり（冪等性保証）
- data_consistency: :sticky を使用（レプリカ読み取りに注意）
- feature_category: :gitaly
- MAX_PROJECTS = 10,000（1回の実行で処理する最大プロジェクト数）
- BATCH_SIZE = 100（バッチ取得サイズ）
- ProjectCleanupWorkerが実際のGit参照削除を実行
- コンテキストなしでワーカーをキュー（プロジェクトロードを避けるため）
