# バッチ設計書 62-Pages::DeactivateExpiredDeploymentsCronWorker

## 概要

本ドキュメントは、期限切れのGitLab Pagesデプロイメントを非アクティブ化するバッチ処理（Pages::DeactivateExpiredDeploymentsCronWorker）の設計を記載します。

### 本バッチの処理概要

GitLab PagesのデプロイメントでTTL（有効期限）を超過したアクティブなデプロイメントを検出し、非アクティブ状態に更新するバッチ処理です。

**業務上の目的・背景**：GitLab Pagesでは、デプロイメントにTTL（Time To Live）を設定して自動的に公開を停止する機能があります。これにより、一時的なプレビュー環境や期間限定のページ公開を実現できます。本バッチは、有効期限を過ぎたデプロイメントを検出して非アクティブ化することで、リソースの効率的な管理とセキュリティの向上を実現します。非アクティブ化されたデプロイメントは後続のDeleteCronWorkerで削除されます。

**バッチの実行タイミング**：10分間隔で定期実行

**主要な処理内容**：
1. アクティブかつ期限切れのPagesデプロイメントを検索（active.expired scope）
2. Keysetページネーションを使用してバッチ処理（1000件ずつ）
3. 各デプロイメントに対してdeactivateメソッドを呼び出し
4. 最大10,000件の処理制限（1回の実行あたり）
5. 処理結果のメタデータをログ出力

**前後の処理との関連**：本バッチで非アクティブ化されたデプロイメントは、Pages::DeactivatedDeploymentsDeleteCronWorkerによって削除されます。

**影響範囲**：pages_deploymentsテーブル、Pagesの静的サイトホスティング

## バッチ種別

データ状態更新 / TTL管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 10分間隔 |
| 実行時刻 | */10 * * * * |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitLab Pagesが有効 | Pagesデプロイメント機能が利用可能であること |
| データベース接続 | PostgreSQLへの接続が確立されていること |

### 実行可否判定

特別な実行可否判定ロジックはありません。cronスケジュールに従って自動実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| pages_deployments | DB | アクティブで期限切れのデプロイメント情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| pages_deployments | DB | deleted_atカラムの更新（非アクティブ化） |
| ログ | ファイル/stdout | 処理件数と処理時間のメタデータ |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. 処理対象の検索
   └─ PagesDeployment.active.expired で期限切れのアクティブデプロイメントを取得
2. Keysetイテレータの初期化
   └─ Gitlab::Pagination::Keyset::Iterator でページネーション設定
3. バッチ処理ループ（1000件単位）
   └─ 各デプロイメントに対して deactivate を実行
   └─ 処理件数をカウント
   └─ MAX_NUM_DELETIONS（10,000件）到達で中断
4. メタデータログ出力
   └─ 非アクティブ化件数と処理時間を記録
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[期限切れデプロイメント検索<br/>active.expired scope]
    B --> C[Keysetイテレータ初期化]
    C --> D{バッチ取得<br/>1000件}
    D -->|データあり| E[各デプロイメントを非アクティブ化]
    E --> F[処理件数カウント]
    F --> G{10,000件到達?}
    G -->|No| D
    G -->|Yes| H[メタデータログ出力]
    D -->|データなし| H
    H --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| デプロイメント検索 | pages_deployments | SELECT | upload_ready=true, deleted_at=null, expires_at < now |
| 非アクティブ化 | pages_deployments | UPDATE | deleted_atを現在時刻に更新 |

### テーブル別操作詳細

#### pages_deployments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, expires_at, deleted_at | upload_ready=true AND deleted_at IS NULL AND expires_at < NOW() | Keysetページネーション使用 |
| UPDATE | deleted_at | Time.now.utc | deactivateメソッドによる更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ActiveRecord::RecordNotFound | 処理中にレコードが削除された | 次のレコードへ継続 |
| - | Database connection error | DB接続エラー | Sidekiqのリトライ機構で再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

idempotent!が設定されているため、同じ処理を複数回実行しても問題ありません。処理が中断された場合、次回実行時に未処理のレコードが再度対象となります。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | レコード単位 |
| コミットタイミング | 各deactivateの完了時 |
| ロールバック条件 | 各レコードの更新失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大10,000件/実行 |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | BATCH_SIZE（1000件）でメモリ制御 |

## 排他制御

idempotent!が設定されているため、同時実行されても冪等性が保証されます。同一デプロイメントに対する複数回のdeactivate呼び出しは、既にdeleted_atが設定されている場合は更新されません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| メタデータログ | 処理完了時 | deactivated_deployments: 件数, duration: 処理時間 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理件数 | MAX_NUM_DELETIONS到達時 | ログ監視 |
| 処理時間 | 設定なし | - |

## 備考

- idempotent!が設定されており、安全に再実行可能です
- data_consistency: :always により、常にプライマリデータベースを参照します
- MAX_NUM_DELETIONS（10,000件）の制限により、大量データでの長時間処理を防止しています
- BATCH_SIZE（1000件）でメモリ効率を確保しています
- log_extra_metadata_on_doneにより、Sidekiqのジョブ完了時にメタデータが記録されます
