# バッチ設計書 63-Pages::DeactivatedDeploymentsDeleteCronWorker

## 概要

本ドキュメントは、非アクティブ化されたGitLab Pagesデプロイメントを物理削除するバッチ処理（Pages::DeactivatedDeploymentsDeleteCronWorker）の設計を記載します。

### 本バッチの処理概要

GitLab Pagesの非アクティブ化されたデプロイメント（deleted_atが過去の日時）を検出し、実際にレコードを削除するバッチ処理です。

**業務上の目的・背景**：GitLab Pagesのデプロイメントには2段階の削除プロセスがあります。まずDeactivateExpiredDeploymentsCronWorkerでdeleted_atが設定され（論理削除/非アクティブ化）、次に本バッチで物理削除が行われます。この2段階プロセスにより、誤操作時のリカバリ期間を確保しつつ、最終的なストレージリソースの解放を実現します。オブジェクトストレージに保存されているデプロイメントファイルも合わせて削除されます。

**バッチの実行タイミング**：10分間隔で定期実行

**主要な処理内容**：
1. 非アクティブ化されたデプロイメント（deleted_at < 現在時刻）を検索
2. each_batchでバッチ処理
3. 各デプロイメントをdestroy!で物理削除
4. 関連するオブジェクトストレージファイルも削除

**前後の処理との関連**：Pages::DeactivateExpiredDeploymentsCronWorkerで非アクティブ化されたデプロイメントが本バッチの削除対象となります。

**影響範囲**：pages_deploymentsテーブル、オブジェクトストレージ（デプロイメントファイル）

## バッチ種別

データクレンジング / 物理削除

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 10分間隔 |
| 実行時刻 | */10 * * * * |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitLab Pagesが有効 | Pagesデプロイメント機能が利用可能であること |
| データベース接続 | PostgreSQLへの接続が確立されていること |
| オブジェクトストレージ | ファイル削除のためのストレージアクセスが可能であること |

### 実行可否判定

特別な実行可否判定ロジックはありません。cronスケジュールに従って自動実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| pages_deployments | DB | 非アクティブ化されたデプロイメント情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| pages_deployments | DB | 削除対象レコードの物理削除 |
| オブジェクトストレージ | ファイル | デプロイメントファイルの削除 |

### 出力ファイル仕様

ファイル出力はありません（削除処理のみ）。

## 処理フロー

### 処理シーケンス

```
1. 削除対象デプロイメントの検索
   └─ PagesDeployment.deactivated で deleted_at < 現在時刻のレコードを取得
2. バッチ処理ループ（each_batch）
   └─ 各デプロイメントに対して destroy! を実行
   └─ CarrierWaveによりオブジェクトストレージファイルも自動削除
3. 処理完了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[非アクティブデプロイメント検索<br/>deactivated scope]
    B --> C{バッチ取得<br/>each_batch}
    C -->|データあり| D[各デプロイメントを削除<br/>destroy!]
    D --> E[オブジェクトストレージ<br/>ファイル削除]
    E --> C
    C -->|データなし| F[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| デプロイメント検索 | pages_deployments | SELECT | deleted_at < 現在時刻のレコードを検索 |
| デプロイメント削除 | pages_deployments | DELETE | 対象レコードを物理削除 |

### テーブル別操作詳細

#### pages_deployments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, deleted_at, file | deleted_at < Time.now.utc | each_batchでバッチ処理 |
| DELETE | - | id指定 | destroy!による物理削除、CarrierWaveでファイルも削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ActiveRecord::RecordNotDestroyed | 削除制約違反 | エラーログ記録、次レコードへ継続 |
| - | Fog::Storage::Error | オブジェクトストレージ接続エラー | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

idempotent!が設定されているため、同じ処理を複数回実行しても問題ありません。削除に失敗したレコードは次回実行時に再度対象となります。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | レコード単位 |
| コミットタイミング | 各destroy!の完了時 |
| ロールバック条件 | 各レコードの削除失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 変動（非アクティブ化されたデプロイメント数に依存） |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | each_batchによるバッチ処理で制御 |

## 排他制御

idempotent!が設定されているため、同時実行されても冪等性が保証されます。既に削除されたレコードは検索対象から除外されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 削除エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 設定なし | - |
| エラー件数 | 設定なし | Sentry/ErrorTracking |

## 備考

- idempotent!が設定されており、安全に再実行可能です
- data_consistency: :always により、常にプライマリデータベースを参照します
- CarrierWaveのFileStoreUploaderにより、レコード削除時にオブジェクトストレージのファイルも自動的に削除されます
- DeactivateExpiredDeploymentsCronWorkerとのペアで2段階削除を実現しています
