# バッチ設計書 64-ImportExportProjectCleanupWorker

## 概要

本ドキュメントは、プロジェクトのインポート/エクスポート一時ファイルをクリーンアップするバッチ処理（ImportExportProjectCleanupWorker）の設計を記載します。

### 本バッチの処理概要

GitLabのプロジェクトインポート/エクスポート機能で生成された一時ファイルおよびオブジェクトストレージ上のエクスポートファイルをクリーンアップするバッチ処理です。

**業務上の目的・背景**：GitLabでは、プロジェクトのインポートやエクスポート時に一時ファイルが生成されます。これらのファイルは処理完了後も一定期間保持されますが、24時間（1440分）を経過した古いファイルはストレージ容量の効率的な利用のために削除する必要があります。本バッチは、ファイルシステム上の一時ディレクトリとオブジェクトストレージ上のエクスポートファイルの両方をクリーンアップすることで、ストレージリソースの適切な管理を実現します。

**バッチの実行タイミング**：毎時実行（毎時0分）

**主要な処理内容**：
1. オブジェクトストレージ上の古いエクスポートファイルを削除（ImportExportUpload.with_export_file）
2. ファイルシステム上の古い一時ディレクトリを検索・削除
3. findコマンドで指定深度のディレクトリを検索
4. 最終更新から24時間以上経過したディレクトリを削除

**前後の処理との関連**：プロジェクトインポート/エクスポート処理の後処理として機能します。エクスポート処理（ProjectExportJob）の完了後に一時ファイルが残り、本バッチで削除されます。

**影響範囲**：import_export_uploadsテーブル、shared/tmp/import_exportディレクトリ、オブジェクトストレージ

## バッチ種別

データクレンジング / 一時ファイル削除

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 毎時 |
| 実行時刻 | 00分 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ストレージパス存在 | Gitlab::ImportExport.storage_pathが存在すること |
| データベース接続 | PostgreSQLへの接続が確立されていること |
| オブジェクトストレージ | export_file削除のためのストレージアクセスが可能であること |

### 実行可否判定

ファイルシステムクリーンアップはディレクトリが存在する場合のみ実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| import_export_uploads | DB | エクスポートファイル情報 |
| shared/tmp/import_export | ディレクトリ | 一時ファイルディレクトリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| import_export_uploads | DB | export_fileカラムのクリア |
| オブジェクトストレージ | ファイル | エクスポートファイルの削除 |
| ファイルシステム | ディレクトリ | 一時ディレクトリの削除 |
| ログ | ファイル/stdout | 削除したディレクトリ/ファイルの記録 |

### 出力ファイル仕様

ファイル出力はありません（削除処理のみ）。

## 処理フロー

### 処理シーケンス

```
1. メトリクス計測開始
   └─ Gitlab::Metrics.measure(:import_export_clean_up)
2. オブジェクトストレージクリーンアップ
   └─ ImportExportUpload.with_export_file.updated_before(24時間前)を検索
   └─ 各uploadのremove_export_file!を実行
   └─ upload.save!で保存
3. ファイルシステムクリーンアップ
   └─ ストレージパスが存在する場合のみ実行
   └─ findコマンドで深度5のディレクトリを検索
   └─ 24時間以上前の最終更新のディレクトリを削除
4. ログ出力
   └─ 削除したディレクトリパスをログに記録
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[メトリクス計測開始]
    B --> C[オブジェクトストレージ<br/>クリーンアップ]
    C --> D[古いexport_fileを検索]
    D --> E{ファイル存在?}
    E -->|あり| F[remove_export_file!<br/>+ save!]
    F --> E
    E -->|なし| G{ストレージパス存在?}
    G -->|なし| K[バッチ終了]
    G -->|あり| H[findコマンド実行]
    H --> I{古いディレクトリ存在?}
    I -->|あり| J[ディレクトリ削除<br/>FileUtils.remove_entry]
    J --> L[削除ログ出力]
    L --> I
    I -->|なし| K
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| エクスポートファイル検索 | import_export_uploads | SELECT | 古いエクスポートファイルを検索 |
| エクスポートファイルクリア | import_export_uploads | UPDATE | export_fileカラムをクリア |

### テーブル別操作詳細

#### import_export_uploads

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, project_id, group_id, export_file | updated_at < 24時間前 AND export_file IS NOT NULL | with_export_file scope |
| UPDATE | export_file | NULL | remove_export_file!によるクリア |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Errno::ENOENT | 削除対象ディレクトリが存在しない | 無視して継続 |
| - | Fog::Storage::Error | オブジェクトストレージ接続エラー | Sidekiqリトライ |
| - | ActiveRecord::RecordInvalid | 保存エラー | エラーログ記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

オブジェクトストレージのクリーンアップ失敗時も、ensureブロックによりファイルシステムのクリーンアップは実行されます。失敗したファイルは次回実行時に再度対象となります。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | レコード単位 |
| コミットタイミング | 各save!の完了時 |
| ロールバック条件 | 各レコードの更新失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 変動（エクスポート使用量に依存） |
| 目標処理時間 | 数分〜数十分 |
| メモリ使用量上限 | findコマンドのストリーム処理で制御 |

## 排他制御

IdempotentWorkerではありませんが、処理対象の検索条件が時刻ベースのため、実質的に冪等です。同時実行時は同じファイルを複数回削除しようとする可能性がありますが、エラーハンドリングにより問題なく動作します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | ディレクトリ削除時 | dir_path, message: 'Removed Import/Export tmp directory' |
| 情報ログ | export_file削除時 | project_id, group_id, message: 'Removed Import/Export export_file' |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | Gitlab::Metrics経由で記録 | メトリクス監視 |
| エラー件数 | 設定なし | Sentry/ErrorTracking |

## 備考

- LAST_MODIFIED_TIME_IN_MINUTES = 1440（24時間）で削除対象の経過時間を定義
- DIR_DEPTH = 5 で検索対象ディレクトリの深度を指定
- findコマンドを使用してファイルシステムの検索を効率的に実行
- オブジェクトストレージのクリーンアップが失敗しても、ファイルシステムのクリーンアップは継続実行（ensureブロック）
- Import::Framework::Loggerを使用した構造化ログ出力
