# バッチ設計書 65-BulkImports::StaleImportWorker

## 概要

本ドキュメントは、停滞したバルクインポートをクリーンアップするバッチ処理（BulkImports::StaleImportWorker）の設計を記載します。

### 本バッチの処理概要

GitLabの一括インポート機能（BulkImport）で長時間停滞している（stale）インポート処理を検出し、タイムアウト状態に移行させるバッチ処理です。

**業務上の目的・背景**：GitLabでは、グループやプロジェクトを他のGitLabインスタンスから一括インポートする機能があります。このインポート処理は複雑で時間がかかるため、処理が途中で停止してしまう場合があります。24時間以上更新がないインポートは「停滞」と判断し、タイムアウト状態に移行させることで、システムリソースの解放とユーザーへの適切な状態通知を実現します。また、関連するエンティティやトラッカーも同様にクリーンアップします。

**バッチの実行タイミング**：4時間間隔で定期実行

**主要な処理内容**：
1. 24時間以上更新のないBulkImport（停滞インポート）を検索
2. 各インポートのcleanup_staleイベントを発火（timeout状態へ移行）
3. 24時間以上更新のないBulkImports::Entity（停滞エンティティ）を検索
4. 各エンティティのcleanup_staleイベントを発火
5. 関連するトラッカーのcleanup_staleイベントも発火

**前後の処理との関連**：BulkImportPipeline処理の異常終了を検知する役割。正常に完了したインポートには影響しません。

**影響範囲**：bulk_imports、bulk_import_entities、bulk_import_trackersテーブル

## バッチ種別

データ状態管理 / タイムアウト処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 4時間間隔 |
| 実行時刻 | 0 */4 * * * |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| BulkImport機能が有効 | 一括インポート機能が利用可能であること |
| データベース接続 | PostgreSQLへの接続が確立されていること |

### 実行可否判定

特別な実行可否判定ロジックはありません。cronスケジュールに従って自動実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| bulk_imports | DB | 停滞したバルクインポート情報 |
| bulk_import_entities | DB | 停滞したインポートエンティティ情報 |
| bulk_import_trackers | DB | 関連するトラッカー情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| bulk_imports | DB | statusカラムをtimeoutに更新 |
| bulk_import_entities | DB | statusカラムをtimeoutに更新 |
| bulk_import_trackers | DB | statusカラムをtimeoutに更新 |
| ログ | ファイル/stdout | 停滞インポートの検出ログ |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. 停滞BulkImportの処理
   └─ BulkImport.stale（24時間以上未更新 + status: created/started）を検索
   └─ Keysetページネーションでバッチ処理
   └─ 各インポートのcleanup_staleイベントを発火
   └─ エラーログを出力

2. 停滞Entityの処理
   └─ BulkImports::Entity.stale（24時間以上未更新）を検索
   └─ Keysetページネーションでバッチ処理
   └─ トランザクション内で処理
     └─ エンティティのcleanup_staleイベントを発火
     └─ 関連トラッカーのcleanup_staleイベントを発火
   └─ エラーログを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[停滞BulkImport検索<br/>stale scope]
    B --> C{インポート存在?}
    C -->|あり| D[エラーログ出力<br/>BulkImport stale]
    D --> E[cleanup_stale発火<br/>timeout状態へ]
    E --> C
    C -->|なし| F[停滞Entity検索<br/>stale scope]
    F --> G{エンティティ存在?}
    G -->|あり| H[トランザクション開始]
    H --> I[エラーログ出力<br/>Entity stale]
    I --> J[Entity cleanup_stale発火]
    J --> K[関連Tracker検索]
    K --> L[Tracker cleanup_stale発火]
    L --> M[トランザクションコミット]
    M --> G
    G -->|なし| N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| インポート検索 | bulk_imports | SELECT | 停滞インポートを検索 |
| インポート更新 | bulk_imports | UPDATE | statusをtimeoutに更新 |
| エンティティ検索 | bulk_import_entities | SELECT | 停滞エンティティを検索 |
| エンティティ更新 | bulk_import_entities | UPDATE | statusをtimeoutに更新 |
| トラッカー検索 | bulk_import_trackers | SELECT | 関連トラッカーを検索 |
| トラッカー更新 | bulk_import_trackers | UPDATE | statusをtimeoutに更新 |

### テーブル別操作詳細

#### bulk_imports

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, status, updated_at | updated_at < 24時間前 AND status IN (0, 1) | stale scope |
| UPDATE | status | 3 (timeout) | cleanup_staleイベント |

#### bulk_import_entities

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, status, updated_at | updated_at < 24時間前 AND status IN (0, 1) | stale scope |
| UPDATE | status | timeout | cleanup_staleイベント |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ActiveRecord::RecordInvalid | 状態遷移エラー | ログ記録、次レコードへ継続 |
| - | Database connection error | DB接続エラー | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

idempotent!が設定されているため、同じ処理を複数回実行しても問題ありません。既にtimeout状態のレコードはstaleスコープから除外されるため、重複処理されません。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | エンティティ + 関連トラッカー単位 |
| コミットタイミング | 各エンティティ処理の完了時 |
| ロールバック条件 | エンティティまたはトラッカーの更新失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 通常は少数（停滞は異常ケース） |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | Keysetページネーションで制御 |

## 排他制御

idempotent!が設定されており、同時実行されても冪等性が保証されます。状態遷移はstate_machineにより管理され、不正な遷移は防止されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 停滞Import検出時 | message: 'BulkImport stale', bulk_import_id |
| エラーログ | 停滞Entity検出時 | message: 'BulkImports::Entity stale', entity情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 停滞インポート件数 | 設定なし | ログ監視 |
| エラー件数 | 設定なし | Sentry/ErrorTracking |

## 備考

- idempotent!が設定されており、安全に再実行可能です
- data_consistency: :sticky により、書き込み後のレプリカ遅延に対応
- staleスコープは24時間経過 + status: created(0)/started(1) を条件としています
- state_machineのcleanup_staleイベントにより、created/startedからtimeout(3)への状態遷移が行われます
- BulkImports::Loggerを使用した構造化ログ出力（with_entity対応）
- エンティティとトラッカーの処理はトランザクション内で実行され、原子性が保証されます
