# バッチ設計書 66-StuckExportJobsWorker

## 概要

本ドキュメントは、停滞したプロジェクトエクスポートジョブを検出して失敗状態にマークするバッチ処理（StuckExportJobsWorker）の設計を記載します。

### 本バッチの処理概要

GitLabのプロジェクトエクスポート機能で、Sidekiqジョブが完了しているにも関わらずエクスポートジョブのステータスが更新されていない（停滞した）ジョブを検出し、失敗状態にマークするバッチ処理です。

**業務上の目的・背景**：プロジェクトエクスポートはSidekiqジョブとして非同期実行されます。しかし、Sidekiqジョブが異常終了した場合やワーカーがクラッシュした場合、ProjectExportJobのステータスが更新されずに「実行中」のまま残ることがあります。本バッチは、Sidekiqのジョブ完了状態を確認し、実際には完了しているがステータスが更新されていないジョブを検出して失敗状態にマークすることで、ユーザーへの正確な状態通知とリソースの適切な管理を実現します。

**バッチの実行タイミング**：毎時実行（毎時30分）

**主要な処理内容**：
1. queued/started状態のProjectExportJobを検索
2. 各ジョブのSidekiqジョブ完了状態を確認（Gitlab::SidekiqStatus）
3. Sidekiqで完了済みのジョブをフィルタリング
4. 並列エクスポートの場合は6時間の猶予期間をチェック
5. 該当ジョブをfailed状態にマーク

**前後の処理との関連**：ProjectExportJobの作成・実行はProjectExportWorkerが担当。本バッチは異常終了を検知する監視的な役割を担います。

**影響範囲**：project_export_jobsテーブル

## バッチ種別

データ状態管理 / 停滞ジョブ検出

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 毎時 |
| 実行時刻 | 30分 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| エクスポート機能が有効 | プロジェクトエクスポート機能が利用可能であること |
| データベース接続 | PostgreSQLへの接続が確立されていること |
| Redis接続 | Sidekiqステータス確認のためのRedis接続が可能であること |

### 実行可否判定

特別な実行可否判定ロジックはありません。cronスケジュールに従って自動実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| project_export_jobs | DB | エクスポートジョブ情報 |
| Redis (Sidekiq) | KVS | ジョブの実行状態 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| project_export_jobs | DB | statusカラムをfailedに更新 |
| ログ | ファイル/stdout | 停滞ジョブの検出ログ |
| Gitlab::Metrics | メトリクス | stuck_export_jobs イベント |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. エンキュー済みエクスポートジョブの検索
   └─ ProjectExportJob.with_status([:started, :queued])
2. JIDリストの抽出
   └─ pluck(:jid, :id) でジョブIDとレコードIDを取得
3. Sidekiq完了状態の確認
   └─ Gitlab::SidekiqStatus.completed_jids で完了JIDを取得
4. 完了ジョブの再取得
   └─ 状態遷移の可能性を考慮して再度検索
5. 並列エクスポートチェック
   └─ relation_exportsが存在する場合、6時間の猶予期間を確認
6. 失敗マーク
   └─ fail_opイベントで failed状態に遷移
7. メトリクス出力
   └─ Gitlab::Metrics.add_event(:stuck_export_jobs)
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[queued/started状態の<br/>エクスポートジョブ検索]
    B --> C[JIDリスト抽出]
    C --> D[Sidekiq完了状態確認]
    D --> E{完了JID存在?}
    E -->|なし| K[バッチ終了]
    E -->|あり| F[完了ジョブ再取得]
    F --> G{各ジョブ処理}
    G --> H{並列エクスポート?}
    H -->|Yes| I{6時間経過?}
    I -->|No| G
    I -->|Yes| J[fail_op実行<br/>failed状態へ]
    H -->|No| J
    J --> L[ログ出力]
    L --> G
    G -->|処理完了| M[メトリクス出力]
    M --> K
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| エクスポートジョブ検索 | project_export_jobs | SELECT | queued/started状態のジョブを検索 |
| エクスポートジョブ更新 | project_export_jobs | UPDATE | statusをfailedに更新 |

### テーブル別操作詳細

#### project_export_jobs

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | jid, id, status, created_at | status IN (0, 1) | with_status scope |
| UPDATE | status | 3 (failed) | fail_opイベント |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Redis::ConnectionError | Redis接続エラー | Sidekiqリトライ |
| - | ActiveRecord::RecordInvalid | 状態遷移エラー | ログ記録、次レコードへ継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

処理が中断された場合、次回実行時に未処理の停滞ジョブが再度対象となります。Sidekiqステータスの確認は冪等な操作のため、重複実行しても問題ありません。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | レコード単位 |
| コミットタイミング | 各fail_opの完了時 |
| ロールバック条件 | 各レコードの更新失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 通常は少数（停滞は異常ケース） |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | JIDリストサイズに依存 |

## 排他制御

IdempotentWorkerではありませんが、Sidekiqステータスの確認と状態遷移の2段階チェックにより、実質的に冪等な動作となります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 停滞ジョブ検出時 | message: 'Marked stuck export jobs as failed', job_ids |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| stuck_export_jobs イベント | failed_jobs_count | Gitlab::Metrics |
| エラー件数 | 設定なし | Sentry/ErrorTracking |

## 備考

- EXPORT_JOBS_EXPIRATION = 6.hours.to_i（21600秒）で並列エクスポートの猶予期間を定義
- worker_resource_boundary: :cpu が設定されており、CPU負荷の高いワーカーとして分類
- data_consistency: :always により、常にプライマリデータベースを参照
- Gitlab::SidekiqStatus.completed_jidsでSidekiqジョブの完了状態を確認
- relation_exportsが存在する並列エクスポートは、6時間以内であれば失敗マークをスキップ
- 状態遷移の競合を避けるため、完了JID取得後に再度ジョブを検索して最新状態を確認
