# バッチ設計書 67-Gitlab::Export::PruneProjectExportJobsWorker

## 概要

本ドキュメントは、期限切れのプロジェクトエクスポートジョブを削除（プルーニング）するバッチ処理（Gitlab::Export::PruneProjectExportJobsWorker）の設計を記載します。

### 本バッチの処理概要

GitLabのプロジェクトエクスポート機能で生成されたProjectExportJobレコードと関連するアップロードファイルを、有効期限（7日間）経過後に削除するバッチ処理です。

**業務上の目的・背景**：プロジェクトエクスポート処理を実行すると、ProjectExportJobレコードとRelationExportUploadが作成されます。これらのデータは処理結果の確認やダウンロードのために一定期間保持されますが、7日間を経過すると不要となります。本バッチは、期限切れのエクスポートジョブとその関連アップロードを削除することで、データベースとオブジェクトストレージのリソースを効率的に管理します。

**バッチの実行タイミング**：毎時実行（毎時30分）

**主要な処理内容**：
1. 7日以上前に更新されたProjectExportJobを検索
2. 関連するRelationExportUploadのアップロードファイルを削除
3. Upload.finalize_fast_destroyで高速削除を実行
4. ProjectExportJobレコードをバッチ削除

**前後の処理との関連**：ProjectExportWorkerによって作成されたエクスポートジョブが本バッチの削除対象となります。

**影響範囲**：project_export_jobs、projects_import_export_relation_export_uploads、uploadsテーブル、オブジェクトストレージ

## バッチ種別

データクレンジング / 期限切れデータ削除

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 毎時 |
| 実行時刻 | 30分 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| エクスポート機能が有効 | プロジェクトエクスポート機能が利用可能であること |
| データベース接続 | PostgreSQLへの接続が確立されていること |
| オブジェクトストレージ | ファイル削除のためのストレージアクセスが可能であること |

### 実行可否判定

特別な実行可否判定ロジックはありません。cronスケジュールに従って自動実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| project_export_jobs | DB | エクスポートジョブ情報 |
| projects_import_export_relation_export_uploads | DB | リレーションエクスポートアップロード情報 |
| uploads | DB | アップロードファイル情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| project_export_jobs | DB | 期限切れレコードの削除 |
| projects_import_export_relation_export_uploads | DB | 関連アップロードの削除 |
| uploads | DB | アップロード情報の削除 |
| オブジェクトストレージ | ファイル | エクスポートファイルの削除 |

### 出力ファイル仕様

ファイル出力はありません（削除処理のみ）。

## 処理フロー

### 処理シーケンス

```
1. 削除対象ジョブの検索
   └─ ProjectExportJob.updated_at_before(7日前)
2. Keysetページネーションでバッチ処理（1000件単位）
   └─ 各バッチに対して:
3. 関連アップロードの削除
   └─ RelationExportUpload.for_project_export_jobs でアップロードを検索
   └─ Upload.for_model_type_and_id で対応するUploadを取得
   └─ begin_fast_destroy でアップロードキーを取得
   └─ delete_all でアップロードレコードを削除
   └─ finalize_fast_destroy でオブジェクトストレージファイルを削除
4. ジョブレコードの削除
   └─ ProjectExportJob.updated_at_before(7日前).limit(1000).delete_all
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[期限切れジョブ検索<br/>updated_at_before 7日前]
    B --> C{バッチ取得<br/>1000件}
    C -->|データあり| D[関連アップロード検索<br/>RelationExportUpload]
    D --> E[Upload検索<br/>for_model_type_and_id]
    E --> F[begin_fast_destroy<br/>アップロードキー取得]
    F --> G[Upload delete_all]
    G --> H{削除件数 > 0?}
    H -->|Yes| F
    H -->|No| C
    C -->|処理完了| I[ジョブレコード削除<br/>delete_all]
    I --> J{削除件数 > 0?}
    J -->|Yes| I
    J -->|No| K[finalize_fast_destroy<br/>ファイル削除]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ジョブ検索 | project_export_jobs | SELECT | 期限切れジョブを検索 |
| アップロード検索 | projects_import_export_relation_export_uploads | SELECT | 関連アップロードを検索 |
| Upload検索 | uploads | SELECT | 対応するアップロード情報を検索 |
| Upload削除 | uploads | DELETE | アップロード情報を削除 |
| ジョブ削除 | project_export_jobs | DELETE | ジョブレコードを削除 |

### テーブル別操作詳細

#### project_export_jobs

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, updated_at | updated_at < 7日前 | Keysetページネーション |
| DELETE | - | updated_at < 7日前 | BATCH_SIZE単位で削除 |

#### uploads

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, model_type, model_id | model_type = 'Projects::ImportExport::RelationExportUpload' | - |
| DELETE | - | id指定 | fast_destroy使用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Fog::Storage::Error | オブジェクトストレージ接続エラー | Sidekiqリトライ |
| - | ActiveRecord::StatementInvalid | SQL実行エラー | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

idempotent!が設定されているため、同じ処理を複数回実行しても問題ありません。削除済みのレコードは次回検索から除外されます。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位 |
| コミットタイミング | 各delete_allの完了時 |
| ロールバック条件 | バッチ処理の失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 変動（エクスポート使用量に依存） |
| 目標処理時間 | 数分〜数十分 |
| メモリ使用量上限 | BATCH_SIZE（1000件）で制御 |

## 排他制御

idempotent!およびdeduplicate :until_executedが設定されているため、同時実行は防止され、冪等性も保証されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| - | - | 明示的なログ出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 設定なし | - |
| エラー件数 | 設定なし | Sentry/ErrorTracking |

## 備考

- BATCH_SIZE = 1000 でバッチ処理の単位を定義
- ProjectExportJob::EXPIRES_IN = 7.days で有効期限を定義
- idempotent!が設定されており、安全に再実行可能
- deduplicate :until_executed により、実行中の重複起動を防止
- data_consistency: :sticky により、書き込み後のレプリカ遅延に対応
- Upload.begin_fast_destroy / finalize_fast_destroy により、オブジェクトストレージの高速削除を実現
- Keysetページネーションにより、大量データでも効率的に処理
