# バッチ設計書 68-Gitlab::Import::ImportFileCleanupWorker

## 概要

本ドキュメントは、インポート用ファイルをクリーンアップするバッチ処理（Gitlab::Import::ImportFileCleanupWorker）の設計を記載します。

### 本バッチの処理概要

GitLabのプロジェクトインポート機能でアップロードされたインポートファイル（import_file）を、72時間経過後にクリーンアップするバッチ処理です。

**業務上の目的・背景**：プロジェクトインポート時に、ユーザーはtarball形式のエクスポートファイルをアップロードします。このファイルはImportExportUploadレコードのimport_fileカラムに保存されます。インポート処理完了後もファイルは一定期間保持されますが、72時間を経過すると不要となります。本バッチは、古いインポートファイルを検出してRemoveImportFileWorkerをスケジュールすることで、ストレージリソースの効率的な管理を実現します。

**バッチの実行タイミング**：毎時実行（毎時30分）

**主要な処理内容**：
1. import_fileが存在し、72時間以上前に更新されたImportExportUploadを検索
2. 各レコードに対してRemoveImportFileWorkerを非同期でスケジュール
3. インデックス付きで1秒間隔のディレイを設定

**前後の処理との関連**：プロジェクトインポート処理（Project::GitlabProjectsImportService等）でアップロードされたファイルが対象。RemoveImportFileWorkerが実際のファイル削除を担当します。

**影響範囲**：import_export_uploadsテーブル、オブジェクトストレージ（インポートファイル）

## バッチ種別

データクレンジング / 一時ファイル削除スケジューリング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 毎時 |
| 実行時刻 | 30分 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| インポート機能が有効 | プロジェクトインポート機能が利用可能であること |
| データベース接続 | PostgreSQLへの接続が確立されていること |

### 実行可否判定

特別な実行可否判定ロジックはありません。cronスケジュールに従って自動実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| import_export_uploads | DB | インポート/エクスポートアップロード情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Sidekiqキュー | ジョブ | RemoveImportFileWorkerジョブのスケジュール |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. 削除対象アップロードの検索
   └─ ImportExportUpload.with_import_file.updated_before(72時間前)
2. バッチ処理（100件単位）
   └─ 各レコードに対して:
3. 削除ワーカーのスケジュール
   └─ RemoveImportFileWorker.perform_in(index秒, upload.id)
   └─ インデックスに応じた遅延（0秒, 1秒, 2秒...）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[古いインポートファイル検索<br/>with_import_file.updated_before]
    B --> C{バッチ取得<br/>100件}
    C -->|データあり| D[各アップロードに対して]
    D --> E[RemoveImportFileWorker<br/>スケジュール]
    E --> F[インデックス*1秒の遅延設定]
    F --> D
    D -->|バッチ完了| C
    C -->|データなし| G[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| アップロード検索 | import_export_uploads | SELECT | 古いインポートファイルを検索 |

### テーブル別操作詳細

#### import_export_uploads

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, import_file, updated_at | import_file IS NOT NULL AND updated_at < 72時間前 | with_import_file scope |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Redis::ConnectionError | Redis接続エラー | Sidekiqリトライ |
| - | ActiveRecord::StatementInvalid | SQL実行エラー | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

idempotent!が設定されているため、同じ処理を複数回実行しても問題ありません。RemoveImportFileWorkerは個別に実行されるため、一部が失敗しても他のファイル削除には影響しません。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取りのみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 変動（インポート使用量に依存） |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | BATCH_SIZE（100件）で制御 |

## 排他制御

idempotent!が設定されているため、同時実行されても冪等性が保証されます。同じアップロードに対してRemoveImportFileWorkerが複数回スケジュールされる可能性がありますが、実際の削除処理は冪等です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| - | - | 明示的なログ出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 設定なし | - |
| エラー件数 | 設定なし | Sentry/ErrorTracking |

## 備考

- LAST_MODIFIED = 72.hours で削除対象の経過時間を定義
- BATCH_SIZE = 100 でバッチ処理の単位を定義
- idempotent!が設定されており、安全に再実行可能
- data_consistency: :sticky により、書き込み後のレプリカ遅延に対応
- perform_inを使用して、インデックス * 1秒の遅延を設定し、負荷を分散
- 実際のファイル削除はRemoveImportFileWorkerが担当（非同期処理）
- each_batchでメモリ効率を確保しつつバッチ処理
