# バッチ設計書 70-Import::PlaceholderUserCleanupWorker

## 概要

本ドキュメントは、インポート時に作成されたプレースホルダーユーザーをクリーンアップするバッチ処理（Import::PlaceholderUserCleanupWorker）の設計を記載します。

### 本バッチの処理概要

GitLabのグループ/プロジェクトインポート機能で作成されたプレースホルダーユーザー（実際のユーザーに紐づけられていない仮ユーザー）を検出し、削除処理をスケジュールするバッチ処理です。

**業務上の目的・背景**：GitLabでプロジェクトやグループをインポートする際、元のユーザーがインポート先に存在しない場合、プレースホルダーユーザーが作成されます。これらのプレースホルダーユーザーは、後から実際のユーザーにマッピングされることを想定していますが、マッピングされずに残った場合はクリーンアップが必要です。本バッチは、namespace_idがnull（どのグループ/プロジェクトにも属していない）かつ削除試行回数が上限に達していないプレースホルダーユーザーを検出し、DeletePlaceholderUserWorkerをスケジュールすることで、不要なユーザーレコードの削除を実現します。

**バッチの実行タイミング**：日次実行（毎日0:00 UTC）

**主要な処理内容**：
1. 削除対象のプレースホルダーユーザー詳細を検索（eligible_for_deletion）
2. 各レコードの削除試行回数をインクリメント
3. 最大試行回数（15回）到達時は警告ログを出力
4. DeletePlaceholderUserWorkerを1秒間隔の遅延でスケジュール

**前後の処理との関連**：プロジェクト/グループインポート処理でプレースホルダーユーザーが作成され、ユーザーマッピング完了後に本バッチでクリーンアップされます。

**影響範囲**：import_placeholder_user_detailsテーブル、usersテーブル

## バッチ種別

データクレンジング / ユーザー削除スケジューリング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 00:00 UTC |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| インポート機能が有効 | グループ/プロジェクトインポート機能が利用可能であること |
| データベース接続 | PostgreSQLへの接続が確立されていること |

### 実行可否判定

特別な実行可否判定ロジックはありません。cronスケジュールに従って自動実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| import_placeholder_user_details | DB | プレースホルダーユーザー詳細情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| import_placeholder_user_details | DB | deletion_attempts, last_deletion_attempt_atの更新 |
| Sidekiqキュー | ジョブ | DeletePlaceholderUserWorkerジョブのスケジュール |
| ログ | ファイル/stdout | 最大試行回数到達時の警告ログ |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. 削除対象の検索
   └─ Import::PlaceholderUserDetail.eligible_for_deletion(MAX_ATTEMPTS)
   └─ namespace_id IS NULL かつ deletion_attempts < 15 のレコード
   └─ last_deletion_attempt_at IS NULL または 2日以上前のレコード
2. 各レコードの処理（find_each + with_index）
   └─ deletion_attemptsをインクリメント
   └─ 最大試行回数到達時は警告ログを出力
   └─ DeletePlaceholderUserWorker.perform_in(index秒, placeholder_user_id)
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[削除対象検索<br/>eligible_for_deletion]
    B --> C{レコード存在?}
    C -->|あり| D[削除試行回数インクリメント]
    D --> E{最大試行回数到達?}
    E -->|Yes| F[警告ログ出力]
    E -->|No| G[DeletePlaceholderUserWorker<br/>スケジュール]
    F --> G
    G --> H[次のレコードへ<br/>index*1秒の遅延]
    H --> C
    C -->|なし| I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| プレースホルダー検索 | import_placeholder_user_details | SELECT | 削除対象を検索 |
| 試行回数更新 | import_placeholder_user_details | UPDATE | deletion_attemptsをインクリメント |

### テーブル別操作詳細

#### import_placeholder_user_details

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, placeholder_user_id, deletion_attempts, last_deletion_attempt_at, namespace_id | eligible_for_deletion scope | UNIONクエリ使用 |
| UPDATE | deletion_attempts, last_deletion_attempt_at | +1, 現在時刻 | increment_counterで更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Redis::ConnectionError | Redis接続エラー | Sidekiqリトライ |
| - | ActiveRecord::StatementInvalid | SQL実行エラー | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

idempotent!が設定されているため、同じ処理を複数回実行しても問題ありません。削除に失敗したプレースホルダーは、DELETION_RETRY_PERIOD（2日）経過後に再度対象となります。MAX_ATTEMPTS（15回）に達した場合は警告ログが出力されますが、処理は継続されます。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | レコード単位 |
| コミットタイミング | 各increment_counterの完了時 |
| ロールバック条件 | 各レコードの更新失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 変動（インポート使用量に依存） |
| 目標処理時間 | 数分〜数十分（レコード数に応じた遅延あり） |
| メモリ使用量上限 | find_eachによるバッチ処理で制御 |

## 排他制御

idempotent!およびdeduplicate :until_executedが設定されているため、同時実行は防止され、冪等性も保証されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | 最大試行回数到達時 | message: 'Maximum deletion attempts (15) reached...', placeholder_user_id |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 最大試行回数到達件数 | 設定なし | Import::Framework::Logger |
| エラー件数 | 設定なし | Sentry/ErrorTracking |

## 備考

- MAX_ATTEMPTS = 15 で最大削除試行回数を定義
- DELETION_RETRY_PERIOD = 2.days でリトライ間隔を定義（PlaceholderUserDetailモデル）
- idempotent!が設定されており、安全に再実行可能
- deduplicate :until_executed により、実行中の重複起動を防止
- data_consistency: :sticky により、書き込み後のレプリカ遅延に対応
- eligible_for_deletion は以下の条件でUNIONクエリを生成：
  - namespace_id IS NULL AND deletion_attempts < MAX_ATTEMPTS AND last_deletion_attempt_at IS NULL
  - namespace_id IS NULL AND deletion_attempts < MAX_ATTEMPTS AND last_deletion_attempt_at < 2日前
- perform_inを使用して、インデックス * 1秒の遅延を設定し、負荷を分散
- 実際のユーザー削除はDeletePlaceholderUserWorkerが担当（非同期処理）
- Import::Framework::Loggerを使用した構造化ログ出力
