# バッチ設計書 72-StuckMergeJobsWorker

## 概要

本ドキュメントは、停滞したマージジョブを検出して処理するバッチ `StuckMergeJobsWorker` の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、locked状態で停滞しているマージリクエストを検出し、適切なステータスに更新するワーカーである。

**業務上の目的・背景**：マージリクエストのマージ処理中にSidekiqジョブが失敗または消失した場合、マージリクエストはlocked状態のまま残存する可能性がある。このような「孤児化」したマージリクエストを定期的に検出し、正しいステータスに復旧することで、ユーザーが再度マージ操作を実行できるようにする。これはシステムの信頼性とユーザー体験を向上させる重要なメンテナンス処理である。

**バッチの実行タイミング**：15分ごと（`*/15 * * * *`）にCronジョブとして実行される。

**主要な処理内容**：
1. locked状態のマージリクエストをバッチで取得（100件ずつ）
2. 各マージリクエストのマージジョブID（merge_jid）をSidekiqで確認
3. 完了したジョブのマージリクエストを特定
4. merge_commit_shaがある場合はmerged状態に、ない場合はunlockして再オープン可能に

**前後の処理との関連**：`MergeWorker` がマージ処理を実行し、このワーカーがその後始末を担当する。また、`MergeRequests::UnstickLockedMergeRequestsService` が将来的にこのワーカーを置き換える予定（フィーチャーフラグで制御）。

**影響範囲**：`merge_requests` テーブルのstate_idカラム、マージリクエストの状態遷移

## バッチ種別

データクレンジング / ステータス復旧処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 15分ごと |
| 実行時刻 | 毎時0, 15, 30, 45分 |
| 実行曜日 | 全曜日 |
| 実行日 | 毎日 |
| トリガー | cron（`*/15 * * * *`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Sidekiq接続 | SidekiqStatusの確認が可能であること |
| データベース接続 | 読み書き可能なデータベース接続 |

### 実行可否判定

- 特別な実行可否判定なし
- locked状態のマージリクエストが存在しない場合は処理をスキップ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | このワーカーはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| merge_requests | DB | locked状態でmerge_jidを持つレコード |
| Sidekiq | Redis | ジョブの実行状態 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| merge_requests | DB | state_idの更新 |
| Gitlab::AppLogger | ログ | 処理結果のログ出力 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. フィーチャーフラグ確認
   └─ use_locked_set? の確認
2a. フラグ有効時: UnstickLockedMergeRequestsService を実行
2b. フラグ無効時:
   └─ locked状態のMRをバッチ取得（100件）
   └─ merge_jidリストでSidekiqステータス確認
   └─ 完了したジョブのMRを特定
3. ステータス更新
   └─ merge_commit_shaあり → merged状態に更新
   └─ merge_commit_shaなし → unlock_mr実行
4. ログ出力
   └─ 更新したJIDと結果を記録
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{use_locked_set?}
    B -->|Yes| C[UnstickLockedMergeRequestsService]
    B -->|No| D[locked状態のMR取得]
    D --> E[Sidekiqステータス確認]
    E --> F{完了したジョブあり?}
    F -->|Yes| G{merge_commit_shaあり?}
    F -->|No| H[次のバッチ]
    G -->|Yes| I[merged状態に更新]
    G -->|No| J[unlock_mr実行]
    I --> K[ログ出力]
    J --> K
    K --> H
    H --> L{次のバッチあり?}
    L -->|Yes| D
    L -->|No| M[バッチ終了]
    C --> M
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| stuck_merge_requests | merge_requests | SELECT | locked状態のMR検索 |
| apply_current_state! | merge_requests | UPDATE | ステータス更新 |
| unlock_mr | merge_requests | UPDATE | ロック解除と状態遷移 |

### テーブル別操作詳細

#### merge_requests

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, merge_jid | state_id = locked, merge_jid IS NOT NULL | バッチ取得 |
| UPDATE | state_id | state_id = merged (3) | merge_commit_shaがある場合 |
| UPDATE | state_id | state_id = opened (1) | unlock時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | unlock失敗 | 状態遷移失敗時 | エラーログに記録、処理継続 |
| - | Sidekiq接続エラー | Redis接続失敗時 | Sidekiqによる自動リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | Sidekiqデフォルト |
| リトライ対象エラー | 標準例外 |

### 障害時対応

- unlock失敗時はエラーメッセージをログに記録
- 次回バッチ実行時に再度処理を試行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | レコード単位（各MRごと） |
| コミットタイミング | 各レコード更新時 |
| ロールバック条件 | 個別レコード更新失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 可変（停滞MR数に依存） |
| 目標処理時間 | 15分以内（次回実行まで） |
| メモリ使用量上限 | バッチサイズ100件で制御 |

## 排他制御

- バッチサイズ100件で処理を分割
- 各レコードは個別に更新（競合時は状態遷移エラー）
- `use_locked_set?` フィーチャーフラグで新旧処理を切り替え

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| INFOログ | 処理完了時 | 更新したJIDリスト |
| INFOログ | エラー時 | エラーメッセージとMR ID |
| 開始ログ | ジョブ開始時 | ジョブID、クラス名 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ失敗率 | 継続的な失敗 | Sidekiq監視システム |
| locked状態MR数 | 急増時 | 管理者通知 |

## 備考

- このワーカーは `idempotent!` として宣言されていない（時間依存のクエリのため）
- feature_category は `code_review_workflow`
- data_consistency は `always` に設定
- `MergeRequests::UnstickLockedMergeRequestsService` がフィーチャーフラグ完全展開後にこのワーカーのロジックを置き換える予定
- locked状態はマージ処理中の一時的な状態であり、通常は短時間で解除されるべき
