# バッチ設計書 74-Issues::RescheduleStuckIssueRebalancesWorker

## 概要

本ドキュメントは、停滞したIssue再バランス処理を再スケジュールするバッチ `Issues::RescheduleStuckIssueRebalancesWorker` の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Issueのrelative_position（相対位置）の再バランス処理が停滞した場合に、処理を再スケジュールするワーカーである。

**業務上の目的・背景**：GitLabのIssueボードやリストでは、Issueの並び順を相対位置（relative_position）で管理している。ユーザーがIssueをドラッグ＆ドロップで並び替えると、この値が更新される。長期間の運用で相対位置の値が偏り、新しい位置を挿入できなくなる可能性があるため、定期的に再バランス処理が必要となる。この再バランス処理が何らかの理由で停滞した場合、このワーカーが検出して再スケジュールすることで、処理の継続性を担保する。

**バッチの実行タイミング**：15分ごと（`*/15 * * * *`）にCronジョブとして実行される。

**主要な処理内容**：
1. Redisから再バランス処理中のネームスペースIDとプロジェクトIDを取得
2. 対象が存在しない場合は処理を終了
3. ネームスペース単位で `Issues::RebalancingWorker` を一括エンキュー
4. プロジェクト単位で `Issues::RebalancingWorker` を一括エンキュー

**前後の処理との関連**：`Issues::RebalancingWorker` が実際の再バランス処理を実行し、`Gitlab::Issues::Rebalancing::State` がRedisで処理状態を管理する。このワーカーはRedisの状態を監視し、停滞した処理を再開させる。

**影響範囲**：`issues` テーブルのrelative_positionカラム、Redisの再バランス状態

## バッチ種別

データメンテナンス / リカバリ処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 15分ごと |
| 実行時刻 | 毎時0, 15, 30, 45分 |
| 実行曜日 | 全曜日 |
| 実行日 | 毎日 |
| トリガー | cron（`*/15 * * * *`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Redis接続 | Redisへの接続が可能であること |
| データベース接続 | 読み取り可能な接続 |
| Sidekiq | ジョブのエンキューが可能であること |

### 実行可否判定

- Redisから取得したネームスペースID/プロジェクトIDが空の場合は処理をスキップ
- 再バランス処理中のコンテナが存在する場合のみ処理を実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | このワーカーはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Redis (SharedState) | Set | 再バランス中のコンテナ情報 |
| namespaces | DB | ネームスペースの存在確認 |
| projects | DB | プロジェクトの存在確認 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Sidekiq Queue | Job | Issues::RebalancingWorker ジョブ |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. 停滞コンテナ情報の取得
   └─ State.fetch_rebalancing_groups_and_projects を実行
   └─ Redisから再バランス中のネームスペース/プロジェクトIDを取得
2. 存在確認
   └─ 取得したIDが空でないことを確認
3. ネームスペースの再バランス再スケジュール
   └─ Namespace.id_in で対象を取得
   └─ bulk_perform_async_with_contexts でRebalancingWorkerをエンキュー
4. プロジェクトの再バランス再スケジュール
   └─ Project.id_in で対象を取得
   └─ bulk_perform_async_with_contexts でRebalancingWorkerをエンキュー
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Redisから停滞コンテナ取得]
    B --> C{コンテナあり?}
    C -->|No| D[処理終了]
    C -->|Yes| E[ネームスペース取得]
    E --> F[RebalancingWorkerエンキュー]
    F --> G[プロジェクト取得]
    G --> H[RebalancingWorkerエンキュー]
    H --> D
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Namespace.id_in | namespaces | SELECT | 対象ネームスペースの取得 |
| Project.id_in | projects | SELECT | 対象プロジェクトの取得 |

### テーブル別操作詳細

#### namespaces

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, * | id IN (namespace_ids) | バルク取得 |

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, * | id IN (project_ids) | バルク取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Redis接続エラー | Redis接続失敗時 | Sidekiqによる自動リトライ |
| - | データベースエラー | DB接続失敗時 | Sidekiqによる自動リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | Sidekiqデフォルト |
| リトライ対象エラー | 標準例外 |

### 障害時対応

- Redis/DB接続失敗時はSidekiqによる自動リトライ
- 次回のCron実行で再度処理を試行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取りとエンキューのみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 同時実行制限: 最大5件 |
| 目標処理時間 | 15分以内 |
| メモリ使用量上限 | 軽量処理のため制限なし |

## 排他制御

- `deduplicate :until_executed, including_scheduled: true` で重複実行を防止
- `Issues::Rebalancing::State` で同時再バランス数を最大5件に制限（MAX_NUMBER_OF_CONCURRENT_REBALANCES）
- Redisに有効期限10日（REDIS_EXPIRY_TIME）を設定

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ジョブID、クラス名 |
| 終了ログ | ジョブ完了時 | 処理結果 |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ失敗率 | 継続的な失敗 | Sidekiq監視システム |
| 停滞コンテナ数 | 長期間存在 | 管理者通知 |

## 備考

- このワーカーは `idempotent!` として宣言されている
- feature_category は `team_planning`
- data_consistency は `sticky` に設定
- urgency は `low` に設定
- `deduplicate :until_executed, including_scheduled: true` でスケジュール済みジョブも含めて重複排除
- 再バランス処理のRedis状態はSHARED_STATEに保存される
- 同時実行可能な再バランス処理は最大5件（MAX_NUMBER_OF_CONCURRENT_REBALANCES）
