# バッチ設計書 78-Analytics::UsageTrends::CountJobTriggerWorker

## 概要

本ドキュメントは、利用トレンドのカウントジョブをトリガーするバッチ `Analytics::UsageTrends::CountJobTriggerWorker` の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、GitLabインスタンスの各種メトリクス（ユーザー数、プロジェクト数、イシュー数など）の測定を開始するトリガーワーカーである。

**業務上の目的・背景**：GitLabでは、インスタンスの利用状況を分析するためにUsage Trends機能を提供している。この機能は、ユーザー数、プロジェクト数、グループ数、イシュー数、マージリクエスト数など、様々なメトリクスの時系列データを収集・表示する。これらのデータは管理者がインスタンスの成長傾向を把握し、リソース計画を立てるために活用される。このバッチは、各メトリクスの測定ジョブを3分間隔でスケジュールし、データベース負荷を分散しながら正確な測定を行う。

**バッチの実行タイミング**：毎日23時50分（`50 23 */1 * *`）にCronジョブとして実行される。

**主要な処理内容**：
1. 現在時刻を記録（recorded_at）
2. 全ての測定識別子に対して引数を構築
3. 各測定に対して `CounterJobWorker` を3分間隔でエンキュー

**前後の処理との関連**：このワーカーが測定ジョブをトリガーし、`CounterJobWorker` が実際のカウント処理を実行する。カウント結果は `analytics_usage_trends_measurements` テーブルに保存される。

**影響範囲**：`analytics_usage_trends_measurements` テーブルへのデータ挿入

## バッチ種別

集計処理 / メトリクス収集

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 23:50 |
| 実行曜日 | 全曜日 |
| 実行日 | 毎日 |
| トリガー | cron（`50 23 */1 * *`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | 読み取り可能な接続 |
| Sidekiq | ジョブのエンキューが可能であること |

### 実行可否判定

- 特別な実行可否判定なし
- 常に測定ジョブをトリガーする

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | このワーカーはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Measurement.measurement_identifier_values | 定数 | 測定識別子リスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Sidekiq Queue | Job | CounterJobWorker ジョブ（複数） |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. 記録時刻の取得
   └─ Time.zone.now を recorded_at として記録
2. 引数構築
   └─ WorkersArgumentBuilder で各測定の引数を生成
   └─ 測定識別子、min_id、max_id、recorded_at を含む
3. ジョブスケジュール
   └─ 各測定に対して CounterJobWorker をエンキュー
   └─ 初回は3分後、以降は3分ずつ増加
   └─ 例: 3分後、6分後、9分後...
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[recorded_at取得]
    B --> C[測定識別子リスト取得]
    C --> D[WorkersArgumentBuilder実行]
    D --> E[各測定の引数生成]
    E --> F[CounterJobWorkerエンキュー]
    F --> G{次の測定あり?}
    G -->|Yes| H[perform_in += 3分]
    H --> F
    G -->|No| I[処理終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | このワーカー自体はDB操作なし |

### テーブル別操作詳細

このワーカーはデータベース操作を行わない。実際の測定と保存は `CounterJobWorker` が担当する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | エンキュー失敗 | Redis接続失敗時 | Sidekiqによる自動リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | Sidekiqデフォルト |
| リトライ対象エラー | 標準例外 |

### 障害時対応

- トリガー失敗時は次回の日次実行で再試行
- 個々の測定ジョブの失敗は `CounterJobWorker` 側でハンドリング

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 測定識別子の数（可変） |
| 目標処理時間 | 数秒（エンキューのみ） |
| メモリ使用量上限 | 軽量処理のため制限なし |

## 排他制御

- 特別な排他制御なし
- 3分間隔のスケジューリングで測定ジョブ間の負荷を分散

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ジョブID、クラス名 |
| 終了ログ | ジョブ完了時 | 処理結果 |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ失敗率 | 継続的な失敗 | Sidekiq監視システム |
| 測定データの欠落 | 日次データなし | 管理者通知 |

## 備考

- このワーカーは `idempotent!` として宣言されている
- feature_category は `devops_reports`
- data_consistency は `sticky` に設定
- urgency は `low` に設定
- DEFAULT_DELAY は3分（各測定ジョブ間の間隔）
- `CounterJobWorker` は最大250秒のタイムアウトで処理を実行
- タイムアウト時は続きから再実行する仕組み（partial_results）
- 23:50に実行することで、日次データを日付変更前に収集
- 測定識別子の例: ユーザー数、プロジェクト数、グループ数、イシュー数など
