# バッチ設計書 8-Ci_PartitioningWorker

## 概要

本ドキュメントは、CIテーブルのパーティション管理を行うバッチ処理「Ci::PartitioningWorker」の設計仕様を記載する。

### 本バッチの処理概要

Ci::PartitioningWorkerは、GitLabのCI/CDシステムにおけるデータベーステーブルのパーティション管理を自動化するバッチ処理である。大規模なCI/CDデータ（パイプライン、ビルド、アーティファクト等）を効率的に管理するため、テーブルのパーティション作成・状態同期・書き込み先切り替えを行う。

**業務上の目的・背景**：GitLabの大規模インスタンスでは、CI/CDに関連するテーブル（ci_pipelines、ci_builds等）のレコード数が膨大になり、クエリパフォーマンスやメンテナンス性に影響を与える。テーブルパーティショニングにより、データを論理的に分割し、古いデータの削除やアーカイブを効率化する。本バッチは、パーティションの作成、準備状態の確認、アクティブパーティションの切り替えを自動的に行い、CI/CDシステムのスケーラビリティを確保する。

**バッチの実行タイミング**：毎日午前2時に実行（cron: `0 2 * * *`）。深夜の低負荷時間帯にパーティション管理処理を実行する。

**主要な処理内容**：
1. デフォルトパーティションのセットアップ（初回実行時）
2. 現在のパーティションが閾値を超えている場合、次のパーティションを作成
3. 準備中のパーティションが利用可能になったか確認し、状態を更新
4. 必要に応じて書き込み先パーティションを切り替え

**前後の処理との関連**：本ワーカーはCIテーブル全体のパーティション管理を担当する。パーティション切り替え後、新しいパイプラインやビルドは新しいパーティションに書き込まれる。古いパーティションのデータは別途アーカイブ・削除処理で管理される。

**影響範囲**：CI/CDシステム全体のデータストレージに影響。パーティション切り替えはトランザクションレベルで行われ、通常の運用に影響を与えない。

## バッチ種別

データベース管理 / システムメンテナンス

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 02:00 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron (`0 2 * * *`) |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| なし | 常に実行可能 |

### 実行可否判定

`deduplicate :until_executed`により重複実行は防止される。現在のパーティションが存在しない場合は、デフォルトセットアップのみ実行。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | cronジョブとして引数なしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ci_partitions | DB | CIパーティション管理テーブル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ci_partitions | DB | パーティションレコードの作成・更新 |
| データベーススキーマ | DDL | 新規パーティションテーブルの作成 |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. デフォルトパーティションセットアップ
   └─ Ci::Partitions::SetupDefaultService.new.execute
   └─ 現在のパーティションが存在しない場合のみ実行
2. 現在のパーティション取得
   └─ Ci::Partition.current
3. 新規パーティション作成判定
   └─ Ci::Partitions::CreateService.new(partition).execute
   └─ 閾値超過かつヘッドルーム不足の場合に作成
4. パーティション状態同期
   └─ Ci::Partitions::SyncService.new(partition).execute
   └─ preparing→ready、必要に応じて書き込み先切り替え
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[デフォルトパーティションセットアップ]
    B --> C{現在のパーティション存在?}
    C -->|なし| H[バッチ終了]
    C -->|あり| D[CreateService実行]
    D --> E{閾値超過 & ヘッドルーム不足?}
    E -->|はい| F[新規パーティション作成]
    E -->|いいえ| G[SyncService実行]
    F --> G
    G --> I{準備完了パーティション?}
    I -->|あり| J[書き込み先切り替え]
    I -->|なし| H
    J --> H
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| デフォルトセットアップ | ci_partitions | UPSERT | 初期パーティションレコード作成 |
| 現在パーティション取得 | ci_partitions | SELECT | status='current'のレコード取得 |
| 新規パーティション作成 | ci_partitions | INSERT | 次のパーティションレコード作成 |
| 状態更新 | ci_partitions | UPDATE | preparing→ready→current |

### テーブル別操作詳細

#### ci_partitions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPSERT | id, status | DEFAULT_PARTITION_VALUES, active/current | 初回セットアップ |
| SELECT | 全カラム | status='current' | 現在のパーティション取得 |
| INSERT | id, status | 次のID, preparing | 新規パーティション |
| UPDATE | status | ready/current | 状態遷移 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DB接続エラー | データベース接続失敗 | Sidekiqによるリトライ |
| - | パーティション作成失敗 | DDL実行失敗 | エラーログ出力、次回リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | Sidekiqデフォルト |
| リトライ対象エラー | 全般的なエラー |

### 障害時対応

1. パーティション作成失敗の場合：次回実行時に再試行
2. 状態遷移失敗の場合：手動でci_partitionsテーブルを確認・修正

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各サービス単位 |
| コミットタイミング | 各サービスの処理完了時 |
| ロールバック条件 | サービス処理中のエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数レコード（パーティション管理のみ） |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

- `deduplicate :until_executed`による重複実行防止
- パーティション状態遷移はデータベースレベルの排他制御

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 進捗ログ | サービス実行時 | パーティション操作情報 |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| パーティション数 | ヘッドルーム不足 | 運用チーム |
| 実行失敗 | 連続失敗 | 運用チーム |

## 備考

- `idempotent!`が設定されており、冪等性が保証されている
- `data_consistency :always`が設定されており、プライマリDBを使用
- `deduplicate :until_executed`で重複実行を防止
- `feature_category :ci_scaling`でCI/CDスケーリング機能として分類
- DEFAULT_PARTITION_VALUES: デフォルトで作成されるパーティションID値
- HEADROOM_PARTITIONS = 2: 事前に準備しておくパーティション数
- パーティションの状態遷移: preparing → ready → current → active
- 深夜2時の実行により、日中のCI/CD処理への影響を最小化
