# バッチ設計書 81-Metrics::GlobalMetricsUpdateWorker

## 概要

本ドキュメントは、GitLabにおけるグローバルメトリクス更新を行うバッチ処理「Metrics::GlobalMetricsUpdateWorker」の設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、GitLabインスタンス全体のグローバルメトリクスを定期的に更新するためのCronジョブである。現在の実装ではperformメソッドが空であり、将来の拡張のためのプレースホルダーとして機能している。

**業務上の目的・背景**：GitLabの監視・オブザーバビリティ機能の一環として、システム全体のメトリクス情報を定期的に収集・更新する必要がある。このバッチは、Prometheusなどの監視システムと連携して、GitLabインスタンスの健全性やパフォーマンスを把握するための基盤を提供する。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。CronjobQueueを使用しており、設定されたスケジュールに従って自動実行される。

**主要な処理内容**：
1. ExclusiveLeaseGuardによる排他制御を取得（2分のタイムアウト）
2. グローバルメトリクスの更新処理を実行（現在は空実装）
3. 処理完了後、リースを解放

**前後の処理との関連**：GitlabServicePingWorker（No.80）と連携して、監視・メトリクス収集の機能を補完する。独立して実行可能であり、他のバッチへの依存関係はない。

**影響範囲**：監視システムのメトリクスデータに影響を与える可能性がある。現在は空実装のため、システムへの直接的な影響はない。

## バッチ種別

メトリクス収集・更新処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cron） |
| 実行時刻 | 設定により異なる |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ExclusiveLease取得 | 他のインスタンスで同一ワーカーが実行中でないこと |
| feature_category | observability機能が有効であること |

### 実行可否判定

ExclusiveLeaseGuardによる排他制御を使用し、2分間のリースタイムアウトを設定。他のプロセスがリースを保持している場合は実行をスキップする。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| なし | - | 現在の実装では入力データなし |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| なし | - | 現在の実装では出力なし |

### 出力ファイル仕様

現在の実装ではファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. ワーカー起動
   └─ Sidekiqによりジョブがキューから取得される
2. 排他制御チェック
   └─ ExclusiveLeaseGuardによるリース取得を試行
3. performメソッド実行
   └─ 現在は空実装（将来の拡張用）
4. 処理完了
   └─ リースの解放
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{ExclusiveLease取得}
    B -->|成功| C[perform実行]
    B -->|失敗| D[スキップ]
    C --> E[処理完了]
    D --> E
    E --> F[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | 現在の実装ではDB操作なし |

### テーブル別操作詳細

現在の実装ではデータベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | リース取得失敗 | 他プロセスがリースを保持 | 自動スキップ、次回実行を待つ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | Sidekiqデフォルト |
| リトライ対象エラー | 一般的な例外 |

### 障害時対応

idempotent!が設定されているため、再実行しても安全。障害発生時は次回のCron実行を待つか、手動で再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | なし |
| 目標処理時間 | 2分以内（リースタイムアウト） |
| メモリ使用量上限 | 最小限 |

## 排他制御

ExclusiveLeaseGuardを使用した排他制御を実装。LEASE_TIMEOUT = 2分に設定されており、同時に複数のインスタンスで実行されることを防止する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | ワーカー起動情報 |
| 終了ログ | バッチ終了時 | ワーカー完了情報 |
| エラーログ | エラー発生時 | エラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 2分（リースタイムアウト） | 運用チーム |
| 実行失敗 | 連続3回 | 運用チーム |

## 備考

- feature_category: :observability
- data_consistency: :sticky
- idempotent: true
- 現在の実装ではperformメソッドが空であり、将来のメトリクス更新機能の拡張に備えたプレースホルダーとして機能している
