# バッチ設計書 82-Gitlab::Version::VersionCheckCronWorker

## 概要

本ドキュメントは、GitLabのバージョンチェックを行うバッチ処理「Gitlab::Version::VersionCheckCronWorker」の設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、GitLabインスタンスの現在のバージョン情報をGitLab社のバージョンチェックサーバーに送信し、最新バージョン情報や更新推奨情報を取得するCronジョブである。

**業務上の目的・背景**：GitLabインスタンスを運用する管理者がセキュリティアップデートや新機能リリースの情報を把握するために、定期的にバージョンチェックを行う必要がある。このバッチは、現在のGitLabバージョンを外部サーバーに送信し、更新情報を取得してキャッシュに保存する。これにより、管理画面でバージョン更新の推奨情報を表示できるようになる。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。サービスPing機能の一部として動作する。

**主要な処理内容**：
1. 現在のGitLabバージョン情報をBase64エンコードして準備
2. version.gitlab.com に対してHTTP GETリクエストを送信
3. レスポンスが成功（HTTP 200）の場合、JSONをパースしてキャッシュに保存
4. 失敗した場合はエラーログを出力

**前後の処理との関連**：GitlabServicePingWorker（No.80）と関連して、GitLabの利用状況・バージョン情報の送信機能を構成する。独立して実行可能であり、他のバッチへの依存関係はない。

**影響範囲**：Rails.cacheの「version_check」キーにバージョン情報を保存。管理者向けのバージョン更新通知機能に影響する。

## バッチ種別

データ連携処理（外部API通信）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cron） |
| 実行時刻 | 設定により異なる |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ネットワーク接続 | version.gitlab.com への外部通信が可能であること |
| feature_category | service_ping機能が有効であること |

### 実行可否判定

特別な実行可否判定なし。Cronスケジュールに従って自動実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Gitlab::VERSION | Ruby定数 | 現在のGitLabバージョン番号 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Rails.cache["version_check"] | Hash/JSON | バージョンチェック結果 |

### 出力ファイル仕様

ファイル出力なし。Rails.cacheへの保存のみ。

## 処理フロー

### 処理シーケンス

```
1. ワーカー起動
   └─ Sidekiqによりジョブがキューから取得される
2. バージョン情報準備
   └─ Gitlab::VERSIONをJSONに変換しBase64エンコード
3. HTTPリクエスト送信
   └─ https://version.gitlab.com/check.json にGETリクエスト
4. レスポンス処理
   ├─ HTTP 200の場合：JSONパースしてキャッシュに保存
   └─ それ以外の場合：エラーログ出力
5. 処理完了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[バージョン情報準備]
    B --> C[Base64エンコード]
    C --> D[HTTP GET リクエスト]
    D --> E{レスポンスコード}
    E -->|200| F[JSONパース]
    F --> G[キャッシュ保存]
    E -->|その他| H[エラーログ出力]
    G --> I[バッチ終了]
    H --> I
    F -->|ParserError| J[パースエラーログ出力]
    J --> I
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | DBへの直接操作なし（キャッシュのみ） |

### テーブル別操作詳細

データベース操作は行わない。Rails.cacheへの書き込みのみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | HTTP Error | レスポンスコードが200以外 | エラーログ出力、次回実行を待つ |
| - | JSON::ParserError | レスポンスJSONのパース失敗 | エラーログ出力、次回実行を待つ |
| - | Network Error | ネットワーク接続失敗 | 自動リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 3回（sidekiq_options retry: 3） |
| リトライ間隔 | Sidekiqデフォルト（指数バックオフ） |
| リトライ対象エラー | ネットワークエラー等 |

### 障害時対応

idempotent!が設定されているため、再実行しても安全。外部サーバーへの接続失敗時は3回までリトライ後、次回Cron実行を待つ。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1リクエスト/実行 |
| 目標処理時間 | 数秒（HTTP通信時間に依存） |
| メモリ使用量上限 | 最小限 |

## 排他制御

deduplicate :until_executedが設定されており、同一ジョブが実行完了まで重複実行されることを防止する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 成功ログ | バージョンチェック成功時 | "Version check succeeded" + result |
| エラーログ | HTTPエラー時 | "Version check failed" + code, message |
| エラーログ | JSONパースエラー時 | "Parsing version check response failed" + message, code |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 連続失敗回数 | 3回以上 | 運用チーム |
| レスポンス時間 | 30秒以上 | 運用チーム |

## 備考

- feature_category: :service_ping
- data_consistency: :sticky
- idempotent: true
- deduplicate: :until_executed
- urgency: :low
- 外部通信先: https://version.gitlab.com/check.json
- 送信データ: { version: Gitlab::VERSION } をBase64エンコード
