# バッチ設計書 83-Namespaces::PruneAggregationSchedulesWorker

## 概要

本ドキュメントは、名前空間の集計スケジュールをプルーニング（処理）するバッチ処理「Namespaces::PruneAggregationSchedulesWorker」の設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、Namespace::AggregationScheduleテーブルに保留されているスケジュールレコードを処理し、各名前空間のルートストレージ統計の再計算をスケジュールするCronジョブである。

**業務上の目的・背景**：GitLabでは、名前空間（グループやプロジェクト）のストレージ使用量を正確に把握するために、定期的にストレージ統計を再計算する必要がある。このバッチは、AggregationScheduleテーブルに蓄積された保留中のスケジュールを処理し、ストレージ統計の更新を効率的にトリガーする。これにより、管理者やユーザーは正確なストレージ使用量を確認できる。

**バッチの実行タイミング**：毎日午前1時5分に実行されるようスケジュールされている（コメントによる）。

**主要な処理内容**：
1. Namespace::AggregationScheduleテーブルから全てのレコードを取得
2. 各レコードに対してfind_eachでイテレーション
3. schedule_root_storage_statisticsメソッドを呼び出し、ストレージ統計の再計算をスケジュール

**前後の処理との関連**：EnableDescendantsCacheCronWorker（No.84）およびProcessOutdatedNamespaceDescendantsCronWorker（No.85）と連携して、名前空間の統計情報管理機能を構成する。

**影響範囲**：Namespace::AggregationScheduleテーブルのレコード処理、ルートストレージ統計の再計算ジョブのスケジューリングに影響する。

## バッチ種別

集計処理（スケジューリング）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 01:05（コメントによる） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| AggregationScheduleレコード存在 | 処理対象のスケジュールレコードが存在すること |
| feature_category | source_code_management機能が有効であること |

### 実行可否判定

特別な実行可否判定なし。AggregationScheduleレコードが存在しない場合は何も処理せずに終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Namespace::AggregationSchedule | DB | 保留中の集計スケジュールレコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Sidekiqジョブキュー | Job | ストレージ統計再計算ジョブ |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. ワーカー起動
   └─ Sidekiqによりジョブがキューから取得される
2. スケジュールレコード取得
   └─ Namespace::AggregationSchedule.all でレコード取得
3. イテレーション処理
   └─ find_eachで各レコードを処理
4. ストレージ統計スケジュール
   └─ schedule_root_storage_statistics メソッド呼び出し
5. 処理完了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[AggregationSchedule.all取得]
    B --> C{レコード存在?}
    C -->|なし| D[バッチ終了]
    C -->|あり| E[find_eachでイテレーション]
    E --> F[schedule_root_storage_statistics呼び出し]
    F --> G{次のレコード?}
    G -->|あり| E
    G -->|なし| D
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| スケジュール取得 | namespace_aggregation_schedules | SELECT | 全レコードを取得 |
| 統計スケジュール | - | - | schedule_root_storage_statisticsの内部動作に依存 |

### テーブル別操作詳細

#### namespace_aggregation_schedules

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | 全レコード | find_eachでバッチ処理 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DBエラー | データベース接続失敗 | 自動リトライ |
| - | タイムアウト | 処理時間超過 | 次回実行を待つ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | Sidekiqデフォルト（指数バックオフ） |
| リトライ対象エラー | 一般的な例外 |

### 障害時対応

idempotentではないが、再実行しても同じスケジュール処理が行われるため安全。障害発生時は次回のCron実行を待つか、手動で再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | レコード単位 |
| コミットタイミング | 各レコード処理後 |
| ロールバック条件 | 個別レコード処理の失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 可変（保留スケジュール数に依存） |
| 目標処理時間 | 処理件数に依存 |
| メモリ使用量上限 | find_eachによるバッチ処理で制限 |

## 排他制御

特別な排他制御なし。worker_resource_boundary :cpuが設定されており、CPUリソースの境界が設定されている。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | ワーカー起動情報 |
| 終了ログ | バッチ終了時 | ワーカー完了情報 |
| エラーログ | エラー発生時 | エラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 設定による | 運用チーム |
| 失敗回数 | 連続3回以上 | 運用チーム |

## 備考

- feature_category: :source_code_management
- data_consistency: :always
- idempotent: false
- worker_resource_boundary: :cpu
- 毎日午前1:05に実行されるようスケジュール（ソースコードコメントによる）
