# バッチ設計書 86-Packages::CleanupPackageRegistryWorker

## 概要

本ドキュメントは、パッケージレジストリのクリーンアップを行うバッチ処理「Packages::CleanupPackageRegistryWorker」の設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、パッケージレジストリ内の削除対象リソース（パッケージファイル、メタデータキャッシュ、シンボルなど）をクリーンアップするためのCronジョブである。各種クリーンアップワーカーの実行をオーケストレーションする役割を持つ。

**業務上の目的・背景**：GitLabのパッケージレジストリでは、パッケージファイルの削除、クリーンアップポリシーの適用、古いメタデータキャッシュの削除などが定期的に必要となる。このバッチは、これらのクリーンアップ処理を統合的に管理し、ストレージの効率的な利用とデータの整合性を維持する。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。

**主要な処理内容**：
1. 削除待ち（pending_destruction）のパッケージファイルが存在する場合、CleanupPackageFileWorkerをエンキュー
2. 実行可能なクリーンアップポリシーが存在する場合、ExecutePolicyWorkerをエンキュー
3. 削除待ちのNPMメタデータキャッシュが存在する場合、CleanupStaleMetadataCacheWorkerをエンキュー
4. 削除待ちのHelmメタデータキャッシュが存在する場合、CleanupStaleMetadataCacheWorkerをエンキュー
5. 削除待ちのNugetシンボルが存在する場合、CleanupStaleSymbolsWorkerをエンキュー
6. 各種カウントをログに出力

**前後の処理との関連**：DeleteOrphanedDependenciesWorker（No.87）およびCleanupDanglingPackageFilesWorker（No.88）と連携して、パッケージレジストリ全体のクリーンアップを行う。

**影響範囲**：packages_package_files、packages_cleanup_policies、packages_npm_metadata_caches、packages_helm_metadata_caches、packages_nuget_symbolsテーブル。

## バッチ種別

データクレンジング（オーケストレーション）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cron） |
| 実行時刻 | 設定により異なる |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| feature_category | package_registry機能が有効であること |

### 実行可否判定

各クリーンアップ対象の存在をチェックし、存在する場合のみ対応するワーカーをエンキューする。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Packages::PackageFile.pending_destruction | DB | 削除待ちパッケージファイル |
| Packages::Cleanup::Policy.runnable | DB | 実行可能なクリーンアップポリシー |
| Packages::Npm::MetadataCache.pending_destruction | DB | 削除待ちNPMメタデータ |
| Packages::Helm::MetadataCache.pending_destruction | DB | 削除待ちHelmメタデータ |
| Packages::Nuget::Symbol.pending_destruction | DB | 削除待ちNugetシンボル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Sidekiqジョブキュー | Job | 各種クリーンアップワーカージョブ |
| Sidekiqログ | Metadata | 各種カウント情報 |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. ワーカー起動
   └─ Sidekiqによりジョブがキューから取得される
2. パッケージファイルクリーンアップ確認
   ├─ pending_destructionレコード存在チェック
   └─ 存在する場合、CleanupPackageFileWorkerをエンキュー
3. クリーンアップポリシー確認
   ├─ runnableポリシー存在チェック
   └─ 存在する場合、ExecutePolicyWorkerをエンキュー
4. NPMメタデータキャッシュ確認
   ├─ pending_destructionレコード存在チェック
   └─ 存在する場合、CleanupStaleMetadataCacheWorkerをエンキュー
5. Helmメタデータキャッシュ確認
   ├─ pending_destructionレコード存在チェック
   └─ 存在する場合、CleanupStaleMetadataCacheWorkerをエンキュー
6. Nugetシンボル確認
   ├─ pending_destructionレコード存在チェック
   └─ 存在する場合、CleanupStaleSymbolsWorkerをエンキュー
7. ログ出力
   └─ 各種カウント情報をメタデータとして出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{PackageFile pending?}
    B -->|Yes| C[CleanupPackageFileWorker エンキュー]
    B -->|No| D{Policy runnable?}
    C --> D
    D -->|Yes| E[ExecutePolicyWorker エンキュー]
    D -->|No| F{NPM cache pending?}
    E --> F
    F -->|Yes| G[NPM CleanupStaleMetadataCacheWorker エンキュー]
    F -->|No| H{Helm cache pending?}
    G --> H
    H -->|Yes| I[Helm CleanupStaleMetadataCacheWorker エンキュー]
    H -->|No| J{Nuget symbol pending?}
    I --> J
    J -->|Yes| K[CleanupStaleSymbolsWorker エンキュー]
    J -->|No| L[カウントログ出力]
    K --> L
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 存在チェック | packages_package_files | SELECT/EXISTS | pending_destructionの存在確認 |
| 存在チェック | packages_cleanup_policies | SELECT/EXISTS | runnableの存在確認 |
| 存在チェック | packages_npm_metadata_caches | SELECT/EXISTS | pending_destructionの存在確認 |
| 存在チェック | packages_helm_metadata_caches | SELECT/EXISTS | pending_destructionの存在確認 |
| 存在チェック | packages_nuget_symbols | SELECT/EXISTS | pending_destructionの存在確認 |
| カウント取得 | 各テーブル | SELECT COUNT | ログ用カウント取得 |

### テーブル別操作詳細

#### packages_package_files

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | status | pending_destruction, processing, error | 各ステータスのカウント |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DBエラー | データベース接続失敗 | 自動リトライ |
| - | ワーカーエンキュー失敗 | Sidekiq接続失敗 | 自動リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | Sidekiqデフォルト（指数バックオフ） |
| リトライ対象エラー | 一般的な例外 |

### 障害時対応

idempotent!が設定されているため、再実行しても安全。実際の削除処理は子ワーカーで行われるため、本ワーカーの失敗は影響が限定的。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（チェックとエンキューのみ） |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 5回のexists?チェック + カウント |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | 最小限 |

## 排他制御

特別な排他制御なし。子ワーカーはperform_with_capacityで実行され、キャパシティ制御される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| メタデータ | 処理完了時 | pending_destruction_package_files_count |
| メタデータ | 処理完了時 | processing_package_files_count |
| メタデータ | 処理完了時 | error_package_files_count |
| メタデータ | 処理完了時 | pending_cleanup_policies_count |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| pending_destruction件数 | 増加傾向 | 運用チーム |
| error_package_files件数 | 0以上 | 運用チーム |

## 備考

- feature_category: :package_registry
- data_consistency: :sticky
- idempotent: true
- 子ワーカー: CleanupPackageFileWorker, ExecutePolicyWorker, CleanupStaleMetadataCacheWorker（NPM/Helm）, CleanupStaleSymbolsWorker
- perform_with_capacityで子ワーカーをキャパシティ制御付きでエンキュー
