# バッチ設計書 87-Packages::Cleanup::DeleteOrphanedDependenciesWorker

## 概要

本ドキュメントは、孤立したパッケージ依存関係を削除するバッチ処理「Packages::Cleanup::DeleteOrphanedDependenciesWorker」の設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、パッケージレジストリ内で孤立した（どのパッケージからも参照されていない）依存関係レコードを検出し、削除するCronジョブである。

**業務上の目的・背景**：GitLabのパッケージレジストリでは、パッケージ間の依存関係がpackages_dependenciesテーブルに格納される。パッケージが削除されると、その依存関係レコードが孤立することがある。このバッチは、これらの孤立したレコードを定期的にクリーンアップし、データベースの整合性とストレージ効率を維持する。

**バッチの実行タイミング**：10分間隔のCronジョブとして実行される。最大実行時間は2分、最大バッチ数は10に制限されている。

**主要な処理内容**：
1. Redisから前回処理した最後の依存関係IDを取得
2. packages_dependenciesテーブルから100件ずつバッチで取得
3. 各バッチで孤立したレコード（.orphaned）を削除
4. 最大10バッチまたは2分経過で処理を終了
5. 次回開始位置をRedisに保存（2時間有効）
6. 全処理完了時はカーソルをリセット

**前後の処理との関連**：CleanupPackageRegistryWorker（No.86）と連携して、パッケージレジストリ全体のクリーンアップを行う。

**影響範囲**：packages_dependenciesテーブル、Redisのカーソル位置キー。

## バッチ種別

データクレンジング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 10分間隔 |
| 実行時刻 | 10分ごと |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Redis接続 | SharedStateのRedisに接続可能であること |
| feature_category | package_registry機能が有効であること |

### 実行可否判定

特別な実行可否判定なし。孤立レコードが存在しなくても実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Packages::Dependency | DB | パッケージ依存関係テーブル |
| Redis | Cache | カーソル位置（last_processed_dependency_id） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| packages_dependencies | DB | 孤立レコードの削除 |
| Redis | Cache | 次回処理開始位置 |
| Sidekiqログ | Metadata | last_processed_dependency_id, deleted_rows_count |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. ワーカー起動
   └─ Sidekiqによりジョブがキューから取得される
2. 開始時刻記録
   └─ start_timeを記録
3. カーソル位置取得
   └─ Redisから前回の最後の依存関係IDを取得
4. バッチ処理ループ
   ├─ 100件ずつ依存関係を取得
   ├─ 孤立レコードを削除（.orphaned.delete_all）
   ├─ 削除件数を集計
   ├─ 10バッチ到達または2分経過で終了
   └─ 次回開始位置をRedisに保存
5. カーソル管理
   ├─ 処理継続の場合：カーソルを保存（2時間有効）
   └─ 全処理完了の場合：カーソルをリセット
6. 処理完了
   └─ メタデータログ出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[開始時刻記録]
    B --> C[Redisからカーソル取得]
    C --> D[依存関係バッチ取得 100件]
    D --> E[孤立レコード削除]
    E --> F[削除件数集計]
    F --> G{10バッチ到達?}
    G -->|Yes| H[カーソル保存]
    G -->|No| I{2分経過?}
    I -->|Yes| H
    I -->|No| D
    H --> J[メタデータログ出力]
    J --> K{全処理完了?}
    K -->|Yes| L[カーソルリセット]
    K -->|No| M[バッチ終了]
    L --> M
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 依存関係取得 | packages_dependencies | SELECT | バッチで依存関係を取得 |
| 孤立レコード削除 | packages_dependencies | DELETE | 孤立したレコードを削除 |

### テーブル別操作詳細

#### packages_dependencies

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | id >= last_processed_id | each_batchで100件ずつ |
| DELETE | * | orphanedスコープに該当 | delete_allで一括削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 時間超過 | 2分経過 | 処理中断、次回継続 |
| - | バッチ上限 | 10バッチ到達 | 処理中断、次回継続 |
| - | DBエラー | データベース接続失敗 | 自動リトライ |
| - | Redisエラー | Redis接続失敗 | 自動リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | Sidekiqデフォルト（指数バックオフ） |
| リトライ対象エラー | 一般的な例外 |

### 障害時対応

idempotent!が設定されているため、再実行しても安全。カーソル位置がRedisに保存されているため、中断後も継続処理可能。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位（100件） |
| コミットタイミング | 各バッチのdelete_all後 |
| ロールバック条件 | 削除失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大1000件/実行（100件 x 10バッチ） |
| 目標処理時間 | 最大2分（MAX_RUN_TIME） |
| メモリ使用量上限 | バッチ処理により制限 |

## 排他制御

特別な排他制御なし。カーソルによる増分処理で複数実行時の競合を軽減。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| メタデータ | 処理完了時 | last_processed_packages_dependency_id |
| メタデータ | 処理完了時 | deleted_rows_count |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 2分（MAX_RUN_TIME） | 運用チーム |
| 削除件数 | 異常な増加 | 運用チーム |

## 備考

- feature_category: :package_registry
- data_consistency: :sticky
- idempotent: true
- urgency: :low
- MAX_RUN_TIME: 2分
- MAX_BATCHES: 10
- BATCH_SIZE: 100
- LAST_PROCESSED_PACKAGES_DEPENDENCY_REDIS_KEY: 'last_processed_packages_dependency_id'
- REDIS_EXPIRATION_TIME: 2時間
- 10分間隔で実行されるが、2分以上実行しない設計
