# バッチ設計書 89-DependencyProxy::CleanupDependencyProxyWorker

## 概要

本ドキュメントは、依存プロキシのクリーンアップを行うバッチ処理「DependencyProxy::CleanupDependencyProxyWorker」の設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、依存プロキシ（Dependency Proxy）内の削除対象のBlobとManifestを検出し、クリーンアップワーカーをエンキューするCronジョブである。

**業務上の目的・背景**：GitLabの依存プロキシ機能は、Dockerイメージのプルを高速化するためにイメージレイヤー（Blob）とマニフェストをキャッシュする。これらのキャッシュデータには有効期限があり、期限切れになったデータは削除対象（pending_destruction）としてマークされる。このバッチは、削除対象データの存在を確認し、実際の削除処理を行うワーカーをエンキューすることで、ストレージの効率的な利用を維持する。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。

**主要な処理内容**：
1. pending_destruction状態のBlobが存在するか確認
2. 存在する場合、CleanupBlobWorkerをエンキュー
3. pending_destruction状態のManifestが存在するか確認
4. 存在する場合、CleanupManifestWorkerをエンキュー

**前後の処理との関連**：ImageTtlGroupPolicyWorker（No.90）がBlobとManifestをpending_destruction状態にマークし、本バッチがクリーンアップワーカーをエンキューする。実際の削除はCleanupBlobWorkerとCleanupManifestWorkerで行われる。

**影響範囲**：dependency_proxy_blobs、dependency_proxy_manifestsテーブル。

## バッチ種別

データクレンジング（オーケストレーション）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cron） |
| 実行時刻 | 設定により異なる |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| feature_category | virtual_registry機能が有効であること |

### 実行可否判定

削除対象のBlobまたはManifestが存在する場合のみ、対応するワーカーをエンキューする。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| DependencyProxy::Blob.pending_destruction | DB | 削除待ちBlob |
| DependencyProxy::Manifest.pending_destruction | DB | 削除待ちManifest |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Sidekiqジョブキュー | Job | CleanupBlobWorker, CleanupManifestWorkerジョブ |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. ワーカー起動
   └─ Sidekiqによりジョブがキューから取得される
2. Blobクリーンアップ確認
   ├─ pending_destruction Blob存在チェック
   └─ 存在する場合、CleanupBlobWorkerをエンキュー
3. Manifestクリーンアップ確認
   ├─ pending_destruction Manifest存在チェック
   └─ 存在する場合、CleanupManifestWorkerをエンキュー
4. 処理完了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{Blob pending?}
    B -->|Yes| C[CleanupBlobWorker エンキュー]
    B -->|No| D{Manifest pending?}
    C --> D
    D -->|Yes| E[CleanupManifestWorker エンキュー]
    D -->|No| F[バッチ終了]
    E --> F
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 存在チェック | dependency_proxy_blobs | SELECT/ANY? | pending_destructionの存在確認 |
| 存在チェック | dependency_proxy_manifests | SELECT/ANY? | pending_destructionの存在確認 |

### テーブル別操作詳細

#### dependency_proxy_blobs

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | status | pending_destruction | any?で存在チェック |

#### dependency_proxy_manifests

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | status | pending_destruction | any?で存在チェック |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DBエラー | データベース接続失敗 | 自動リトライ |
| - | ワーカーエンキュー失敗 | Sidekiq接続失敗 | 自動リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | Sidekiqデフォルト（指数バックオフ） |
| リトライ対象エラー | 一般的な例外 |

### 障害時対応

idempotent!が設定されているため、再実行しても安全。実際の削除処理は子ワーカーで行われるため、本ワーカーの失敗は影響が限定的。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（チェックとエンキューのみ） |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 2回のany?チェック |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | 最小限 |

## 排他制御

特別な排他制御なし。子ワーカーはperform_with_capacityで実行され、キャパシティ制御される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | ワーカー起動情報 |
| 終了ログ | バッチ終了時 | ワーカー完了情報 |
| エラーログ | エラー発生時 | エラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| pending_destruction件数 | 増加傾向 | 運用チーム |
| 連続失敗回数 | 3回以上 | 運用チーム |

## 備考

- feature_category: :virtual_registry
- data_consistency: :sticky
- idempotent: true
- prepend_mod でEE拡張を許可
- 子ワーカー: CleanupBlobWorker, CleanupManifestWorker
- perform_with_capacityで子ワーカーをキャパシティ制御付きでエンキュー
