# バッチ設計書 91-Ci::Catalog::Resources::AggregateLast30DayUsageWorker

## 概要

本ドキュメントは、CI Catalogリソースの過去30日間の利用統計を集計するバッチ処理「Ci::Catalog::Resources::AggregateLast30DayUsageWorker」の設計仕様を記載します。

### 本バッチの処理概要

**業務上の目的・背景**：CI Catalogは、GitLabにおけるCI/CDコンポーネントの再利用を促進するための機能です。各コンポーネントおよびリソースの利用状況を可視化し、人気のあるコンポーネントを特定するために、過去30日間の利用回数を定期的に集計する必要があります。この統計情報により、ユーザーは信頼性の高いコンポーネントを選択でき、コンポーネント開発者は利用状況を把握できます。

**バッチの実行タイミング**：日次実行（毎日0時0分）。重複排除により同一ジョブの並行実行を防止し、最大実行時間は4分間に設定されています。ただし、重複排除TTLは5分間（MAX_RUNTIME + 1分）に設定されています。

**主要な処理内容**：
1. `AggregateLast30DayUsageService`を呼び出して集計処理を開始
2. 全コンポーネント（`Ci::Catalog::Resources::Component`）をバッチ処理（1000件ずつ）で取得
3. 各コンポーネントについて、過去30日間にユニークなプロジェクトから利用された回数をカウント
4. `last_30_day_usage_count`と`last_30_day_usage_count_updated_at`を一括更新
5. 全リソース（`Ci::Catalog::Resource`）について、配下コンポーネントの利用数合計を集計して更新

**前後の処理との関連**：このバッチは`CleanupLastUsagesWorker`と連携しており、30日より古い利用履歴を削除するバッチが同時刻に実行されます。集計対象となる`catalog_resource_component_last_usages`テーブルは、`TrackComponentUsageWorker`によって利用時にレコードが追加されます。

**影響範囲**：`catalog_resource_components`テーブルおよび`catalog_resources`テーブルの利用統計カラムが更新されます。CI Catalogの検索・表示機能に影響を与え、人気順ソートなどの機能に利用されます。

## バッチ種別

集計処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 00:00 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| CI Catalog機能が有効 | `pipeline_composition` feature categoryが有効であること |
| データ整合性 | `catalog_resource_component_last_usages`テーブルにデータが存在すること |

### 実行可否判定

- `deduplicate :until_executed`により、同一ジョブが実行中の場合は再スケジュール（`if_deduplicated: :reschedule_once`）
- TTL: 5分間（WORKER_DEDUP_TTL）
- `idempotent!`により冪等性が保証される

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| catalog_resource_components | DB | CI Catalogコンポーネントマスタ |
| catalog_resource_component_last_usages | DB | コンポーネント利用履歴（過去30日分を対象） |
| catalog_resources | DB | CI Catalogリソースマスタ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| catalog_resource_components | DB | `last_30_day_usage_count`と`last_30_day_usage_count_updated_at`を更新 |
| catalog_resources | DB | `last_30_day_usage_count`と`last_30_day_usage_count_updated_at`を更新 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. ワーカー実行開始
   └─ Ci::Catalog::Resources::AggregateLast30DayUsageService.new.executeを呼び出し
2. コンポーネント利用数の集計（update_component_usage_counts）
   └─ Componentを1000件ずつバッチ処理
   └─ 各コンポーネントについて過去30日間のユニークプロジェクト数をカウント
   └─ CASE文を使ったバルクUPDATEで一括更新
3. リソース利用数の集計（update_resource_usage_counts）
   └─ 各リソースについて配下コンポーネントの利用数合計を計算
   └─ CASE文を使ったバルクUPDATEで一括更新
4. 処理結果をログに記録
   └─ status, message, payloadをメタデータとして出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[AggregateLast30DayUsageService実行]
    B --> C[コンポーネントをバッチ取得]
    C --> D{コンポーネント存在?}
    D -->|あり| E[過去30日の利用数集計]
    E --> F[バルクUPDATE実行]
    F --> G{次のバッチあり?}
    G -->|あり| C
    G -->|なし| H[リソース利用数集計]
    D -->|なし| H
    H --> I{リソース存在?}
    I -->|あり| J[リソースバルクUPDATE]
    I -->|なし| K[処理完了]
    J --> K
    K --> L[ログ出力]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| コンポーネント取得 | catalog_resource_components | SELECT | バッチ単位で全件取得 |
| 利用履歴集計 | catalog_resource_component_last_usages | SELECT | 過去30日の利用数をGROUP BY集計 |
| コンポーネント更新 | catalog_resource_components | UPDATE | 利用数カラムを一括更新 |
| リソース集計 | catalog_resource_components | SELECT | リソース単位でSUM集計 |
| リソース更新 | catalog_resources | UPDATE | 利用数カラムを一括更新 |

### テーブル別操作詳細

#### catalog_resource_components

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, catalog_resource_id | 全件をバッチ取得（1000件ずつ） | find_in_batches使用 |
| UPDATE | last_30_day_usage_count | ユニークプロジェクト数 | CASE文でバルク更新 |
| UPDATE | last_30_day_usage_count_updated_at | NOW() | 更新時刻 |

#### catalog_resource_component_last_usages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | component_id, used_by_project_id | last_used_date >= 30日前 | within_last_30_daysスコープ |

#### catalog_resources

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | last_30_day_usage_count | 配下コンポーネントの利用数合計 | CASE文でバルク更新 |
| UPDATE | last_30_day_usage_count_updated_at | NOW() | 更新時刻 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | データベース接続エラー | DB接続失敗時 | Sidekiqによる自動リトライ |
| - | タイムアウト | 処理時間超過 | 次回実行で継続処理 |
| - | デッドロック | 同時更新競合 | 自動リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

- `idempotent!`により再実行しても整合性が保たれる
- 障害発生時は次回定期実行で自動復旧
- 手動実行する場合は`Ci::Catalog::Resources::AggregateLast30DayUsageWorker.new.perform`を実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位 |
| コミットタイミング | 各バルクUPDATE完了時 |
| ロールバック条件 | SQLエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | コンポーネント数に依存（数千〜数万件） |
| 目標処理時間 | 4分以内（MAX_RUNTIME） |
| メモリ使用量上限 | バッチサイズ1000件で制御 |

## 排他制御

- `deduplicate :until_executed`により同一ジョブの並行実行を防止
- `if_deduplicated: :reschedule_once`により重複時は1回のみ再スケジュール
- TTL: 5分間（WORKER_DEDUP_TTL = MAX_RUNTIME + 1分）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 終了ログ | バッチ終了時 | status, message, payloadをメタデータとして出力 |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 4分超過 | 運用チーム |
| エラー件数 | 連続失敗 | 運用チーム |
| 集計件数 | 0件（異常検知） | 運用チーム |

## 備考

- このワーカーは`pipeline_composition` feature categoryに属する
- `data_consistency :sticky`によりプライマリDBを使用
- `urgency :low`により低優先度キューで実行
- 関連ワーカー: `CleanupLastUsagesWorker`（30日より古い履歴を削除）
