# バッチ設計書 92-Ci::Catalog::Resources::CleanupLastUsagesWorker

## 概要

本ドキュメントは、CI Catalogコンポーネントの利用履歴から30日より古いレコードを削除するバッチ処理「Ci::Catalog::Resources::CleanupLastUsagesWorker」の設計仕様を記載します。

### 本バッチの処理概要

**業務上の目的・背景**：CI Catalogでは、各コンポーネントの利用状況を追跡するために`catalog_resource_component_last_usages`テーブルにレコードを記録しています。しかし、利用統計として必要なのは過去30日間のデータのみであり、それ以前の古いレコードはデータベースの肥大化を防ぐために定期的に削除する必要があります。このバッチは、不要になった古い利用履歴データをクリーンアップし、データベースのパフォーマンスとストレージ効率を維持します。

**バッチの実行タイミング**：日次実行（毎日0時0分）。`AggregateLast30DayUsageWorker`と同時刻に実行され、集計が完了した後の古いデータを削除します。

**主要な処理内容**：
1. `catalog_resource_component_last_usages`テーブルから30日より古いレコードを検索
2. 1000件ずつバッチ処理で対象レコードを取得
3. `delete_all`メソッドで一括削除を実行
4. 全ての古いレコードが削除されるまでループ処理を継続

**前後の処理との関連**：`AggregateLast30DayUsageWorker`と連携して動作します。集計処理では過去30日のデータのみを使用するため、このクリーンアップバッチはそれより古いデータを安全に削除できます。両バッチは同時刻に実行されますが、集計処理が`within_last_30_days`スコープを使用するため、削除対象と重複することはありません。

**影響範囲**：`catalog_resource_component_last_usages`テーブルのみに影響します。過去30日間の利用統計には影響を与えず、データベースのストレージ使用量を削減します。

## バッチ種別

データクレンジング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 00:00 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| CI Catalog機能が有効 | `pipeline_composition` feature categoryが有効であること |

### 実行可否判定

- `idempotent!`により冪等性が保証される
- 削除対象が存在しない場合も正常終了する

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| catalog_resource_component_last_usages | DB | コンポーネント利用履歴テーブル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| catalog_resource_component_last_usages | DB | 30日より古いレコードを削除 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. ワーカー実行開始
   └─ perform メソッドが呼び出される
2. 古い利用履歴の検索
   └─ older_than_30_days スコープで30日より前のレコードを抽出
3. バッチ削除ループ
   └─ each_batch(of: 1000) で1000件ずつ取得
   └─ batch.delete_all で一括削除
4. ループ完了
   └─ 全ての古いレコードが削除されるまで継続
5. 処理終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[older_than_30_days スコープ適用]
    B --> C[1000件バッチ取得]
    C --> D{レコード存在?}
    D -->|あり| E[delete_all 実行]
    E --> F{次のバッチあり?}
    F -->|あり| C
    F -->|なし| G[バッチ終了]
    D -->|なし| G
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 古い履歴検索 | catalog_resource_component_last_usages | SELECT | 30日より古いレコードをバッチ取得 |
| 履歴削除 | catalog_resource_component_last_usages | DELETE | 対象レコードを一括削除 |

### テーブル別操作詳細

#### catalog_resource_component_last_usages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, last_used_date | last_used_date < 30日前 | older_than_30_daysスコープ |
| DELETE | (全カラム) | バッチで選択されたレコード | delete_allで一括削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | データベース接続エラー | DB接続失敗時 | Sidekiqによる自動リトライ |
| - | テーブルロックエラー | 同時アクセス競合 | 自動リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

- `idempotent!`により再実行しても整合性が保たれる
- 障害発生時は次回定期実行で自動復旧
- 手動実行する場合は`Ci::Catalog::Resources::CleanupLastUsagesWorker.new.perform`を実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位（1000件） |
| コミットタイミング | 各delete_all完了時 |
| ロールバック条件 | SQLエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 日次で蓄積される利用履歴数に依存 |
| 目標処理時間 | 特に制限なし（低優先度） |
| メモリ使用量上限 | バッチサイズ1000件で制御 |

## 排他制御

- `idempotent!`により同一処理の複数実行でも整合性を保持
- バッチ単位での削除により、他の処理との競合を最小化

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 長時間実行（要調整） | 運用チーム |
| エラー件数 | 連続失敗 | 運用チーム |

## 備考

- このワーカーは`pipeline_composition` feature categoryに属する
- `data_consistency :sticky`によりプライマリDBを使用
- `urgency :low`により低優先度キューで実行
- 関連ワーカー: `AggregateLast30DayUsageWorker`（利用統計集計）
- `EachBatch`モジュールを使用した効率的なバッチ処理を実装
