# バッチ設計書 93-Ci::Catalog::Resources::ProcessSyncEventsWorker

## 概要

本ドキュメントは、CI Catalogリソースの同期イベントを処理するバッチ「Ci::Catalog::Resources::ProcessSyncEventsWorker」の設計仕様を記載します。

### 本バッチの処理概要

**業務上の目的・背景**：CI Catalogリソースは、Projectモデルと関連付けられており、プロジェクトの名前、説明、可視性などの属性変更をCatalogリソースに同期する必要があります。この同期処理をイベント駆動で実現するため、`SyncEvent`テーブルにイベントを記録し、このワーカーがイベントを消費してCatalogリソースを更新します。これにより、プロジェクト属性の変更がCI Catalogに即座に反映されます。

**バッチの実行タイミング**：3つの方法で実行されます。(1) Projectモデルのコールバックによりプロジェクト属性更新時、(2) 毎分のcronジョブで定期実行、(3) 処理後に残りイベントがある場合の再スケジュール。cronでは`*/1 * * * *`（毎分）で実行されます。

**主要な処理内容**：
1. 排他ロック（ExclusiveLease）を取得して重複処理を防止
2. `Ci::Catalog::Resources::SyncEvent`から未処理イベントを1000件取得
3. 各イベントについて`Ci::Catalog::Resource.sync!`を呼び出してリソースを同期
4. 処理済みイベントをマーク
5. 残りイベントがあれば再度ワーカーをエンキュー

**前後の処理との関連**：Projectモデルの属性変更時に自動的にSyncEventが生成されます。このワーカーはそのイベントを消費し、Catalogリソースの属性を更新します。直接SQLによるバルク更新の場合もcronジョブでイベントが処理されます。

**影響範囲**：`catalog_resources`テーブルのプロジェクト関連属性（名前、説明、可視性など）が更新されます。CI Catalogの検索・表示機能に即座に反映されます。

## バッチ種別

データ連携

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 毎分 + イベント駆動 |
| 実行時刻 | */1（毎分） |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron / イベント |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| CI Catalog機能が有効 | `pipeline_composition` feature categoryが有効であること |
| 未処理イベントの存在 | `SyncEvent`テーブルに未処理レコードが存在すること |

### 実行可否判定

- `ExclusiveLeaseGuard`により排他ロックを取得
- ロックが取得できない場合は処理をスキップ
- `deduplicate :until_executed`により重複実行を防止
- `if_deduplicated: :reschedule_once`により重複時は1回のみ再スケジュール
- TTL: 1分

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ci_catalog_resources_sync_events | DB | 同期イベントテーブル |
| projects | DB | プロジェクトテーブル（同期元データ） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| catalog_resources | DB | プロジェクト関連属性を同期更新 |
| ci_catalog_resources_sync_events | DB | 処理済みフラグを更新 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. ワーカー実行開始
   └─ ProcessSyncEventsService.new(SyncEvent, Ci::Catalog::Resource).execute を呼び出し
2. 排他ロック取得
   └─ try_obtain_lease でロックを取得（1分間）
3. 未処理イベント取得
   └─ unprocessed_events.preload_synced_relation.first(1000)
4. イベント処理ループ
   └─ 各イベントについて Ci::Catalog::Resource.sync!(event) を実行
   └─ 処理済みイベントをリストに追加
5. 処理済みマーク
   └─ mark_records_processed で処理済みフラグを更新
6. 残りイベント確認
   └─ 未処理イベントがあればワーカーを再エンキュー
7. ログ出力
   └─ estimated_total_events, consumable_events, processed_events をメタデータとして出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{排他ロック取得}
    B -->|成功| C[未処理イベント取得]
    B -->|失敗| K[処理スキップ]
    C --> D{イベント存在?}
    D -->|あり| E[イベントループ開始]
    E --> F[Ci::Catalog::Resource.sync!実行]
    F --> G[処理済みリストに追加]
    G --> H{次のイベントあり?}
    H -->|あり| F
    H -->|なし| I[処理済みマーク更新]
    D -->|なし| J[ログ出力]
    I --> L{残りイベントあり?}
    L -->|あり| M[ワーカー再エンキュー]
    L -->|なし| J
    M --> J
    K --> N[バッチ終了]
    J --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| イベント取得 | ci_catalog_resources_sync_events | SELECT | 未処理イベントを1000件取得 |
| イベントカウント | ci_catalog_resources_sync_events | SELECT | 上限カウント取得 |
| リソース同期 | catalog_resources | UPDATE | プロジェクト属性を同期 |
| 処理済みマーク | ci_catalog_resources_sync_events | UPDATE | 処理済みフラグを更新 |

### テーブル別操作詳細

#### ci_catalog_resources_sync_events

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, project_id等 | processed = false | 未処理イベント取得 |
| UPDATE | processed | true | 処理完了後に更新 |

#### catalog_resources

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | 名前、説明、可視性等 | プロジェクトから同期 | sync!メソッドで更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 排他ロック取得失敗 | 別プロセスが処理中 | 処理スキップ、次回実行で処理 |
| - | データベース接続エラー | DB接続失敗時 | Sidekiqによる自動リトライ |
| - | 同期エラー | イベント処理中のエラー | ensureで処理済みイベントをマーク |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

- `ensure`ブロックで処理済みイベントのマークを保証
- エラー発生時も次回実行で未処理イベントを再処理
- 手動実行する場合は`Ci::Catalog::Resources::ProcessSyncEventsWorker.new.perform`を実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | イベント単位 |
| コミットタイミング | 各イベント処理後 |
| ロールバック条件 | 同期処理中のエラー |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大1000件/回（BATCH_SIZE） |
| 目標処理時間 | 1分以内（lease_timeout） |
| メモリ使用量上限 | バッチサイズ1000件で制御 |

## 排他制御

- `ExclusiveLeaseGuard`モジュールによる排他ロック
- `lease_timeout`: 1分
- `lease_key`: `Ci::ProcessSyncEventsService::Ci::Catalog::Resources::SyncEvent`
- `deduplicate :until_executed`による重複実行防止
- `if_deduplicated: :reschedule_once`により重複時は1回のみ再スケジュール

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| メタデータログ | 処理完了時 | estimated_total_events, consumable_events, processed_events |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 1分超過 | 運用チーム |
| 未処理イベント数 | 大量蓄積 | 運用チーム |
| エラー件数 | 連続失敗 | 運用チーム |

## 備考

- このワーカーは`pipeline_composition` feature categoryに属する
- `data_consistency :sticky`によりプライマリDBを使用
- `urgency :high`により高優先度キューで実行（リアルタイム性重視）
- 3つのトリガー方式: (1) Projectコールバック, (2) cron, (3) 残イベント時の再スケジュール
- `preload_synced_relation`でN+1問題を防止
