# バッチ設計書 94-Ci::Runners::ReconcileExistingRunnerVersionsCronWorker

## 概要

本ドキュメントは、CI Runnerのバージョン情報を整合性チェックし、アップグレード推奨状態を更新するバッチ「Ci::Runners::ReconcileExistingRunnerVersionsCronWorker」の設計仕様を記載します。

### 本バッチの処理概要

**業務上の目的・背景**：GitLab CI/CDでは、複数のRunnerが異なるバージョンで動作している可能性があります。Runnerのバージョンを管理し、アップグレードが必要なRunnerを特定することは、セキュリティと機能の観点から重要です。このバッチは、現在登録されているRunnerのバージョン一覧を収集し、GitLab Releases APIと照合してアップグレード推奨状態を更新します。これにより、管理者はどのRunnerがアップグレードを必要としているかを把握できます。

**バッチの実行タイミング**：日次実行（@daily）ですが、GitLab Releases APIへのアクセス集中を避けるため、0〜12時間のランダムな遅延を入れて再スケジュールします。

**主要な処理内容**：
1. cronによりワーカーが起動（`cronjob_scheduled = true`）
2. 0〜12時間のランダムな遅延で自身を再スケジュール
3. 再スケジュール後（`cronjob_scheduled = false`）に本処理を開始
4. 全RunnerManagerから一意のバージョン一覧を収集
5. 新しいバージョンを`ci_runner_versions`テーブルに挿入
6. 使用されなくなったバージョンを削除
7. GitLab Releases APIと照合してアップグレード状態を更新

**前後の処理との関連**：このバッチは独立して動作し、RunnerManagerテーブルのバージョン情報を読み取り、`ci_runner_versions`テーブルを更新します。Runnerの管理画面でアップグレード推奨の表示に使用されます。

**影響範囲**：`ci_runner_versions`テーブルが更新されます。Runnerの管理画面でアップグレード推奨の警告表示に影響します。

## バッチ種別

データ連携 / 集計処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | @daily + ランダム遅延（0〜12時間） |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Runner機能が有効 | `fleet_visibility` feature categoryが有効であること |
| RunnerManagerの存在 | `ci_runner_machines`テーブルにデータが存在すること |

### 実行可否判定

- `idempotent!`により冪等性が保証される
- `deduplicate :until_executed`により重複実行を防止
- ランダム遅延により各インスタンスの実行タイミングを分散

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| cronjob_scheduled | Boolean | No | true | cronからの直接実行かどうか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ci_runner_machines | DB | RunnerManagerのバージョン情報 |
| ci_runner_versions | DB | Runnerバージョンマスタ |
| GitLab Releases API | API | 最新バージョン情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ci_runner_versions | DB | バージョン情報の追加・更新・削除 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. cronによりワーカー起動（cronjob_scheduled = true）
   └─ 0〜12時間のランダム遅延を計算
   └─ 遅延時間後に自身を再スケジュール（cronjob_scheduled = false）
   └─ 処理終了
2. 再スケジュール後のワーカー起動（cronjob_scheduled = false）
   └─ ReconcileExistingRunnerVersionsService.new.execute を呼び出し
3. バージョン情報の収集（insert_runner_versions）
   └─ RunnerManagerからdistinct_each_batchでバージョンを取得
   └─ 新しいバージョンをinsert_allで追加
4. 使用されないバージョンの削除（cleanup_runner_versions）
   └─ 収集したバージョン一覧に存在しないレコードを削除
5. アップグレード状態の更新（update_status_on_outdated_runner_versions）
   └─ potentially_outdatedなバージョンをバッチ取得
   └─ GitLab Releases APIと照合してステータス判定
   └─ upsert_allでステータスを更新
6. ログ出力
   └─ total_inserted, total_updated, total_deleted をメタデータとして出力
```

### フローチャート

```mermaid
flowchart TD
    A[cron起動] --> B{cronjob_scheduled?}
    B -->|true| C[ランダム遅延計算]
    C --> D[遅延後に再スケジュール]
    D --> E[処理終了]
    B -->|false| F[ReconcileExistingRunnerVersionsService実行]
    F --> G[RunnerManagerからバージョン収集]
    G --> H[新バージョンをINSERT]
    H --> I[不要バージョンをDELETE]
    I --> J[potentially_outdatedバージョン取得]
    J --> K[GitLab Releases APIと照合]
    K --> L[ステータスUPSERT]
    L --> M[ログ出力]
    M --> N[処理完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| バージョン収集 | ci_runner_machines | SELECT | distinct_each_batchでバージョン取得 |
| 既存バージョン確認 | ci_runner_versions | SELECT | 重複チェック |
| バージョン追加 | ci_runner_versions | INSERT | 新バージョンを追加 |
| バージョン削除 | ci_runner_versions | DELETE | 使用されないバージョンを削除 |
| ステータス更新 | ci_runner_versions | UPSERT | アップグレード推奨状態を更新 |

### テーブル別操作詳細

#### ci_runner_machines

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | version | DISTINCT取得 | バッチサイズ100件 |

#### ci_runner_versions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | version | 重複チェック用 | プライマリDB回避 |
| INSERT | version | 新バージョン | insert_all、unique_by: :version |
| DELETE | version | 使用されないバージョン | versions_from_runnersに含まれないもの |
| UPSERT | version, status | アップグレード推奨状態 | upsert_all、unique_by: :version |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | API接続エラー | GitLab Releases API失敗 | ステータス更新をスキップ |
| - | データベース接続エラー | DB接続失敗時 | Sidekiqによる自動リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

- `idempotent!`により再実行しても整合性が保たれる
- API障害時はステータス更新をスキップし、次回実行で再試行
- 手動実行する場合は`Ci::Runners::ReconcileExistingRunnerVersionsCronWorker.new.perform(false)`を実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位 |
| コミットタイミング | 各insert_all/upsert_all完了時 |
| ロールバック条件 | SQLエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | バージョン数に依存（数十〜数百バージョン） |
| 目標処理時間 | 特に制限なし（低優先度） |
| メモリ使用量上限 | バッチサイズ100件で制御 |

## 排他制御

- `deduplicate :until_executed`により同一ジョブの並行実行を防止
- ランダム遅延により複数インスタンス間の実行タイミングを分散

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 再スケジュールログ | 遅延計算時 | "rescheduled job for {time}" |
| 終了ログ | 処理完了時 | total_inserted, total_updated, total_deleted |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 長時間実行（要調整） | 運用チーム |
| エラー件数 | 連続失敗 | 運用チーム |

## 備考

- このワーカーは`fleet_visibility` feature categoryに属する
- `data_consistency :sticky`によりプライマリDBを使用
- `urgency :low`により低優先度キューで実行
- ランダム遅延（0〜12時間）により、GitLab Releases APIへの負荷を分散
- `VERSION_BATCH_SIZE`: 100件
- `Gitlab::Ci::RunnerUpgradeCheck`クラスでアップグレード推奨を判定
