# バッチ設計書 95-Ci::Runners::StaleMachinesCleanupCronWorker

## 概要

本ドキュメントは、古くなったCI Runner Manager（マシン）を削除するバッチ処理「Ci::Runners::StaleMachinesCleanupCronWorker」の設計仕様を記載します。

### 本バッチの処理概要

**業務上の目的・背景**：GitLab CI/CDでは、RunnerManagerは各ランナーマシンの接続状態を追跡します。ランナーマシンが長期間接続しなくなった場合（stale状態）、そのレコードはデータベースに残り続け、ストレージの無駄やクエリパフォーマンスの低下を引き起こす可能性があります。このバッチは、接続が途絶えた古いRunnerManagerレコードを定期的に削除し、データベースの整合性とパフォーマンスを維持します。

**バッチの実行タイミング**：毎時36分に実行されます（cron: `36 * * * *`）。1時間に1回の頻度で古いマシンをクリーンアップします。

**主要な処理内容**：
1. `StaleManagersCleanupService`を呼び出して削除処理を開始
2. `stale`スコープで古くなったRunnerManagerを特定
3. サブバッチ単位（100件）で削除を実行
4. 最大1000件の削除制限を設けてパフォーマンスを管理
5. 削除件数をログに記録

**前後の処理との関連**：このバッチは独立して動作します。Runnerの登録・接続処理とは非同期で実行され、接続が復活したマシンは`stale`スコープから除外されるため誤削除を防止します。

**影響範囲**：`ci_runner_machines`テーブルの古いレコードが削除されます。Runner管理画面のマシン一覧から該当エントリが消去されます。

## バッチ種別

データクレンジング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 毎時 |
| 実行時刻 | 毎時36分 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Runner機能が有効 | `fleet_visibility` feature categoryが有効であること |

### 実行可否判定

- `idempotent!`により冪等性が保証される
- 削除対象が存在しない場合も正常終了する

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ci_runner_machines | DB | RunnerManagerテーブル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ci_runner_machines | DB | stale状態のレコードを削除 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. ワーカー実行開始
   └─ StaleManagersCleanupService.new.execute を呼び出し
2. 削除ループ開始（delete_stale_runner_managers）
   └─ staleスコープで古いマシンを抽出
   └─ サブバッチサイズ（SUB_BATCH_LIMIT = 100件）で制限
   └─ id_inとdelete_allで一括削除
3. ループ継続判定
   └─ 削除件数が0の場合、または総削除数がMAX_DELETIONS（1000件）に達したらループ終了
4. 結果集計
   └─ total_deleted, batch_countsを集計
5. ログ出力
   └─ status, total_deleted, batch_countsをメタデータとして出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[StaleManagersCleanupService実行]
    B --> C[staleマシン取得]
    C --> D{レコード存在?}
    D -->|あり| E[100件を削除]
    E --> F[削除件数を記録]
    F --> G{総削除数 >= 1000?}
    G -->|No| H{削除件数 > 0?}
    H -->|Yes| C
    H -->|No| I[結果集計]
    G -->|Yes| I
    D -->|なし| I
    I --> J[ログ出力]
    J --> K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| staleマシン取得 | ci_runner_machines | SELECT | staleスコープで対象を特定 |
| マシン削除 | ci_runner_machines | DELETE | delete_allで一括削除 |

### テーブル別操作詳細

#### ci_runner_machines

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | staleスコープ条件に合致 | LIMIT 100 |
| DELETE | (全カラム) | id_inで選択されたレコード | delete_allで一括削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | データベース接続エラー | DB接続失敗時 | Sidekiqによる自動リトライ |
| - | ロックタイムアウト | テーブルロック競合 | 自動リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

- `idempotent!`により再実行しても整合性が保たれる
- 障害発生時は次回定期実行で自動復旧
- 手動実行する場合は`Ci::Runners::StaleMachinesCleanupCronWorker.new.perform`を実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | サブバッチ単位（100件） |
| コミットタイミング | 各delete_all完了時 |
| ロールバック条件 | SQLエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大1000件/回（MAX_DELETIONS） |
| 目標処理時間 | 特に制限なし（低優先度） |
| メモリ使用量上限 | サブバッチサイズ100件で制御 |

## 排他制御

- `idempotent!`により同一処理の複数実行でも整合性を保持
- サブバッチ単位での削除により、他の処理との競合を最小化
- `stale`スコープにより、アクティブなマシンは削除対象外

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| ステータスログ | 処理完了時 | status |
| メタデータログ | 処理完了時 | total_deleted, batch_counts |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 長時間実行（要調整） | 運用チーム |
| エラー件数 | 連続失敗 | 運用チーム |
| 削除件数 | 毎回MAX_DELETIONS到達 | 運用チーム（蓄積警告） |

## 備考

- このワーカーは`fleet_visibility` feature categoryに属する
- `data_consistency :sticky`によりプライマリDBを使用
- `urgency :low`により低優先度キューで実行
- `MAX_DELETIONS`: 1000件（1回の実行で削除する最大件数）
- `SUB_BATCH_LIMIT`: 100件（サブバッチサイズ）
- `stale`スコープの定義はCi::RunnerManagerモデルで定義（接続が長期間途絶えたマシン）
- `id_in`メソッドでサブクエリを使用し、`delete_all`の制限を回避
