# バッチ設計書 97-Ci::ScheduleUnlockPipelinesInQueueCronWorker

## 概要

本ドキュメントは、キューに入っているパイプラインのロック解除をスケジュールするバッチ処理「Ci::ScheduleUnlockPipelinesInQueueCronWorker」の設計仕様を記載します。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabでは、ジョブアーティファクトの保持管理のために、パイプラインにロック状態を設定することがあります。ロックされたパイプラインのアーティファクトは期限切れでも自動削除されません。しかし、一部のパイプラインはロック解除キューに入れられており、これらのロックを解除してアーティファクトの正常な削除サイクルに戻す必要があります。このバッチは、キューに入っているパイプラインのロック解除処理を定期的にスケジュールします。

**バッチの実行タイミング**：毎分実行されます（cron: `*/1 * * * *`）。頻繁な実行により、ロック解除待ちのパイプラインを迅速に処理します。

**主要な処理内容**：
1. `UnlockPipelinesInQueueWorker.perform_with_capacity`を呼び出す
2. 引数をそのまま転送（スプラット演算子を使用）
3. 実際のロック解除処理は`UnlockPipelinesInQueueWorker`が担当

**前後の処理との関連**：このワーカーはスケジューラとして動作し、実際のロック解除処理は`Ci::UnlockPipelinesInQueueWorker`が担当します。ロック解除されたパイプラインは、通常のアーティファクト削除サイクルに戻ります。

**影響範囲**：`ci_pipelines`テーブルのロック状態が更新されます。ロック解除後、パイプラインのアーティファクトは通常の有効期限ポリシーに従って削除対象となります。

## バッチ種別

データ連携

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 毎分 |
| 実行時刻 | */1 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ジョブアーティファクト機能が有効 | `job_artifacts` feature categoryが有効であること |

### 実行可否判定

- `idempotent!`により冪等性が保証される
- ロック解除対象がない場合も正常終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| (可変引数) | Any | No | - | UnlockPipelinesInQueueWorkerに転送される引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ci_pipelines | DB | ロック解除待ちのパイプライン |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ci_pipelines | DB | ロック状態を更新 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. ワーカー実行開始（ScheduleUnlockPipelinesInQueueCronWorker）
   └─ perform メソッドが引数と共に呼び出される
2. ロック解除ワーカー起動
   └─ UnlockPipelinesInQueueWorker.perform_with_capacity(...) を呼び出し
   └─ 引数をスプラット演算子でそのまま転送
3. 実際のロック解除処理
   └─ UnlockPipelinesInQueueWorker がキューからパイプラインを取得
   └─ パイプラインのロック状態を解除
4. 処理完了
```

### フローチャート

```mermaid
flowchart TD
    A[CronWorker開始] --> B[引数を受け取る]
    B --> C[UnlockPipelinesInQueueWorker.perform_with_capacity呼び出し]
    C --> D[ロック解除対象パイプライン取得]
    D --> E{パイプライン存在?}
    E -->|あり| F[ロック状態を解除]
    F --> G{次のパイプラインあり?}
    G -->|あり| D
    G -->|なし| H[処理完了]
    E -->|なし| H
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パイプライン取得 | ci_pipelines | SELECT | ロック解除待ちのパイプラインを取得 |
| ロック状態更新 | ci_pipelines | UPDATE | locked カラムを更新 |

### テーブル別操作詳細

#### ci_pipelines

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, locked | ロック解除キューに存在するもの | キューから取得 |
| UPDATE | locked | unlocked状態に更新 | ロック解除処理 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | データベース接続エラー | DB接続失敗時 | Sidekiqによる自動リトライ |
| - | キューアクセスエラー | Redis障害時 | 自動リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

- `idempotent!`により再実行しても整合性が保たれる
- 障害発生時は次回定期実行で自動復旧
- 手動実行する場合は`Ci::ScheduleUnlockPipelinesInQueueCronWorker.new.perform`を実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | パイプライン単位 |
| コミットタイミング | 各パイプラインのロック解除完了時 |
| ロールバック条件 | 更新処理中のエラー |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | キュー内のパイプライン数に依存 |
| 目標処理時間 | 1分以内（次回実行まで） |
| メモリ使用量上限 | LimitedCapacity::Workerで制御 |

## 排他制御

- `idempotent!`により同一処理の複数実行でも整合性を保持
- `LimitedCapacity::Worker`により並列実行数を制御

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 1分超過 | 運用チーム |
| エラー件数 | 連続失敗 | 運用チーム |
| キュー滞留 | 大量蓄積 | 運用チーム |

## 備考

- このワーカーは`job_artifacts` feature categoryに属する
- `data_consistency :always`により強い整合性を要求
- CronjobQueueをinclude
- 非常にシンプルなスケジューラ実装（引数転送のみ）
- 実際のロック解除ロジックは`Ci::UnlockPipelinesInQueueWorker`で実装
- スプラット演算子(`...`)で引数をそのまま転送
