# バッチ設計書 98-Ci::DeleteUnitTestsWorker

## 概要

本ドキュメントは、削除可能な単体テストデータを削除するバッチ処理「Ci::DeleteUnitTestsWorker」の設計仕様を記載します。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabでは、CI/CDパイプラインで実行された単体テストの結果を`ci_unit_tests`テーブルと`ci_unit_test_failures`テーブルに保存しています。これらのデータは時間とともに蓄積され、データベースのストレージを圧迫する可能性があります。このバッチは、保持期限を過ぎた古いテストデータや、関連するビルドが削除されて不要になったテストデータを定期的に削除し、データベースの効率を維持します。

**バッチの実行タイミング**：日次実行（毎日0時0分、cron: `0 0 * * *`）。1日1回の頻度で古いテストデータをクリーンアップします。

**主要な処理内容**：
1. `DeleteUnitTestsService`を呼び出して削除処理を開始
2. `Ci::UnitTestFailure`の削除可能なレコードを削除
3. `Ci::UnitTest`の削除可能なレコードを削除
4. 各テーブルについて、削除対象がなくなるまでループ処理を継続

**前後の処理との関連**：このバッチは独立して動作します。単体テスト結果はCI/CDパイプライン実行時に記録され、このバッチが定期的にクリーンアップを行います。

**影響範囲**：`ci_unit_tests`テーブルと`ci_unit_test_failures`テーブルの古いレコードが削除されます。テスト結果の履歴表示に影響を与える可能性があります。

## バッチ種別

データクレンジング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 00:00 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| コードテスト機能が有効 | `code_testing` feature categoryが有効であること |

### 実行可否判定

- `idempotent!`により冪等性が保証される
- 削除対象が存在しない場合も正常終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ci_unit_tests | DB | 単体テストテーブル |
| ci_unit_test_failures | DB | 単体テスト失敗履歴テーブル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ci_unit_tests | DB | 削除可能なレコードを削除 |
| ci_unit_test_failures | DB | 削除可能なレコードを削除 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. ワーカー実行開始
   └─ DeleteUnitTestsService.new.execute を呼び出し
2. UnitTestFailureの削除（purge_data!）
   └─ 削除可能なレコードをバッチ取得（BATCH_SIZE = 100）
   └─ FOR UPDATE SKIP LOCKEDでロック取得
   └─ delete_allで一括削除
   └─ 削除対象がなくなるまでループ
3. UnitTestの削除（purge_data!）
   └─ 削除可能なレコードをバッチ取得（BATCH_SIZE = 100）
   └─ FOR UPDATE SKIP LOCKEDでロック取得
   └─ delete_allで一括削除
   └─ 削除対象がなくなるまでループ
4. 処理完了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[DeleteUnitTestsService実行]
    B --> C[UnitTestFailure削除ループ開始]
    C --> D[deletableレコード取得]
    D --> E{レコード存在?}
    E -->|あり| F[FOR UPDATE SKIP LOCKEDでロック]
    F --> G[delete_all実行]
    G --> D
    E -->|なし| H[UnitTest削除ループ開始]
    H --> I[deletableレコード取得]
    I --> J{レコード存在?}
    J -->|あり| K[FOR UPDATE SKIP LOCKEDでロック]
    K --> L[delete_all実行]
    L --> I
    J -->|なし| M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 削除対象取得 | ci_unit_test_failures | SELECT | deletableスコープで対象を取得 |
| 削除対象取得 | ci_unit_tests | SELECT | deletableスコープで対象を取得 |
| テスト失敗履歴削除 | ci_unit_test_failures | DELETE | delete_allで一括削除 |
| テストデータ削除 | ci_unit_tests | DELETE | delete_allで一括削除 |

### テーブル別操作詳細

#### ci_unit_test_failures

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | deletableスコープ | LIMIT 100, FOR UPDATE SKIP LOCKED |
| DELETE | (全カラム) | 選択されたID | delete_all |

#### ci_unit_tests

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | deletableスコープ | LIMIT 100, FOR UPDATE SKIP LOCKED |
| DELETE | (全カラム) | 選択されたID | delete_all |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | データベース接続エラー | DB接続失敗時 | Sidekiqによる自動リトライ |
| - | ロックタイムアウト | テーブルロック競合 | SKIP LOCKEDにより競合をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

- `idempotent!`により再実行しても整合性が保たれる
- `FOR UPDATE SKIP LOCKED`により競合を回避
- 障害発生時は次回定期実行で自動復旧
- 手動実行する場合は`Ci::DeleteUnitTestsWorker.new.perform`を実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位（100件） |
| コミットタイミング | 各delete_all完了時 |
| ロールバック条件 | トランザクション内でのエラー |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 削除対象データ量に依存 |
| 目標処理時間 | 特に制限なし（低優先度） |
| メモリ使用量上限 | バッチサイズ100件で制御 |

## 排他制御

- `FOR UPDATE SKIP LOCKED`により行レベルロックを取得
- 他のトランザクションがロック中のレコードはスキップ
- 同時実行でもデッドロックを回避

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 長時間実行（要調整） | 運用チーム |
| エラー件数 | 連続失敗 | 運用チーム |

## 備考

- このワーカーは`code_testing` feature categoryに属する
- `data_consistency :sticky`によりプライマリDBを使用
- CronjobQueueをinclude
- `BATCH_SIZE`: 100件（1回の削除バッチサイズ）
- `FOR UPDATE SKIP LOCKED`により並行実行時の競合を回避
- `EachBatch`モジュールをinclude（サービスクラス）
- 削除順序: UnitTestFailure -> UnitTest（外部キー制約を考慮）
- `deletable`スコープはモデルで定義（削除可能なレコードを特定）
