# バッチ設計書 99-Ci::DeleteExpiredTriggerTokenWorker

## 概要

本ドキュメントは、期限切れのパイプライントリガートークンを削除するバッチ処理「Ci::DeleteExpiredTriggerTokenWorker」の設計仕様を記載します。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabでは、パイプラインを外部からトリガーするためのトリガートークン（`ci_triggers`）を発行できます。セキュリティの観点から、これらのトークンには有効期限を設定することが推奨されています。期限切れとなったトークンは、一定の保持期間（30日間）経過後に削除されるべきです。このバッチは、有効期限切れから30日以上経過したトリガートークンを定期的に削除し、セキュリティとデータベースの効率を維持します。

**バッチの実行タイミング**：日次実行（毎日0時0分、cron: `0 0 * * *`）。1日1回の頻度で期限切れトークンをクリーンアップします。

**主要な処理内容**：
1. `ready_for_deletion`スコープで削除対象のトークンを検索
2. 有効期限から30日（`EXPIRED_TOKEN_RETENTION`）以上経過したトークンを対象
3. 100件ずつバッチ処理で削除
4. 全ての対象トークンが削除されるまでループ処理を継続

**前後の処理との関連**：このバッチは独立して動作します。トリガートークンはプロジェクトのCI/CD設定から作成され、有効期限が設定されます。このバッチは期限切れから30日以上経過したトークンのみを削除するため、誤って有効なトークンを削除するリスクを最小化しています。

**影響範囲**：`ci_triggers`テーブルの古いレコードが削除されます。削除されたトークンを使用したパイプラインのトリガーは失敗するようになりますが、有効期限切れから30日経過しているため、通常は影響ありません。

## バッチ種別

データクレンジング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 00:00 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| CI機能が有効 | `continuous_integration` feature categoryが有効であること |

### 実行可否判定

- `idempotent!`により冪等性が保証される
- 削除対象が存在しない場合も正常終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ci_triggers | DB | パイプライントリガートークンテーブル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ci_triggers | DB | 期限切れトークンを削除 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. ワーカー実行開始
   └─ perform メソッドが呼び出される
2. 削除対象の検索
   └─ ready_for_deletion スコープで対象トークンを抽出
   └─ expires_at < 30日前 の条件
3. バッチ削除ループ
   └─ each_batch(of: 100) で100件ずつ取得
   └─ delete_all で一括削除
4. ループ完了
   └─ 全ての対象トークンが削除されるまで継続
5. 処理終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ready_for_deletion スコープ適用]
    B --> C[100件バッチ取得]
    C --> D{レコード存在?}
    D -->|あり| E[delete_all 実行]
    E --> F{次のバッチあり?}
    F -->|あり| C
    F -->|なし| G[バッチ終了]
    D -->|なし| G
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 削除対象検索 | ci_triggers | SELECT | ready_for_deletionスコープで対象を抽出 |
| トークン削除 | ci_triggers | DELETE | delete_allで一括削除 |

### テーブル別操作詳細

#### ci_triggers

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, expires_at | expires_at < 30日前 | ready_for_deletionスコープ |
| DELETE | (全カラム) | バッチで選択されたレコード | delete_allで一括削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | データベース接続エラー | DB接続失敗時 | Sidekiqによる自動リトライ |
| - | テーブルロックエラー | 同時アクセス競合 | 自動リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

- `idempotent!`により再実行しても整合性が保たれる
- 障害発生時は次回定期実行で自動復旧
- 手動実行する場合は`Ci::DeleteExpiredTriggerTokenWorker.new.perform`を実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位（100件） |
| コミットタイミング | 各delete_all完了時 |
| ロールバック条件 | SQLエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 期限切れトークン数に依存 |
| 目標処理時間 | 特に制限なし（低優先度） |
| メモリ使用量上限 | バッチサイズ100件で制御 |

## 排他制御

- `idempotent!`により同一処理の複数実行でも整合性を保持
- バッチ単位での削除により、他の処理との競合を最小化

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 長時間実行（要調整） | 運用チーム |
| エラー件数 | 連続失敗 | 運用チーム |

## 備考

- このワーカーは`continuous_integration` feature categoryに属する
- `data_consistency :sticky`によりプライマリDBを使用
- `queue_namespace :cronjob`によりcronジョブキューを使用
- `BATCH_SIZE`: 100件（ワーカー内で定義）
- `EXPIRED_TOKEN_RETENTION`: 30日（モデルで定義）
- `ready_for_deletion`スコープ: `expires_at < 30日前`
- トークンはプレフィックス`glptt-`で識別可能
- トークンは暗号化して保存（`token_encrypted`カラム）
