---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-PipelineScheduleWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **想定処理件数**：具体的な根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/pipeline_schedule_worker.rb`
- E-02: `app/workers/run_pipeline_schedule_worker.rb`
- E-03: `config/initializers/1_settings.rb`
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチサイズは500件 | E-01 (BATCH_SIZE = 500) | ○ |
| C-02 | ディレイは7秒 | E-01 (DELAY = 7.seconds) | ○ |
| C-03 | ロックTTLは5分 | E-01 (LOCK_TTL = 5.minutes) | ○ |
| C-04 | リトライは3回 | E-01 (LOCK_RETRY = 3) | ○ |
| C-05 | cronは`3-59/10 * * * *` | E-03 (cron設定) | ○ |
| C-06 | feature_categoryはcontinuous_integration | E-01 (feature_category :continuous_integration) | ○ |
| C-07 | data_consistencyはalways | E-01 (data_consistency :always) | ○ |
| C-08 | worker_resource_boundaryはcpu | E-01 (worker_resource_boundary :cpu) | ○ |
| C-09 | CronjobQueueをinclude | E-01 (include CronjobQueue) | ○ |
| C-10 | ExclusiveLeaseHelpersをinclude | E-01 (include ::Gitlab::ExclusiveLeaseHelpers) | ○ |
| C-11 | runnable_schedulesスコープを使用 | E-01 (.runnable_schedules) | ○ |
| C-12 | preloadedスコープを使用 | E-01 (.preloaded) | ○ |
| C-13 | id, owner_id, project_idのみ選択 | E-01 (select(:id, :owner_id, :project_id)) | ○ |
| C-14 | bulk_perform_in_with_contextsでエンキュー | E-01 (RunPipelineScheduleWorker.bulk_perform_in_with_contexts) | ○ |
| C-15 | scheduling: trueパラメータを渡す | E-01 ({ scheduling: true }) | ○ |
| C-16 | idempotent!ではない | E-01 (rubocop:disable Scalability/IdempotentWorker) | ○ |
| C-17 | カテゴリはCI/CD | E-04 (バッチ一覧.csv) | ○ |
| C-18 | 想定処理件数は数千〜数万 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定処理件数の根拠がない
  - 候補：GitLab.comの運用データ / パフォーマンステスト結果 / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析により大部分の主張が検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] 想定処理件数の妥当性を確認（運用環境のデータから推定）
- [ ] cron設定が本番環境と一致しているか確認
- [ ] 排他制御のタイムアウト値が適切か確認
