---
generated_at: 2026-01-22 14:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-Ci_PipelineArtifacts_ExpireArtifactsWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/pipeline_artifacts/expire_artifacts_worker.rb`
- E-02: `app/services/ci/pipeline_artifacts/destroy_all_expired_service.rb`
- E-03: `config/initializers/1_settings.rb`
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | idempotent!が設定 | E-01 (idempotent!) | ○ |
| C-02 | data_consistencyはalways | E-01 (data_consistency :always) | ○ |
| C-03 | feature_categoryはjob_artifacts | E-01 (feature_category :job_artifacts) | ○ |
| C-04 | CronjobQueueをinclude | E-01 (include CronjobQueue) | ○ |
| C-05 | deduplicate :until_executed, including_scheduled: true | E-01 (deduplicate設定) | ○ |
| C-06 | DestroyAllExpiredServiceを実行 | E-01 (::Ci::PipelineArtifacts::DestroyAllExpiredService.new) | ○ |
| C-07 | log_extra_metadata_on_doneで削除件数記録 | E-01 (log_extra_metadata_on_done(:destroyed_pipeline_artifacts_count)) | ○ |
| C-08 | BATCH_SIZE = 100 | E-02 (BATCH_SIZE = 100) | ○ |
| C-09 | LOOP_LIMIT = 1000 | E-02 (LOOP_LIMIT = 1000) | ○ |
| C-10 | LOOP_TIMEOUT = 5.minutes | E-02 (LOOP_TIMEOUT = 5.minutes) | ○ |
| C-11 | LOCK_TIMEOUT = 10.minutes | E-02 (LOCK_TIMEOUT = 10.minutes) | ○ |
| C-12 | EXCLUSIVE_LOCK_KEY = 'expired_pipeline_artifacts:destroy:lock' | E-02 (EXCLUSIVE_LOCK_KEY) | ○ |
| C-13 | expired_before(@start_at)でフィルタ | E-02 (expired_before(@start_at)) | ○ |
| C-14 | artifact_unlockedスコープを使用 | E-02 (.artifact_unlocked) | ○ |
| C-15 | limit(BATCH_SIZE)で100件制限 | E-02 (.limit(BATCH_SIZE)) | ○ |
| C-16 | each(&:destroy!)で削除 | E-02 (artifacts.each(&:destroy!)) | ○ |
| C-17 | destroyed_artifacts_counterメトリクス | E-02 (destroyed_artifacts_counter.increment) | ○ |
| C-18 | destroyed_pipeline_artifacts_count_totalメトリクス名 | E-02 (:destroyed_pipeline_artifacts_count_total) | ○ |
| C-19 | cronは`*/23 * * * *` | E-03 (cron設定) | ○ |
| C-20 | カテゴリはアーティファクト管理 | E-04 (バッチ一覧.csv) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がコードから検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] パイプラインアーティファクトの有効期限設定の確認
- [ ] ジョブアーティファクト（ci_job_artifacts）との違いを理解
- [ ] Prometheusメトリクスの監視設定を確認
