---
generated_at: 2026-01-22 14:45:00
metrics:
  claims_total: 21
  claims_with_evidence: 19
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：100-ObjectStorage_DeleteStaleDirectUploadsWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：19 / 21、根拠なし：2
- 優先レビュー（高）
  1. **stale?メソッドの判定条件**：PendingDirectUploadクラスの確認が必要
  2. **Sidekiqリトライ回数のデフォルト値**：公式ドキュメント確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/object_storage/delete_stale_direct_uploads_worker.rb`
- E-02: `app/services/object_storage/delete_stale_direct_uploads_service.rb`
- E-03: `config/initializers/1_settings.rb`（行783-785）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cron設定は'*/6 * * * *'（6分ごと） | E-03 | ○ |
| C-02 | feature_categoryはjob_artifacts | E-01 | ○ |
| C-03 | data_consistency :stickyを使用 | E-01 | ○ |
| C-04 | idempotent!で冪等性保証 | E-01 | ○ |
| C-05 | CronjobQueueをinclude | E-01 | ○ |
| C-06 | deduplicate :until_executedを使用 | E-01 | ○ |
| C-07 | DeleteStaleDirectUploadsServiceを呼び出す | E-01, E-02 | ○ |
| C-08 | MAX_EXEC_DURATIONは250秒 | E-02 | ○ |
| C-09 | PendingDirectUpload.countで総数取得 | E-02 | ○ |
| C-10 | PendingDirectUpload.eachでイテレート | E-02 | ○ |
| C-11 | stale?メソッドで判定 | E-02 | ○ |
| C-12 | pending_upload.deleteで削除 | E-02 | ○ |
| C-13 | タイムアウト時にループを中断 | E-02 | ○ |
| C-14 | total_pending_entriesを返す | E-02 | ○ |
| C-15 | total_deleted_stale_entriesを返す | E-02 | ○ |
| C-16 | execution_timeoutを返す | E-02 | ○ |
| C-17 | successメソッドでServiceResponseを返す | E-02 | ○ |
| C-18 | log_extra_metadata_on_doneでメタデータ出力 | E-01 | ○ |
| C-19 | TODOコメントでfeature categoryについて言及 | E-01 | ○ |
| C-20 | stale?の判定条件（作成から一定時間経過） | **根拠なし** | △ |
| C-21 | Sidekiqリトライ回数は25回 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ObjectStorage::PendingDirectUploadクラスのstale?メソッドの定義
  - 候補：`lib/object_storage/pending_direct_upload.rb` または同等のファイル確認が必要
- Sidekiqのデフォルトリトライ回数の公式ドキュメント確認
  - 候補：Sidekiq公式ドキュメント / GitLab Sidekiq設定

## 5) リスクフラグ（レビュー観点）
- 1: stale?の判定条件が未確認（誤削除のリスク評価が必要）
- 0: タイムアウト制御（MAX_EXEC_DURATIONで適切に制御）
- 0: 重複排除（deduplicateで適切に設定）

## 6) レビュアーチェックリスト（最小）
- [ ] PendingDirectUploadクラスのstale?メソッドの判定条件確認
- [ ] MAX_EXEC_DURATION（250秒）が運用上適切か確認
- [ ] オブジェクトストレージへの影響確認
- [ ] 6分間隔の実行頻度が適切か確認
